/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui;

import com.compomics.util.Util;
import com.compomics.util.gui.VisibleTableColumnsDialog;
import com.compomics.util.gui.VisibleTableColumnsDialogParent;
import com.compomics.util.gui.XYPlotFiltersDialog;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.export.graphics.ExportGraphicsDialog;
import com.compomics.util.gui.export.graphics.ExportGraphicsDialogParent;
import com.compomics.util.gui.tablemodels.SelfUpdatingTableModel;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import no.uib.jsparklines.data.StartIndexes;
import no.uib.jsparklines.data.XYDataPoint;
import no.uib.jsparklines.renderers.JSparklinesIntegerColorTableCellRenderer;
import no.uib.jsparklines.renderers.util.AreaRenderer;
import no.uib.jsparklines.renderers.util.GradientColorCoding;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math.stat.regression.SimpleRegression;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.LogAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.StandardXYZToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.data.xy.XYZDataset;
import umontreal.iro.lecuyer.gof.KernelDensity;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.EmpiricalDist;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.randvar.KernelDensityGen;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.rng.MRG31k3p;
import umontreal.iro.lecuyer.rng.RandomStream;

public class XYPlottingDialog
extends JDialog
implements ExportGraphicsDialogParent,
VisibleTableColumnsDialogParent {
    private ProgressDialogX progressDialog;
    private TableModel tableModel;
    private ChartPanel chartPanel;
    private double bubbleSize = 1.0;
    private double bubbleScalingFactor = 1.0;
    private int numberOfBins = 100;
    private boolean userDefinedBinSize = false;
    private Frame dialogParent;
    private boolean isPlotting = false;
    private boolean mouseDragged = false;
    private Point dragStart;
    private Point dragEnd;
    private HashMap<Integer, ArrayList<Integer>> selectedDataPoints;
    private boolean selectionActive = false;
    private HashMap<String, Integer> dataPointToRowNumber;
    private ArrayList<Integer> selectedModelRows;
    private HashMap<Integer, TableCellRenderer> cellRenderers;
    private HashMap<Integer, Integer> maxColumnWidths;
    private HashMap<Integer, Integer> minColumnWidths;
    private ArrayList<String> tableToolTips;
    private GradientColorCoding.ColorGradient colorGradient = GradientColorCoding.ColorGradient.BlueWhiteGreen;
    private Color histogramColor = new Color(110, 196, 97);
    private String lastSelectedFolder = "user.home";
    private Image normalIcon;
    private Image waitingIcon;
    private ArrayList<TableColumn> allTableColumns;
    private HashMap<Integer, Boolean> visibleColumns;
    private boolean useGradientColorCoding = false;
    private boolean showRegressionLine = true;
    private HashMap<String, String> filters = new HashMap();
    private Vector<String> colummnNames;
    private ArrayList<Integer> rowsAfterDataFiltering = new ArrayList();
    private JPanel backgroundPanel;
    private JSpinner binSizeSpinner;
    private JLabel binsLabel;
    private JComboBox bubbleSizeComboBox;
    private JLabel bubbleSizeLabel;
    private JLabel colorLabel;
    private JComboBox colorsComboBox;
    private JPanel contextMenuPlotBackgroundPanel;
    private JPanel contextMenuSelectedValuesTableBackgroundPanel;
    private JRadioButton densityPlotRadioButton;
    private ButtonGroup dragButtonGroup;
    private JPanel dragSettingsPanel;
    private JRadioButton dragToSelectRadioButton;
    private JRadioButton dragToZoomRadioButton;
    private JButton editFiltersButton;
    private JMenuItem exportPlotMenuItem;
    private JMenuItem exportSelectedValuesMenuItem;
    private JPanel filterPanel;
    private JMenuItem hideColumnsMenuItem;
    private JRadioButton histogramRadioButton;
    private JPanel logAcisPanel;
    private JButton plotHelpJButton;
    private JLayeredPane plotLayeredPane;
    private JButton plotOptionsJButton;
    private JPanel plotPanel;
    private JPopupMenu plotPopupMenu;
    private ButtonGroup plotTypeButtonGroup;
    private JPanel plotTypePanel;
    private JCheckBoxMenuItem regressionLineCheckBoxMenuItem;
    private JLayeredPane selectedValuesLayeredPane;
    private JPanel selectedValuesPanel;
    private JScrollPane selectedValuesScrollPane;
    private JTable selectedValuesTable;
    private JButton selectedValuesTableHelpJButton;
    private JButton selectedValuesTableOptionsJButton;
    private JPopupMenu selectedValuesTablePopupMenu;
    private JCheckBox sizeLogCheckBox;
    private JComboBox xAxisComboBox;
    private JLabel xAxisLabel;
    private JCheckBox xAxisLogCheckBox;
    private JPanel xAxisPanel;
    private JPanel xyPlotPanel;
    private JRadioButton xyPlotRadioButton;
    private JComboBox yAxisComboBox;
    private JLabel yAxisLabel;
    private JCheckBox yAxisLogCheckBox;

    public XYPlottingDialog(Frame dialogParent, JTable table, ArrayList<String> tableToolTips, Image normalIcon, Image waitingIcon, boolean modal) {
        super(dialogParent, modal);
        this.initComponents();
        this.dialogParent = dialogParent;
        this.tableModel = table.getModel();
        this.normalIcon = normalIcon;
        this.waitingIcon = waitingIcon;
        this.cellRenderers = new HashMap();
        this.maxColumnWidths = new HashMap();
        this.minColumnWidths = new HashMap();
        if (table.getRowCount() > 0) {
            for (int i = 0; i < table.getColumnCount(); ++i) {
                this.cellRenderers.put(i, table.getCellRenderer(0, i));
                this.minColumnWidths.put(i, table.getColumn(table.getColumnName(i)).getMinWidth());
                this.maxColumnWidths.put(i, table.getColumn(table.getColumnName(i)).getMaxWidth());
            }
        }
        this.tableToolTips = tableToolTips;
        this.setUpGUI();
        this.updatePlot();
        this.setLocationRelativeTo(dialogParent);
        this.backgroundPanelComponentResized(null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                XYPlottingDialog.this.setVisible(true);
            }
        });
    }

    private void setUpGUI() {
        int i;
        this.colummnNames = new Vector();
        Vector<String> colummnNamesExtended = new Vector<String>();
        colummnNamesExtended.add(0, "[user defined]");
        int columnCount = this.tableModel.getColumnCount();
        for (i = 0; i < columnCount; ++i) {
            if (this.tableModel.getColumnName(i).trim().length() == 0) {
                this.colummnNames.add("(column " + (i + 1) + ")");
                colummnNamesExtended.add("(column " + (i + 1) + ")");
                continue;
            }
            this.colummnNames.add(this.tableModel.getColumnName(i));
            colummnNamesExtended.add(this.tableModel.getColumnName(i));
        }
        this.xAxisComboBox.setModel(new DefaultComboBoxModel<String>(this.colummnNames));
        this.yAxisComboBox.setModel(new DefaultComboBoxModel<String>(this.colummnNames));
        this.colorsComboBox.setModel(new DefaultComboBoxModel<String>(this.colummnNames));
        this.bubbleSizeComboBox.setModel(new DefaultComboBoxModel(colummnNamesExtended));
        this.selectedValuesTable.setModel(this.tableModel);
        this.allTableColumns = new ArrayList();
        this.visibleColumns = new HashMap();
        for (i = 0; i < this.selectedValuesTable.getColumnCount(); ++i) {
            this.allTableColumns.add(this.selectedValuesTable.getColumn(this.selectedValuesTable.getColumnName(i)));
            this.visibleColumns.put(i, true);
        }
        this.selectedValuesScrollPane.getViewport().setOpaque(false);
        this.selectedValuesTable.getTableHeader().setReorderingAllowed(false);
        if (this.tableModel instanceof SelfUpdatingTableModel) {
            SelfUpdatingTableModel.addSortListener(this.selectedValuesTable, new ProgressDialogX(this.dialogParent, this.normalIcon, this.waitingIcon, true));
        } else {
            this.selectedValuesTable.setAutoCreateRowSorter(true);
        }
        for (Integer columnIndex : this.cellRenderers.keySet()) {
            this.selectedValuesTable.getColumn(this.selectedValuesTable.getColumnName(columnIndex)).setCellRenderer(this.cellRenderers.get(columnIndex));
        }
        for (Integer columnIndex : this.minColumnWidths.keySet()) {
            this.selectedValuesTable.getColumn(this.selectedValuesTable.getColumnName(columnIndex)).setMinWidth(this.minColumnWidths.get(columnIndex));
        }
        for (Integer columnIndex : this.maxColumnWidths.keySet()) {
            this.selectedValuesTable.getColumn(this.selectedValuesTable.getColumnName(columnIndex)).setMaxWidth(this.maxColumnWidths.get(columnIndex));
        }
        JPanel selectedValuesCorner = new JPanel();
        selectedValuesCorner.setBackground(this.selectedValuesTable.getTableHeader().getBackground());
        this.selectedValuesScrollPane.setCorner("UPPER_RIGHT_CORNER", selectedValuesCorner);
    }

    private void initComponents() {
        this.plotTypeButtonGroup = new ButtonGroup();
        this.dragButtonGroup = new ButtonGroup();
        this.plotPopupMenu = new JPopupMenu();
        this.exportPlotMenuItem = new JMenuItem();
        this.regressionLineCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.selectedValuesTablePopupMenu = new JPopupMenu();
        this.exportSelectedValuesMenuItem = new JMenuItem();
        this.hideColumnsMenuItem = new JMenuItem();
        this.backgroundPanel = new JPanel();
        this.plotTypePanel = new JPanel();
        this.densityPlotRadioButton = new JRadioButton();
        this.histogramRadioButton = new JRadioButton();
        this.xyPlotRadioButton = new JRadioButton();
        this.xAxisPanel = new JPanel();
        this.xAxisComboBox = new JComboBox();
        this.xAxisLabel = new JLabel();
        this.yAxisComboBox = new JComboBox();
        this.yAxisLabel = new JLabel();
        this.colorLabel = new JLabel();
        this.colorsComboBox = new JComboBox();
        this.bubbleSizeLabel = new JLabel();
        this.bubbleSizeComboBox = new JComboBox();
        this.binSizeSpinner = new JSpinner();
        this.binsLabel = new JLabel();
        this.dragSettingsPanel = new JPanel();
        this.dragToSelectRadioButton = new JRadioButton();
        this.dragToZoomRadioButton = new JRadioButton();
        this.logAcisPanel = new JPanel();
        this.xAxisLogCheckBox = new JCheckBox();
        this.yAxisLogCheckBox = new JCheckBox();
        this.sizeLogCheckBox = new JCheckBox();
        this.selectedValuesLayeredPane = new JLayeredPane();
        this.selectedValuesPanel = new JPanel();
        this.selectedValuesScrollPane = new JScrollPane();
        this.selectedValuesTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)XYPlottingDialog.this.tableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.selectedValuesTableOptionsJButton = new JButton();
        this.selectedValuesTableHelpJButton = new JButton();
        this.contextMenuSelectedValuesTableBackgroundPanel = new JPanel();
        this.plotLayeredPane = new JLayeredPane();
        this.xyPlotPanel = new JPanel();
        this.plotPanel = new JPanel();
        this.plotOptionsJButton = new JButton();
        this.plotHelpJButton = new JButton();
        this.contextMenuPlotBackgroundPanel = new JPanel();
        this.filterPanel = new JPanel();
        this.editFiltersButton = new JButton();
        this.exportPlotMenuItem.setText("Export");
        this.exportPlotMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XYPlottingDialog.this.exportPlotMenuItemActionPerformed(evt);
            }
        });
        this.plotPopupMenu.add(this.exportPlotMenuItem);
        this.regressionLineCheckBoxMenuItem.setSelected(true);
        this.regressionLineCheckBoxMenuItem.setText("Regression Line");
        this.regressionLineCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XYPlottingDialog.this.regressionLineCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.plotPopupMenu.add(this.regressionLineCheckBoxMenuItem);
        this.exportSelectedValuesMenuItem.setText("Export");
        this.exportSelectedValuesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XYPlottingDialog.this.exportSelectedValuesMenuItemActionPerformed(evt);
            }
        });
        this.selectedValuesTablePopupMenu.add(this.exportSelectedValuesMenuItem);
        this.hideColumnsMenuItem.setText("Hide/Show Columns");
        this.hideColumnsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XYPlottingDialog.this.hideColumnsMenuItemActionPerformed(evt);
            }
        });
        this.selectedValuesTablePopupMenu.add(this.hideColumnsMenuItem);
        this.setDefaultCloseOperation(2);
        this.setTitle("Statistics (beta)");
        this.setMinimumSize(new Dimension(800, 700));
        this.backgroundPanel.setBackground(new Color(255, 255, 255));
        this.backgroundPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                XYPlottingDialog.this.backgroundPanelComponentResized(evt);
            }
        });
        this.plotTypePanel.setBorder(BorderFactory.createTitledBorder("Plot Type"));
        this.plotTypePanel.setOpaque(false);
        this.plotTypeButtonGroup.add(this.densityPlotRadioButton);
        this.densityPlotRadioButton.setText("Density");
        this.densityPlotRadioButton.setIconTextGap(10);
        this.densityPlotRadioButton.setOpaque(false);
        this.densityPlotRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XYPlottingDialog.this.densityPlotRadioButtonActionPerformed(evt);
            }
        });
        this.plotTypeButtonGroup.add(this.histogramRadioButton);
        this.histogramRadioButton.setText("Histogram");
        this.histogramRadioButton.setIconTextGap(10);
        this.histogramRadioButton.setOpaque(false);
        this.histogramRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XYPlottingDialog.this.histogramRadioButtonActionPerformed(evt);
            }
        });
        this.plotTypeButtonGroup.add(this.xyPlotRadioButton);
        this.xyPlotRadioButton.setSelected(true);
        this.xyPlotRadioButton.setText("XY Plot");
        this.xyPlotRadioButton.setIconTextGap(10);
        this.xyPlotRadioButton.setOpaque(false);
        this.xyPlotRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XYPlottingDialog.this.xyPlotRadioButtonActionPerformed(evt);
            }
        });
        GroupLayout plotTypePanelLayout = new GroupLayout(this.plotTypePanel);
        this.plotTypePanel.setLayout(plotTypePanelLayout);
        plotTypePanelLayout.setHorizontalGroup(plotTypePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotTypePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.xyPlotRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.histogramRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.densityPlotRadioButton).addContainerGap()));
        plotTypePanelLayout.setVerticalGroup(plotTypePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotTypePanelLayout.createSequentialGroup().addContainerGap().addGroup(plotTypePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.densityPlotRadioButton).addComponent(this.histogramRadioButton).addComponent(this.xyPlotRadioButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.xAxisPanel.setBorder(BorderFactory.createTitledBorder("Values"));
        this.xAxisPanel.setOpaque(false);
        this.xAxisComboBox.setMaximumRowCount(30);
        this.xAxisComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XYPlottingDialog.this.xAxisComboBoxActionPerformed(evt);
            }
        });
        this.xAxisLabel.setText("<html>\n<a href>X Axis</a>\n</html>");
        this.xAxisLabel.setToolTipText("Click to swap x and y axis");
        this.xAxisLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                XYPlottingDialog.this.xAxisLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XYPlottingDialog.this.xAxisLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XYPlottingDialog.this.xAxisLabelMouseExited(evt);
            }
        });
        this.yAxisComboBox.setMaximumRowCount(30);
        this.yAxisComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XYPlottingDialog.this.yAxisComboBoxActionPerformed(evt);
            }
        });
        this.yAxisLabel.setText("<html>\n<a href>Y Axis</a>\n</html>");
        this.yAxisLabel.setToolTipText("Click to swap x and y axis");
        this.yAxisLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                XYPlottingDialog.this.yAxisLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XYPlottingDialog.this.yAxisLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XYPlottingDialog.this.yAxisLabelMouseExited(evt);
            }
        });
        this.colorLabel.setText("<html> <a href>Color</a> </html>");
        this.colorLabel.setToolTipText("Click to enable gradient colors");
        this.colorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                XYPlottingDialog.this.colorLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XYPlottingDialog.this.colorLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XYPlottingDialog.this.colorLabelMouseExited(evt);
            }
        });
        this.colorsComboBox.setMaximumRowCount(30);
        this.colorsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XYPlottingDialog.this.colorsComboBoxActionPerformed(evt);
            }
        });
        this.bubbleSizeLabel.setText("<html> <a href>Size</a> </html>");
        this.bubbleSizeLabel.setToolTipText("Click to change the bubble scaling factor");
        this.bubbleSizeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                XYPlottingDialog.this.bubbleSizeLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XYPlottingDialog.this.bubbleSizeLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XYPlottingDialog.this.bubbleSizeLabelMouseExited(evt);
            }
        });
        this.bubbleSizeComboBox.setMaximumRowCount(30);
        this.bubbleSizeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XYPlottingDialog.this.bubbleSizeComboBoxActionPerformed(evt);
            }
        });
        this.binSizeSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.binSizeSpinner.setToolTipText("The size of the bubbles relative to the x-axis");
        this.binSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                XYPlottingDialog.this.binSizeSpinnerStateChanged(evt);
            }
        });
        this.binsLabel.setText("Bins");
        GroupLayout xAxisPanelLayout = new GroupLayout(this.xAxisPanel);
        this.xAxisPanel.setLayout(xAxisPanelLayout);
        xAxisPanelLayout.setHorizontalGroup(xAxisPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(xAxisPanelLayout.createSequentialGroup().addContainerGap().addGroup(xAxisPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.xAxisLabel, -2, -1, -2).addComponent(this.yAxisLabel, -2, -1, -2).addComponent(this.colorLabel, -2, -1, -2).addComponent(this.bubbleSizeLabel, -2, -1, -2).addComponent(this.binsLabel)).addGap(18, 18, 18).addGroup(xAxisPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.yAxisComboBox, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.bubbleSizeComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.colorsComboBox, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.xAxisComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.binSizeSpinner)).addContainerGap()));
        xAxisPanelLayout.setVerticalGroup(xAxisPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(xAxisPanelLayout.createSequentialGroup().addContainerGap().addGroup(xAxisPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.xAxisComboBox, -2, -1, -2).addComponent(this.xAxisLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(xAxisPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.yAxisComboBox, -2, -1, -2).addComponent(this.yAxisLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(xAxisPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bubbleSizeLabel, -2, -1, -2).addComponent(this.bubbleSizeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(xAxisPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.colorLabel, -2, -1, -2).addComponent(this.colorsComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(xAxisPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.binSizeSpinner, -2, -1, -2).addComponent(this.binsLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.dragSettingsPanel.setBorder(BorderFactory.createTitledBorder("Select vs. Zoom"));
        this.dragSettingsPanel.setOpaque(false);
        this.dragButtonGroup.add(this.dragToSelectRadioButton);
        this.dragToSelectRadioButton.setSelected(true);
        this.dragToSelectRadioButton.setText("Drag to Select");
        this.dragToSelectRadioButton.setIconTextGap(15);
        this.dragToSelectRadioButton.setOpaque(false);
        this.dragButtonGroup.add(this.dragToZoomRadioButton);
        this.dragToZoomRadioButton.setText("Drag to Zoom");
        this.dragToZoomRadioButton.setIconTextGap(15);
        this.dragToZoomRadioButton.setOpaque(false);
        GroupLayout dragSettingsPanelLayout = new GroupLayout(this.dragSettingsPanel);
        this.dragSettingsPanel.setLayout(dragSettingsPanelLayout);
        dragSettingsPanelLayout.setHorizontalGroup(dragSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dragSettingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.dragToSelectRadioButton, -2, 110, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.dragToZoomRadioButton, -2, 110, -2).addContainerGap(-1, Short.MAX_VALUE)));
        dragSettingsPanelLayout.linkSize(0, this.dragToSelectRadioButton, this.dragToZoomRadioButton);
        dragSettingsPanelLayout.setVerticalGroup(dragSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dragSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(dragSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dragToSelectRadioButton).addComponent(this.dragToZoomRadioButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.logAcisPanel.setBorder(BorderFactory.createTitledBorder("Logarithmic Values"));
        this.logAcisPanel.setOpaque(false);
        this.xAxisLogCheckBox.setText("X Axis");
        this.xAxisLogCheckBox.setToolTipText("Use logarithmic axis");
        this.xAxisLogCheckBox.setIconTextGap(15);
        this.xAxisLogCheckBox.setOpaque(false);
        this.xAxisLogCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XYPlottingDialog.this.xAxisLogCheckBoxActionPerformed(evt);
            }
        });
        this.yAxisLogCheckBox.setText("Y Axis");
        this.yAxisLogCheckBox.setToolTipText("Use logarithmic axis");
        this.yAxisLogCheckBox.setIconTextGap(15);
        this.yAxisLogCheckBox.setOpaque(false);
        this.yAxisLogCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XYPlottingDialog.this.yAxisLogCheckBoxActionPerformed(evt);
            }
        });
        this.sizeLogCheckBox.setText("Size");
        this.sizeLogCheckBox.setToolTipText("Use logarithmic scaling for the size");
        this.sizeLogCheckBox.setIconTextGap(15);
        this.sizeLogCheckBox.setOpaque(false);
        this.sizeLogCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XYPlottingDialog.this.sizeLogCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout logAcisPanelLayout = new GroupLayout(this.logAcisPanel);
        this.logAcisPanel.setLayout(logAcisPanelLayout);
        logAcisPanelLayout.setHorizontalGroup(logAcisPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(logAcisPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.xAxisLogCheckBox, -1, -1, Short.MAX_VALUE).addGap(9, 9, 9).addComponent(this.yAxisLogCheckBox, -1, -1, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(this.sizeLogCheckBox, -1, -1, Short.MAX_VALUE).addGap(14, 14, 14)));
        logAcisPanelLayout.setVerticalGroup(logAcisPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(logAcisPanelLayout.createSequentialGroup().addContainerGap().addGroup(logAcisPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.xAxisLogCheckBox).addComponent(this.yAxisLogCheckBox).addComponent(this.sizeLogCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        this.selectedValuesPanel.setBorder(BorderFactory.createTitledBorder("Selected Values"));
        this.selectedValuesPanel.setOpaque(false);
        this.selectedValuesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XYPlottingDialog.this.selectedValuesTableMouseReleased(evt);
            }
        });
        this.selectedValuesTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                XYPlottingDialog.this.selectedValuesTableKeyReleased(evt);
            }
        });
        this.selectedValuesScrollPane.setViewportView(this.selectedValuesTable);
        GroupLayout selectedValuesPanelLayout = new GroupLayout(this.selectedValuesPanel);
        this.selectedValuesPanel.setLayout(selectedValuesPanelLayout);
        selectedValuesPanelLayout.setHorizontalGroup(selectedValuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(selectedValuesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.selectedValuesScrollPane, -1, 1038, Short.MAX_VALUE).addContainerGap()));
        selectedValuesPanelLayout.setVerticalGroup(selectedValuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(selectedValuesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.selectedValuesScrollPane, -1, 145, Short.MAX_VALUE).addContainerGap()));
        this.selectedValuesPanel.setBounds(0, 0, 1070, 190);
        this.selectedValuesLayeredPane.add((Component)this.selectedValuesPanel, JLayeredPane.DEFAULT_LAYER);
        this.selectedValuesTableOptionsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/contextual_menu_gray.png")));
        this.selectedValuesTableOptionsJButton.setToolTipText("Table Options");
        this.selectedValuesTableOptionsJButton.setBorder(null);
        this.selectedValuesTableOptionsJButton.setBorderPainted(false);
        this.selectedValuesTableOptionsJButton.setContentAreaFilled(false);
        this.selectedValuesTableOptionsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/contextual_menu_black.png")));
        this.selectedValuesTableOptionsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                XYPlottingDialog.this.selectedValuesTableOptionsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XYPlottingDialog.this.selectedValuesTableOptionsJButtonMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                XYPlottingDialog.this.selectedValuesTableOptionsJButtonMouseReleased(evt);
            }
        });
        this.selectedValuesTableOptionsJButton.setBounds(1025, 5, 10, 19);
        this.selectedValuesLayeredPane.add((Component)this.selectedValuesTableOptionsJButton, JLayeredPane.POPUP_LAYER);
        this.selectedValuesTableHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.selectedValuesTableHelpJButton.setToolTipText("Help");
        this.selectedValuesTableHelpJButton.setBorder(null);
        this.selectedValuesTableHelpJButton.setBorderPainted(false);
        this.selectedValuesTableHelpJButton.setContentAreaFilled(false);
        this.selectedValuesTableHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.selectedValuesTableHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                XYPlottingDialog.this.selectedValuesTableHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XYPlottingDialog.this.selectedValuesTableHelpJButtonMouseExited(evt);
            }
        });
        this.selectedValuesTableHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XYPlottingDialog.this.selectedValuesTableHelpJButtonActionPerformed(evt);
            }
        });
        this.selectedValuesTableHelpJButton.setBounds(1035, 0, 10, 19);
        this.selectedValuesLayeredPane.add((Component)this.selectedValuesTableHelpJButton, JLayeredPane.POPUP_LAYER);
        this.contextMenuSelectedValuesTableBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuSelectedValuesTableBackgroundPanelLayout = new GroupLayout(this.contextMenuSelectedValuesTableBackgroundPanel);
        this.contextMenuSelectedValuesTableBackgroundPanel.setLayout(contextMenuSelectedValuesTableBackgroundPanelLayout);
        contextMenuSelectedValuesTableBackgroundPanelLayout.setHorizontalGroup(contextMenuSelectedValuesTableBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        contextMenuSelectedValuesTableBackgroundPanelLayout.setVerticalGroup(contextMenuSelectedValuesTableBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.contextMenuSelectedValuesTableBackgroundPanel.setBounds(1010, 0, 30, 19);
        this.selectedValuesLayeredPane.add((Component)this.contextMenuSelectedValuesTableBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.xyPlotPanel.setBorder(BorderFactory.createTitledBorder("XY Plot"));
        this.xyPlotPanel.setOpaque(false);
        this.plotPanel.setBackground(new Color(255, 255, 255));
        this.plotPanel.setLayout(new BoxLayout(this.plotPanel, 2));
        GroupLayout xyPlotPanelLayout = new GroupLayout(this.xyPlotPanel);
        this.xyPlotPanel.setLayout(xyPlotPanelLayout);
        xyPlotPanelLayout.setHorizontalGroup(xyPlotPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(xyPlotPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.plotPanel, -1, 778, Short.MAX_VALUE).addContainerGap()));
        xyPlotPanelLayout.setVerticalGroup(xyPlotPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(xyPlotPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.plotPanel, -1, 395, Short.MAX_VALUE).addContainerGap()));
        this.xyPlotPanel.setBounds(0, 0, 810, 440);
        this.plotLayeredPane.add((Component)this.xyPlotPanel, JLayeredPane.DEFAULT_LAYER);
        this.plotOptionsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/contextual_menu_gray.png")));
        this.plotOptionsJButton.setToolTipText("Plot Options");
        this.plotOptionsJButton.setBorder(null);
        this.plotOptionsJButton.setBorderPainted(false);
        this.plotOptionsJButton.setContentAreaFilled(false);
        this.plotOptionsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/contextual_menu_black.png")));
        this.plotOptionsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                XYPlottingDialog.this.plotOptionsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XYPlottingDialog.this.plotOptionsJButtonMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                XYPlottingDialog.this.plotOptionsJButtonMouseReleased(evt);
            }
        });
        this.plotOptionsJButton.setBounds(770, 5, 10, 19);
        this.plotLayeredPane.add((Component)this.plotOptionsJButton, JLayeredPane.POPUP_LAYER);
        this.plotHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.plotHelpJButton.setToolTipText("Help");
        this.plotHelpJButton.setBorder(null);
        this.plotHelpJButton.setBorderPainted(false);
        this.plotHelpJButton.setContentAreaFilled(false);
        this.plotHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.plotHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                XYPlottingDialog.this.plotHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XYPlottingDialog.this.plotHelpJButtonMouseExited(evt);
            }
        });
        this.plotHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XYPlottingDialog.this.plotHelpJButtonActionPerformed(evt);
            }
        });
        this.plotHelpJButton.setBounds(780, 0, 10, 19);
        this.plotLayeredPane.add((Component)this.plotHelpJButton, JLayeredPane.POPUP_LAYER);
        this.contextMenuPlotBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuPlotBackgroundPanelLayout = new GroupLayout(this.contextMenuPlotBackgroundPanel);
        this.contextMenuPlotBackgroundPanel.setLayout(contextMenuPlotBackgroundPanelLayout);
        contextMenuPlotBackgroundPanelLayout.setHorizontalGroup(contextMenuPlotBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        contextMenuPlotBackgroundPanelLayout.setVerticalGroup(contextMenuPlotBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.contextMenuPlotBackgroundPanel.setBounds(770, 0, 30, 19);
        this.plotLayeredPane.add((Component)this.contextMenuPlotBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.filterPanel.setBorder(BorderFactory.createTitledBorder("Filters"));
        this.filterPanel.setOpaque(false);
        this.editFiltersButton.setText("Edit Data Filters");
        this.editFiltersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XYPlottingDialog.this.editFiltersButtonActionPerformed(evt);
            }
        });
        GroupLayout filterPanelLayout = new GroupLayout(this.filterPanel);
        this.filterPanel.setLayout(filterPanelLayout);
        filterPanelLayout.setHorizontalGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.editFiltersButton, -1, -1, Short.MAX_VALUE).addContainerGap()));
        filterPanelLayout.setVerticalGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.editFiltersButton).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectedValuesLayeredPane).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addComponent(this.plotLayeredPane, -1, 817, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.xAxisPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.dragSettingsPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.logAcisPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.plotTypePanel, -1, -1, Short.MAX_VALUE).addComponent(this.filterPanel, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addComponent(this.plotTypePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xAxisPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logAcisPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dragSettingsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterPanel, -2, -1, -2)).addComponent(this.plotLayeredPane)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectedValuesLayeredPane, -1, 188, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void xAxisComboBoxActionPerformed(ActionEvent evt) {
        this.updatePlot();
    }

    private void yAxisComboBoxActionPerformed(ActionEvent evt) {
        this.updatePlot();
    }

    private void colorsComboBoxActionPerformed(ActionEvent evt) {
        this.updatePlot();
    }

    private void binSizeSpinnerStateChanged(ChangeEvent evt) {
        this.numberOfBins = (Integer)this.binSizeSpinner.getValue();
        this.userDefinedBinSize = true;
        this.updatePlot();
    }

    private void selectedValuesTableKeyReleased(KeyEvent evt) {
        this.chartPanel.getChart().fireChartChanged();
    }

    private void selectedValuesTableMouseReleased(MouseEvent evt) {
        this.chartPanel.getChart().fireChartChanged();
    }

    private void xAxisLogCheckBoxActionPerformed(ActionEvent evt) {
        this.updatePlot();
    }

    private void yAxisLogCheckBoxActionPerformed(ActionEvent evt) {
        this.updatePlot();
    }

    private void densityPlotRadioButtonActionPerformed(ActionEvent evt) {
        this.histogramRadioButtonActionPerformed(null);
    }

    private void histogramRadioButtonActionPerformed(ActionEvent evt) {
        this.yAxisLabel.setEnabled(this.xyPlotRadioButton.isSelected());
        this.yAxisComboBox.setEnabled(this.xyPlotRadioButton.isSelected());
        this.colorLabel.setEnabled(this.xyPlotRadioButton.isSelected());
        this.colorsComboBox.setEnabled(this.xyPlotRadioButton.isSelected());
        this.bubbleSizeLabel.setEnabled(this.xyPlotRadioButton.isSelected());
        this.bubbleSizeComboBox.setEnabled(this.xyPlotRadioButton.isSelected());
        this.dragToSelectRadioButton.setEnabled(this.xyPlotRadioButton.isSelected());
        this.dragToZoomRadioButton.setEnabled(this.xyPlotRadioButton.isSelected());
        this.regressionLineCheckBoxMenuItem.setEnabled(this.xyPlotRadioButton.isSelected());
        this.binsLabel.setEnabled(this.histogramRadioButton.isSelected());
        this.binSizeSpinner.setEnabled(this.histogramRadioButton.isSelected());
        this.updatePlot();
    }

    private void xAxisLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void xAxisLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void xAxisLabelMouseClicked(MouseEvent evt) {
        String xAxis = (String)this.xAxisComboBox.getSelectedItem();
        String yAxis = (String)this.yAxisComboBox.getSelectedItem();
        this.xAxisComboBox.setSelectedItem(yAxis);
        this.yAxisComboBox.setSelectedItem(xAxis);
    }

    private void yAxisLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void yAxisLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void yAxisLabelMouseClicked(MouseEvent evt) {
        this.xAxisLabelMouseClicked(null);
    }

    private void xyPlotRadioButtonActionPerformed(ActionEvent evt) {
        this.histogramRadioButtonActionPerformed(null);
    }

    private void bubbleSizeComboBoxActionPerformed(ActionEvent evt) {
        if (this.bubbleSizeComboBox.getSelectedIndex() == 0) {
            String value = JOptionPane.showInputDialog(this, "Select the bubble size.", this.bubbleSize);
            if (value != null) {
                try {
                    this.bubbleSize = new Double(value);
                    this.updatePlot();
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, "Bubble size has to be a number.", "Bubble Size Error", 0);
                    this.bubbleSizeComboBoxActionPerformed(null);
                }
            }
        } else {
            this.updatePlot();
        }
    }

    private void bubbleSizeLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void bubbleSizeLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void bubbleSizeLabelMouseClicked(MouseEvent evt) {
        String value = JOptionPane.showInputDialog(this, "Select the bubble scaling factor.\nA value of 1 means no scaling.", this.bubbleScalingFactor);
        if (value != null) {
            try {
                double tempBubbleScalingFactor = new Double(value);
                if (tempBubbleScalingFactor > 0.0) {
                    this.bubbleScalingFactor = tempBubbleScalingFactor;
                    this.updatePlot();
                } else {
                    JOptionPane.showMessageDialog(this, "The bubble scaling factor has to be bigger than 0.", "Bubble Scaling Error", 0);
                    this.bubbleSizeComboBoxActionPerformed(null);
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Bubble scaling factor has to be a number.", "Bubble Scaling Error", 0);
                this.bubbleSizeComboBoxActionPerformed(null);
            }
        }
    }

    private void backgroundPanelComponentResized(ComponentEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                XYPlottingDialog.this.selectedValuesLayeredPane.getComponent(0).setBounds(XYPlottingDialog.this.selectedValuesLayeredPane.getWidth() - XYPlottingDialog.this.selectedValuesLayeredPane.getComponent(0).getWidth() - 22, -2, XYPlottingDialog.this.selectedValuesLayeredPane.getComponent(0).getWidth(), XYPlottingDialog.this.selectedValuesLayeredPane.getComponent(0).getHeight());
                XYPlottingDialog.this.selectedValuesLayeredPane.getComponent(1).setBounds(XYPlottingDialog.this.selectedValuesLayeredPane.getWidth() - XYPlottingDialog.this.selectedValuesLayeredPane.getComponent(1).getWidth() - 10, -4, XYPlottingDialog.this.selectedValuesLayeredPane.getComponent(1).getWidth(), XYPlottingDialog.this.selectedValuesLayeredPane.getComponent(1).getHeight());
                XYPlottingDialog.this.selectedValuesLayeredPane.getComponent(2).setBounds(XYPlottingDialog.this.selectedValuesLayeredPane.getWidth() - XYPlottingDialog.this.selectedValuesLayeredPane.getComponent(2).getWidth() - 5, -3, XYPlottingDialog.this.selectedValuesLayeredPane.getComponent(2).getWidth(), XYPlottingDialog.this.selectedValuesLayeredPane.getComponent(2).getHeight());
                XYPlottingDialog.this.selectedValuesLayeredPane.getComponent(3).setBounds(0, 0, XYPlottingDialog.this.selectedValuesLayeredPane.getWidth(), XYPlottingDialog.this.selectedValuesLayeredPane.getHeight());
                XYPlottingDialog.this.selectedValuesLayeredPane.revalidate();
                XYPlottingDialog.this.selectedValuesLayeredPane.repaint();
                XYPlottingDialog.this.plotLayeredPane.getComponent(0).setBounds(XYPlottingDialog.this.plotLayeredPane.getWidth() - XYPlottingDialog.this.plotLayeredPane.getComponent(0).getWidth() - 22, -2, XYPlottingDialog.this.plotLayeredPane.getComponent(0).getWidth(), XYPlottingDialog.this.plotLayeredPane.getComponent(0).getHeight());
                XYPlottingDialog.this.plotLayeredPane.getComponent(1).setBounds(XYPlottingDialog.this.plotLayeredPane.getWidth() - XYPlottingDialog.this.plotLayeredPane.getComponent(1).getWidth() - 10, -4, XYPlottingDialog.this.plotLayeredPane.getComponent(1).getWidth(), XYPlottingDialog.this.plotLayeredPane.getComponent(1).getHeight());
                XYPlottingDialog.this.plotLayeredPane.getComponent(2).setBounds(XYPlottingDialog.this.plotLayeredPane.getWidth() - XYPlottingDialog.this.plotLayeredPane.getComponent(2).getWidth() - 5, -3, XYPlottingDialog.this.plotLayeredPane.getComponent(2).getWidth(), XYPlottingDialog.this.plotLayeredPane.getComponent(2).getHeight());
                XYPlottingDialog.this.plotLayeredPane.getComponent(3).setBounds(0, 0, XYPlottingDialog.this.plotLayeredPane.getWidth(), XYPlottingDialog.this.plotLayeredPane.getHeight());
                XYPlottingDialog.this.plotLayeredPane.revalidate();
                XYPlottingDialog.this.plotLayeredPane.repaint();
            }
        });
    }

    private void selectedValuesTableOptionsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void selectedValuesTableOptionsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void selectedValuesTableOptionsJButtonMouseReleased(MouseEvent evt) {
        this.selectedValuesTablePopupMenu.show(this.selectedValuesTableOptionsJButton, evt.getX(), evt.getY());
    }

    private void plotOptionsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void plotOptionsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void plotOptionsJButtonMouseReleased(MouseEvent evt) {
        this.plotPopupMenu.show(this.plotOptionsJButton, evt.getX(), evt.getY());
    }

    private void exportPlotMenuItemActionPerformed(ActionEvent evt) {
        new ExportGraphicsDialog((JDialog)this, (ExportGraphicsDialogParent)this, true, this.chartPanel);
    }

    private void exportSelectedValuesMenuItemActionPerformed(ActionEvent evt) {
        final File selectedFile = Util.getUserSelectedFile(this, ".txt", "(tab separated text file)", "Export Selected Values", this.lastSelectedFolder, false);
        final XYPlottingDialog finalRef = this;
        if (selectedFile != null) {
            this.progressDialog = new ProgressDialogX(this, this.dialogParent, this.normalIcon, this.waitingIcon, true);
            this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
            this.progressDialog.setTitle("Exporting Table. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        XYPlottingDialog.this.progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("TableExportThread"){

                @Override
                public void run() {
                    try {
                        BufferedWriter writer = new BufferedWriter(new FileWriter(selectedFile));
                        Util.tableToFile(XYPlottingDialog.this.selectedValuesTable, "\t", XYPlottingDialog.this.progressDialog, true, writer);
                        writer.close();
                        boolean processCancelled = XYPlottingDialog.this.progressDialog.isRunCanceled();
                        XYPlottingDialog.this.progressDialog.setRunFinished();
                        if (!processCancelled) {
                            JOptionPane.showMessageDialog(finalRef, "Data copied to file:\n" + selectedFile.getAbsolutePath(), "Data Exported.", 1);
                        }
                    }
                    catch (IOException e) {
                        XYPlottingDialog.this.progressDialog.setRunFinished();
                        JOptionPane.showMessageDialog(null, "An error occured when exporting the table content.", "Export Failed", 0);
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    private void plotHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void plotHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void plotHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/StatisticsDialog.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), "Statistics - Help");
        this.setCursor(new Cursor(0));
    }

    private void selectedValuesTableHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void selectedValuesTableHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void selectedValuesTableHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/StatisticsDialog.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), "Statistics - Help");
        this.setCursor(new Cursor(0));
    }

    private void hideColumnsMenuItemActionPerformed(ActionEvent evt) {
        new VisibleTableColumnsDialog(this, (VisibleTableColumnsDialogParent)this, this.isPlotting);
    }

    private void colorLabelMouseClicked(MouseEvent evt) {
        this.useGradientColorCoding = !this.useGradientColorCoding;
        this.updatePlot();
        if (this.useGradientColorCoding) {
            this.colorLabel.setToolTipText("Click to disable gradient colors");
        } else {
            this.colorLabel.setToolTipText("Click to enable gradient colors");
        }
    }

    private void colorLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void colorLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void regressionLineCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.showRegressionLine = this.regressionLineCheckBoxMenuItem.isSelected();
        this.updatePlot();
    }

    private void sizeLogCheckBoxActionPerformed(ActionEvent evt) {
        this.updatePlot();
    }

    private void editFiltersButtonActionPerformed(ActionEvent evt) {
        new XYPlotFiltersDialog(this, true);
    }

    public void updatePlot() {
        if (!this.isPlotting) {
            this.selectedDataPoints = new HashMap();
            this.dataPointToRowNumber = new HashMap();
            this.selectedModelRows = new ArrayList();
            this.isPlotting = true;
            this.progressDialog = new ProgressDialogX(this, this.dialogParent, this.normalIcon, this.waitingIcon, true);
            this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
            this.progressDialog.setTitle("Loading Data. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        XYPlottingDialog.this.progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("XYPlottingThread"){

                @Override
                public void run() {
                    int value;
                    XYPlottingDialog.this.plotPanel.removeAll();
                    String xAxisName = (String)XYPlottingDialog.this.xAxisComboBox.getSelectedItem();
                    String yAxisName = (String)XYPlottingDialog.this.yAxisComboBox.getSelectedItem();
                    double maxBubbleSize = 0.0;
                    double xAxisRange = 1.0;
                    XYPlottingDialog.this.filterData();
                    boolean selfUpdating = true;
                    if (XYPlottingDialog.this.tableModel instanceof SelfUpdatingTableModel) {
                        SelfUpdatingTableModel selfUpdatingTableModel = (SelfUpdatingTableModel)XYPlottingDialog.this.tableModel;
                        selfUpdating = selfUpdatingTableModel.isSelfUpdating();
                        selfUpdatingTableModel.setSelfUpdating(false);
                    }
                    if (XYPlottingDialog.this.histogramRadioButton.isSelected() || XYPlottingDialog.this.densityPlotRadioButton.isSelected()) {
                        XYPlot plot;
                        JFreeChart chart;
                        ((TitledBorder)XYPlottingDialog.this.xyPlotPanel.getBorder()).setTitle(xAxisName);
                        XYPlottingDialog.this.xyPlotPanel.revalidate();
                        XYPlottingDialog.this.xyPlotPanel.repaint();
                        XYPlottingDialog.this.progressDialog.setPrimaryProgressCounterIndeterminate(false);
                        XYPlottingDialog.this.progressDialog.setMaxPrimaryProgressCounter(XYPlottingDialog.this.tableModel.getRowCount());
                        XYPlottingDialog.this.progressDialog.setValue(0);
                        int xAxisIndex = XYPlottingDialog.this.xAxisComboBox.getSelectedIndex();
                        double[] values = new double[XYPlottingDialog.this.tableModel.getRowCount()];
                        for (int index = 0; index < XYPlottingDialog.this.tableModel.getRowCount(); ++index) {
                            XYPlottingDialog.this.progressDialog.increasePrimaryProgressCounter();
                            if (!XYPlottingDialog.this.rowsAfterDataFiltering.contains(index)) continue;
                            if (XYPlottingDialog.this.tableModel.getValueAt(index, xAxisIndex) instanceof XYDataPoint) {
                                values[index] = ((XYDataPoint)XYPlottingDialog.this.tableModel.getValueAt(index, xAxisIndex)).getX();
                                continue;
                            }
                            if (XYPlottingDialog.this.tableModel.getValueAt(index, xAxisIndex) instanceof Integer) {
                                values[index] = ((Integer)XYPlottingDialog.this.tableModel.getValueAt(index, xAxisIndex)).doubleValue();
                                continue;
                            }
                            if (XYPlottingDialog.this.tableModel.getValueAt(index, xAxisIndex) instanceof Double) {
                                values[index] = (Double)XYPlottingDialog.this.tableModel.getValueAt(index, xAxisIndex);
                                continue;
                            }
                            if (!(XYPlottingDialog.this.tableModel.getValueAt(index, xAxisIndex) instanceof StartIndexes) || ((StartIndexes)XYPlottingDialog.this.tableModel.getValueAt(index, xAxisIndex)).getIndexes().size() <= 0) continue;
                            values[index] = ((Integer)((StartIndexes)XYPlottingDialog.this.tableModel.getValueAt(index, xAxisIndex)).getIndexes().get(0)).intValue();
                        }
                        if (XYPlottingDialog.this.densityPlotRadioButton.isSelected()) {
                            NormalKernelDensityEstimator kernelEstimator = new NormalKernelDensityEstimator();
                            ArrayList list = kernelEstimator.estimateDensityFunction(values);
                            XYSeriesCollection lineChartDataset = new XYSeriesCollection();
                            XYSeries tempSeries = new XYSeries((Comparable)((Object)"1"));
                            double[] xValues = (double[])list.get(0);
                            double[] yValues = (double[])list.get(1);
                            for (int i = 0; i < xValues.length; ++i) {
                                tempSeries.add(xValues[i], yValues[i]);
                            }
                            lineChartDataset.addSeries(tempSeries);
                            AreaRenderer renderer = new AreaRenderer();
                            renderer.setOutline(true);
                            renderer.setSeriesFillPaint(0, (Paint)XYPlottingDialog.this.histogramColor);
                            renderer.setSeriesOutlinePaint(0, (Paint)XYPlottingDialog.this.histogramColor.darker());
                            chart = ChartFactory.createXYLineChart(null, (String)xAxisName, (String)"Density", (XYDataset)lineChartDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
                            plot = chart.getXYPlot();
                            plot.setRenderer((XYItemRenderer)renderer);
                        } else {
                            HistogramDataset dataset = new HistogramDataset();
                            dataset.setType(HistogramType.FREQUENCY);
                            if (!XYPlottingDialog.this.userDefinedBinSize) {
                                XYPlottingDialog.this.numberOfBins = XYPlottingDialog.this.getNumberOfBins(values);
                                XYPlottingDialog.this.binSizeSpinner.setValue(XYPlottingDialog.this.numberOfBins);
                            }
                            XYPlottingDialog.this.userDefinedBinSize = false;
                            dataset.addSeries((Comparable)((Object)xAxisName), values, XYPlottingDialog.this.numberOfBins);
                            chart = ChartFactory.createHistogram(null, (String)xAxisName, (String)"Frequency", (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
                            plot = chart.getXYPlot();
                            XYBarRenderer renderer = new XYBarRenderer();
                            renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
                            renderer.setShadowVisible(false);
                            renderer.setSeriesPaint(0, (Paint)XYPlottingDialog.this.histogramColor);
                            plot.setRenderer((XYItemRenderer)renderer);
                        }
                        if (XYPlottingDialog.this.xAxisLogCheckBox.isSelected()) {
                            plot.setDomainAxis((ValueAxis)new LogAxis(plot.getDomainAxis().getLabel()));
                        }
                        if (XYPlottingDialog.this.yAxisLogCheckBox.isSelected()) {
                            plot.setRangeAxis((ValueAxis)new LogAxis(plot.getRangeAxis().getLabel()));
                        }
                        XYPlottingDialog.this.chartPanel = new ChartPanel(chart);
                        XYPlottingDialog.this.chartPanel.setBorder(null);
                        chart.setBorderVisible(false);
                        plot.setOutlineVisible(false);
                        plot.setBackgroundPaint((Paint)Color.WHITE);
                        XYPlottingDialog.this.chartPanel.setBackground(Color.WHITE);
                        chart.setBackgroundPaint((Paint)Color.WHITE);
                        XYPlottingDialog.this.plotPanel.add((Component)XYPlottingDialog.this.chartPanel);
                        XYPlottingDialog.this.plotPanel.revalidate();
                        XYPlottingDialog.this.plotPanel.repaint();
                    } else {
                        ((TitledBorder)XYPlottingDialog.this.xyPlotPanel.getBorder()).setTitle(xAxisName + " vs. " + yAxisName);
                        XYPlottingDialog.this.xyPlotPanel.revalidate();
                        XYPlottingDialog.this.xyPlotPanel.repaint();
                        DefaultXYZDataset xyzDataset = new DefaultXYZDataset();
                        ArrayList<String> datasetNames = new ArrayList<String>();
                        HashMap<String, ArrayList> datasets = new HashMap<String, ArrayList>();
                        int colorIndex = XYPlottingDialog.this.colorsComboBox.getSelectedIndex();
                        double minColorValue = Double.MAX_VALUE;
                        double maxColorValue = Double.MIN_VALUE;
                        XYPlottingDialog.this.progressDialog.setPrimaryProgressCounterIndeterminate(false);
                        XYPlottingDialog.this.progressDialog.setMaxPrimaryProgressCounter(XYPlottingDialog.this.tableModel.getRowCount() * 2);
                        XYPlottingDialog.this.progressDialog.setValue(0);
                        for (int i = 0; i < XYPlottingDialog.this.tableModel.getRowCount(); ++i) {
                            ArrayList tempArray;
                            XYPlottingDialog.this.progressDialog.increasePrimaryProgressCounter();
                            if (!XYPlottingDialog.this.rowsAfterDataFiltering.contains(i)) continue;
                            if (!datasets.containsKey(XYPlottingDialog.this.tableModel.getValueAt(i, colorIndex).toString())) {
                                tempArray = new ArrayList();
                                datasetNames.add(XYPlottingDialog.this.tableModel.getValueAt(i, colorIndex).toString());
                            } else {
                                tempArray = (ArrayList)datasets.get(XYPlottingDialog.this.tableModel.getValueAt(i, colorIndex).toString());
                            }
                            tempArray.add(i);
                            datasets.put(XYPlottingDialog.this.tableModel.getValueAt(i, colorIndex).toString(), tempArray);
                            if (XYPlottingDialog.this.tableModel.getValueAt(i, colorIndex) instanceof XYDataPoint) {
                                double tempColorValue = ((XYDataPoint)XYPlottingDialog.this.tableModel.getValueAt(i, colorIndex)).getX();
                                if (tempColorValue > maxColorValue) {
                                    maxColorValue = tempColorValue;
                                }
                                if (!(tempColorValue < minColorValue)) continue;
                                minColorValue = tempColorValue;
                                continue;
                            }
                            if (XYPlottingDialog.this.tableModel.getValueAt(i, colorIndex) instanceof Integer) {
                                int tempColorValue = (Integer)XYPlottingDialog.this.tableModel.getValueAt(i, colorIndex);
                                if ((double)tempColorValue > maxColorValue) {
                                    maxColorValue = tempColorValue;
                                }
                                if (!((double)tempColorValue < minColorValue)) continue;
                                minColorValue = tempColorValue;
                                continue;
                            }
                            if (XYPlottingDialog.this.tableModel.getValueAt(i, colorIndex) instanceof Double) {
                                double tempColorValue = (Double)XYPlottingDialog.this.tableModel.getValueAt(i, colorIndex);
                                if (tempColorValue > maxColorValue) {
                                    maxColorValue = tempColorValue;
                                }
                                if (!(tempColorValue < minColorValue)) continue;
                                minColorValue = tempColorValue;
                                continue;
                            }
                            if (!(XYPlottingDialog.this.tableModel.getValueAt(i, colorIndex) instanceof StartIndexes) || ((StartIndexes)XYPlottingDialog.this.tableModel.getValueAt(i, colorIndex)).getIndexes().size() <= 0) continue;
                            double tempColorValue = ((Integer)((StartIndexes)XYPlottingDialog.this.tableModel.getValueAt(i, colorIndex)).getIndexes().get(0)).intValue();
                            if (tempColorValue > maxColorValue) {
                                maxColorValue = tempColorValue;
                            }
                            if (!(tempColorValue < minColorValue)) continue;
                            minColorValue = tempColorValue;
                        }
                        int xAxisIndex = XYPlottingDialog.this.xAxisComboBox.getSelectedIndex();
                        int yAxisIndex = XYPlottingDialog.this.yAxisComboBox.getSelectedIndex();
                        int bubbleSizeIndex = XYPlottingDialog.this.bubbleSizeComboBox.getSelectedIndex();
                        HashMap<Integer, Color> datasetColors = new HashMap<Integer, Color>();
                        XYPlottingDialog.this.progressDialog.setPrimaryProgressCounterIndeterminate(false);
                        XYPlottingDialog.this.progressDialog.setMaxPrimaryProgressCounter(XYPlottingDialog.this.tableModel.getRowCount());
                        XYPlottingDialog.this.progressDialog.setValue(0);
                        int datasetCounter = 0;
                        double minXValue = Double.MAX_VALUE;
                        double maxXValue = Double.MIN_VALUE;
                        double sx = 0.0;
                        double sy = 0.0;
                        double sxx = 0.0;
                        double sxy = 0.0;
                        double syy = 0.0;
                        SimpleRegression simpleRegression = new SimpleRegression();
                        for (String dataset : datasetNames) {
                            double[][] tempDataXYZ = new double[3][((ArrayList)datasets.get(dataset)).size()];
                            int counter = 0;
                            for (Integer index : (ArrayList)datasets.get(dataset)) {
                                XYPlottingDialog.this.progressDialog.increasePrimaryProgressCounter();
                                if (XYPlottingDialog.this.tableModel.getValueAt(index, xAxisIndex) instanceof XYDataPoint) {
                                    tempDataXYZ[0][counter] = ((XYDataPoint)XYPlottingDialog.this.tableModel.getValueAt(index, xAxisIndex)).getX();
                                } else if (XYPlottingDialog.this.tableModel.getValueAt(index, xAxisIndex) instanceof Integer) {
                                    tempDataXYZ[0][counter] = ((Integer)XYPlottingDialog.this.tableModel.getValueAt(index, xAxisIndex)).intValue();
                                } else if (XYPlottingDialog.this.tableModel.getValueAt(index, xAxisIndex) instanceof Double) {
                                    tempDataXYZ[0][counter] = (Double)XYPlottingDialog.this.tableModel.getValueAt(index, xAxisIndex);
                                } else if (XYPlottingDialog.this.tableModel.getValueAt(index, xAxisIndex) instanceof StartIndexes && ((StartIndexes)XYPlottingDialog.this.tableModel.getValueAt(index, xAxisIndex)).getIndexes().size() > 0) {
                                    tempDataXYZ[0][counter] = ((Integer)((StartIndexes)XYPlottingDialog.this.tableModel.getValueAt(index, xAxisIndex)).getIndexes().get(0)).intValue();
                                }
                                if (XYPlottingDialog.this.tableModel.getValueAt(index, yAxisIndex) instanceof XYDataPoint) {
                                    tempDataXYZ[1][counter] = ((XYDataPoint)XYPlottingDialog.this.tableModel.getValueAt(index, yAxisIndex)).getX();
                                } else if (XYPlottingDialog.this.tableModel.getValueAt(index, yAxisIndex) instanceof Integer) {
                                    tempDataXYZ[1][counter] = ((Integer)XYPlottingDialog.this.tableModel.getValueAt(index, yAxisIndex)).intValue();
                                } else if (XYPlottingDialog.this.tableModel.getValueAt(index, yAxisIndex) instanceof Double) {
                                    tempDataXYZ[1][counter] = (Double)XYPlottingDialog.this.tableModel.getValueAt(index, yAxisIndex);
                                } else if (XYPlottingDialog.this.tableModel.getValueAt(index, yAxisIndex) instanceof StartIndexes && ((StartIndexes)XYPlottingDialog.this.tableModel.getValueAt(index, yAxisIndex)).getIndexes().size() > 0) {
                                    tempDataXYZ[1][counter] = ((Integer)((StartIndexes)XYPlottingDialog.this.tableModel.getValueAt(index, yAxisIndex)).getIndexes().get(0)).intValue();
                                }
                                if (tempDataXYZ[0][counter] > maxXValue) {
                                    maxXValue = tempDataXYZ[0][counter];
                                }
                                if (tempDataXYZ[0][counter] < minXValue) {
                                    minXValue = tempDataXYZ[0][counter];
                                }
                                simpleRegression.addData(tempDataXYZ[0][counter], tempDataXYZ[1][counter]);
                                if (bubbleSizeIndex == 0) {
                                    tempDataXYZ[2][counter] = XYPlottingDialog.this.bubbleSize;
                                } else if (XYPlottingDialog.this.tableModel.getValueAt(index, bubbleSizeIndex - 1) instanceof XYDataPoint) {
                                    tempDataXYZ[2][counter] = ((XYDataPoint)XYPlottingDialog.this.tableModel.getValueAt(index, bubbleSizeIndex - 1)).getX();
                                } else if (XYPlottingDialog.this.tableModel.getValueAt(index, bubbleSizeIndex - 1) instanceof Integer) {
                                    tempDataXYZ[2][counter] = ((Integer)XYPlottingDialog.this.tableModel.getValueAt(index, bubbleSizeIndex - 1)).intValue();
                                } else if (XYPlottingDialog.this.tableModel.getValueAt(index, bubbleSizeIndex - 1) instanceof Double) {
                                    tempDataXYZ[2][counter] = (Double)XYPlottingDialog.this.tableModel.getValueAt(index, bubbleSizeIndex - 1);
                                } else if (XYPlottingDialog.this.tableModel.getValueAt(index, bubbleSizeIndex - 1) instanceof StartIndexes) {
                                    tempDataXYZ[2][counter] = ((StartIndexes)XYPlottingDialog.this.tableModel.getValueAt(index, bubbleSizeIndex - 1)).getIndexes().size() > 0 ? (double)((Integer)((StartIndexes)XYPlottingDialog.this.tableModel.getValueAt(index, bubbleSizeIndex - 1)).getIndexes().get(0)).intValue() : 0.0;
                                }
                                if (XYPlottingDialog.this.sizeLogCheckBox.isSelected()) {
                                    tempDataXYZ[2][counter] = Math.log(tempDataXYZ[2][counter]) / Math.log(2.0);
                                }
                                tempDataXYZ[2][counter] = tempDataXYZ[2][counter] * XYPlottingDialog.this.bubbleScalingFactor;
                                if (tempDataXYZ[2][counter] > maxBubbleSize) {
                                    maxBubbleSize = tempDataXYZ[2][counter];
                                }
                                XYPlottingDialog.this.dataPointToRowNumber.put(datasetCounter + "_" + counter++, index);
                            }
                            int tableRowIndex = (Integer)((ArrayList)datasets.get(dataset)).get(0);
                            Object tempObject = XYPlottingDialog.this.tableModel.getValueAt(tableRowIndex, colorIndex);
                            if (tempObject instanceof Integer) {
                                datasetColors.put(datasetCounter, GradientColorCoding.findGradientColor((Double)((Integer)tempObject).doubleValue(), (Double)minColorValue, (Double)maxColorValue, (GradientColorCoding.ColorGradient)XYPlottingDialog.this.colorGradient));
                            } else if (tempObject instanceof Double) {
                                datasetColors.put(datasetCounter, GradientColorCoding.findGradientColor((Double)((Double)tempObject), (Double)minColorValue, (Double)maxColorValue, (GradientColorCoding.ColorGradient)XYPlottingDialog.this.colorGradient));
                            } else if (tempObject instanceof XYDataPoint) {
                                datasetColors.put(datasetCounter, GradientColorCoding.findGradientColor((Double)((XYDataPoint)tempObject).getX(), (Double)minColorValue, (Double)maxColorValue, (GradientColorCoding.ColorGradient)XYPlottingDialog.this.colorGradient));
                            } else if (tempObject instanceof StartIndexes) {
                                if (((StartIndexes)tempObject).getIndexes().size() > 0) {
                                    datasetColors.put(datasetCounter, GradientColorCoding.findGradientColor((Double)((Integer)((StartIndexes)tempObject).getIndexes().get(0)).doubleValue(), (Double)minColorValue, (Double)maxColorValue, (GradientColorCoding.ColorGradient)XYPlottingDialog.this.colorGradient));
                                } else {
                                    datasetColors.put(datasetCounter, GradientColorCoding.findGradientColor((Double)minColorValue, (Double)minColorValue, (Double)maxColorValue, (GradientColorCoding.ColorGradient)XYPlottingDialog.this.colorGradient));
                                }
                            } else {
                                datasetColors.put(datasetCounter, GradientColorCoding.findGradientColor((Double)minColorValue, (Double)minColorValue, (Double)maxColorValue, (GradientColorCoding.ColorGradient)XYPlottingDialog.this.colorGradient));
                            }
                            xyzDataset.addSeries((Comparable)((Object)dataset), tempDataXYZ);
                            ++datasetCounter;
                        }
                        XYPlottingDialog.this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
                        JFreeChart chart = ChartFactory.createBubbleChart(null, (String)xAxisName, (String)yAxisName, (XYZDataset)xyzDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
                        XYPlot plot = chart.getXYPlot();
                        if (XYPlottingDialog.this.showRegressionLine) {
                            XYSeriesCollection regressionData = new XYSeriesCollection();
                            XYSeries regr = new XYSeries((Comparable)((Object)"RegressionLine"));
                            regr.add(minXValue, simpleRegression.predict(minXValue));
                            regr.add(maxXValue, simpleRegression.predict(maxXValue));
                            regressionData.addSeries(regr);
                            plot.addAnnotation((XYAnnotation)new XYTextAnnotation("R2=" + Util.roundDouble(simpleRegression.getRSquare(), 2), maxXValue * 0.93, simpleRegression.predict(maxXValue) * 0.99));
                            StandardXYItemRenderer regressionRenderer = new StandardXYItemRenderer();
                            regressionRenderer.setBaseSeriesVisibleInLegend(false);
                            regressionRenderer.setSeriesPaint(0, (Paint)Color.GRAY);
                            plot.setDataset(1, (XYDataset)regressionData);
                            plot.setRenderer(1, (XYItemRenderer)regressionRenderer);
                        }
                        XYBubbleRenderer renderer = new XYBubbleRenderer(1){

                            public Stroke getItemOutlineStroke(int row, int column) {
                                BasicStroke stroke;
                                int[] selectedRows;
                                boolean selectedInTable = false;
                                for (int tableRowIndex : selectedRows = XYPlottingDialog.this.selectedValuesTable.getSelectedRows()) {
                                    if (((Integer)XYPlottingDialog.this.dataPointToRowNumber.get(row + "_" + column)).intValue() != XYPlottingDialog.this.selectedValuesTable.convertRowIndexToModel(tableRowIndex)) continue;
                                    selectedInTable = true;
                                }
                                if (selectedInTable) {
                                    stroke = (BasicStroke)super.getItemOutlineStroke(row, column);
                                    return new BasicStroke(stroke.getLineWidth() * 10.0f);
                                }
                                if (!XYPlottingDialog.this.selectedDataPoints.isEmpty()) {
                                    if (XYPlottingDialog.this.selectedDataPoints.containsKey(row) && ((ArrayList)XYPlottingDialog.this.selectedDataPoints.get(row)).contains(column)) {
                                        stroke = (BasicStroke)super.getItemOutlineStroke(row, column);
                                        return new BasicStroke(stroke.getLineWidth() * 1.2f);
                                    }
                                    return super.getItemOutlineStroke(row, column);
                                }
                                return super.getItemOutlineStroke(row, column);
                            }

                            public Paint getItemOutlinePaint(int row, int column) {
                                int[] selectedRows;
                                boolean selectedInTable = false;
                                for (int tableRowIndex : selectedRows = XYPlottingDialog.this.selectedValuesTable.getSelectedRows()) {
                                    if (((Integer)XYPlottingDialog.this.dataPointToRowNumber.get(row + "_" + column)).intValue() != XYPlottingDialog.this.selectedValuesTable.convertRowIndexToModel(tableRowIndex)) continue;
                                    selectedInTable = true;
                                }
                                if (selectedInTable) {
                                    return Color.BLUE;
                                }
                                if (!XYPlottingDialog.this.selectedDataPoints.isEmpty()) {
                                    if (XYPlottingDialog.this.selectedDataPoints.containsKey(row) && ((ArrayList)XYPlottingDialog.this.selectedDataPoints.get(row)).contains(column)) {
                                        return Color.BLACK;
                                    }
                                    return Color.LIGHT_GRAY;
                                }
                                return super.getItemOutlinePaint(row, column);
                            }

                            public Paint getItemPaint(int row, int column) {
                                if (!XYPlottingDialog.this.selectedDataPoints.isEmpty()) {
                                    Color tempColor = (Color)super.getItemPaint(row, column);
                                    if (XYPlottingDialog.this.selectedDataPoints.containsKey(row) && ((ArrayList)XYPlottingDialog.this.selectedDataPoints.get(row)).contains(column)) {
                                        return new Color(tempColor.getRed(), tempColor.getGreen(), tempColor.getBlue(), 255);
                                    }
                                    return new Color(tempColor.getRed(), tempColor.getGreen(), tempColor.getBlue(), 30);
                                }
                                return super.getItemPaint(row, column);
                            }

                            public Paint getItemFillPaint(int row, int column) {
                                if (!XYPlottingDialog.this.selectedDataPoints.isEmpty()) {
                                    Color tempColor = (Color)super.getItemFillPaint(row, column);
                                    if (XYPlottingDialog.this.selectedDataPoints.containsKey(row) && ((ArrayList)XYPlottingDialog.this.selectedDataPoints.get(row)).contains(column)) {
                                        return new Color(tempColor.getRed(), tempColor.getGreen(), tempColor.getBlue(), 255);
                                    }
                                    return new Color(tempColor.getRed(), tempColor.getGreen(), tempColor.getBlue(), 30);
                                }
                                return super.getItemFillPaint(row, column);
                            }
                        };
                        boolean isIntegerColorRenderer = false;
                        if (XYPlottingDialog.this.cellRenderers.containsKey(XYPlottingDialog.this.colorsComboBox.getSelectedIndex()) && XYPlottingDialog.this.cellRenderers.get(XYPlottingDialog.this.colorsComboBox.getSelectedIndex()) instanceof JSparklinesIntegerColorTableCellRenderer) {
                            JSparklinesIntegerColorTableCellRenderer integerColorRenderer = (JSparklinesIntegerColorTableCellRenderer)XYPlottingDialog.this.cellRenderers.get(XYPlottingDialog.this.colorsComboBox.getSelectedIndex());
                            HashMap colors = integerColorRenderer.getColors();
                            for (int i = 0; i < datasetNames.size(); ++i) {
                                Integer datasetInteger = Integer.valueOf((String)datasetNames.get(i));
                                renderer.setSeriesPaint(i, (Paint)colors.get((int)datasetInteger));
                            }
                            isIntegerColorRenderer = true;
                        }
                        if (!isIntegerColorRenderer && XYPlottingDialog.this.useGradientColorCoding) {
                            for (int i = 0; i < datasetNames.size(); ++i) {
                                renderer.setSeriesPaint(i, (Paint)datasetColors.get(i));
                            }
                        }
                        renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYZToolTipGenerator());
                        plot.setRenderer((XYItemRenderer)renderer);
                        plot.setForegroundAlpha(0.5f);
                        plot.getDomainAxis().setUpperMargin(0.0);
                        plot.getDomainAxis().setLowerMargin(0.0);
                        plot.setRangeGridlinePaint((Paint)Color.black);
                        if (XYPlottingDialog.this.xAxisLogCheckBox.isSelected()) {
                            plot.setDomainAxis((ValueAxis)new LogAxis(plot.getDomainAxis().getLabel()));
                        }
                        if (XYPlottingDialog.this.yAxisLogCheckBox.isSelected()) {
                            plot.setRangeAxis((ValueAxis)new LogAxis(plot.getRangeAxis().getLabel()));
                        }
                        xAxisRange = plot.getDomainAxis().getUpperBound() - plot.getDomainAxis().getLowerBound();
                        plot.setDomainGridlinesVisible(false);
                        chart.getPlot().setOutlineVisible(false);
                        chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
                        chart.setBackgroundPaint((Paint)Color.WHITE);
                        XYPlottingDialog.this.chartPanel = new ChartPanel(chart){

                            public void mouseReleased(MouseEvent e) {
                                if (XYPlottingDialog.this.selectionActive) {
                                    this.setMouseZoomable(false);
                                    super.mouseReleased(e);
                                    this.setMouseZoomable(true);
                                } else {
                                    super.mouseReleased(e);
                                }
                            }
                        };
                        XYPlottingDialog.this.chartPanel.setBackground(Color.WHITE);
                        XYPlottingDialog.this.plotPanel.add((Component)XYPlottingDialog.this.chartPanel);
                        XYPlottingDialog.this.plotPanel.revalidate();
                        XYPlottingDialog.this.plotPanel.repaint();
                        XYPlottingDialog.this.chartPanel.addChartMouseListener(new ChartMouseListener(){

                            public void chartMouseClicked(ChartMouseEvent cme) {
                                XYPlottingDialog.this.mouseClickedInChart(cme);
                            }

                            public void chartMouseMoved(ChartMouseEvent cme) {
                                XYPlottingDialog.this.mouseMovedInChart(cme);
                            }
                        });
                        XYPlottingDialog.this.chartPanel.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

                            @Override
                            public void mouseDragged(MouseEvent e) {
                                if (!XYPlottingDialog.this.dragToZoomRadioButton.isSelected()) {
                                    XYPlottingDialog.this.selectionActive = true;
                                    XYPlottingDialog.this.mouseDragged = true;
                                } else {
                                    XYPlottingDialog.this.selectionActive = false;
                                    super.mouseDragged(e);
                                }
                            }
                        });
                        XYPlottingDialog.this.chartPanel.addMouseListener((MouseListener)new MouseAdapter(){

                            @Override
                            public void mousePressed(MouseEvent e) {
                                XYPlottingDialog.this.dragStart = e.getPoint();
                                XYPlottingDialog.this.mouseDragged = false;
                                super.mouseClicked(e);
                            }

                            @Override
                            public void mouseReleased(MouseEvent e) {
                                if (XYPlottingDialog.this.mouseDragged) {
                                    XYPlottingDialog.this.dragEnd = e.getPoint();
                                    XYPlottingDialog.this.selectedDataPoints = new HashMap();
                                    XYPlottingDialog.this.selectedModelRows = new ArrayList();
                                    double dragStartX = (XYPlottingDialog.this.dragStart.getX() - (double)((XYPlottingDialog)XYPlottingDialog.this).chartPanel.getInsets().left) / XYPlottingDialog.this.chartPanel.getScaleX();
                                    double dragStartY = (XYPlottingDialog.this.dragStart.getY() - (double)((XYPlottingDialog)XYPlottingDialog.this).chartPanel.getInsets().top) / XYPlottingDialog.this.chartPanel.getScaleY();
                                    double dragEndX = (XYPlottingDialog.this.dragEnd.getX() - (double)((XYPlottingDialog)XYPlottingDialog.this).chartPanel.getInsets().left) / XYPlottingDialog.this.chartPanel.getScaleX();
                                    double dragEndY = (XYPlottingDialog.this.dragEnd.getY() - (double)((XYPlottingDialog)XYPlottingDialog.this).chartPanel.getInsets().top) / XYPlottingDialog.this.chartPanel.getScaleY();
                                    ArrayList<XYItemEntity> entitiesFound = new ArrayList<XYItemEntity>();
                                    EntityCollection entities = XYPlottingDialog.this.chartPanel.getChartRenderingInfo().getEntityCollection();
                                    for (ChartEntity entity : entities) {
                                        if (!(entity instanceof XYItemEntity) || !entity.getArea().intersects(dragStartX, dragStartY, dragEndX - dragStartX, dragEndY - dragStartY) || entitiesFound.contains((XYItemEntity)entity)) continue;
                                        entitiesFound.add((XYItemEntity)entity);
                                    }
                                    for (XYItemEntity entity : entitiesFound) {
                                        XYPlottingDialog.this.selectEntity(entity, false);
                                    }
                                }
                                XYPlottingDialog.this.mouseDragged = false;
                                XYPlottingDialog.this.chartPanel.getChart().fireChartChanged();
                                XYPlottingDialog.this.filterTable();
                                super.mouseReleased(e);
                            }
                        });
                    }
                    if (XYPlottingDialog.this.tableModel instanceof SelfUpdatingTableModel) {
                        ((SelfUpdatingTableModel)XYPlottingDialog.this.tableModel).setSelfUpdating(selfUpdating);
                    }
                    XYPlottingDialog.this.isPlotting = false;
                    XYPlottingDialog.this.filterTable();
                    XYPlottingDialog.this.progressDialog.setRunFinished();
                    if (maxBubbleSize > xAxisRange && !XYPlottingDialog.this.sizeLogCheckBox.isSelected() && (value = JOptionPane.showConfirmDialog(XYPlottingDialog.this.dialogParent, "Seems like your bubbles are too large.\nTurn on log scale?", "Log Scale?", 0)) == 0) {
                        XYPlottingDialog.this.sizeLogCheckBox.setSelected(true);
                        XYPlottingDialog.this.updatePlot();
                    }
                }
            }.start();
        }
    }

    public void mouseClickedInChart(ChartMouseEvent event) {
        ArrayList<ChartEntity> entities = this.getEntitiesForPoint(event.getTrigger().getPoint().x, event.getTrigger().getPoint().y);
        if (entities.isEmpty()) {
            return;
        }
        boolean dataPointsSelected = false;
        for (ChartEntity entity : entities) {
            if (!(entity instanceof XYItemEntity)) continue;
            this.selectEntity((XYItemEntity)entity, true);
            dataPointsSelected = true;
        }
        if (!dataPointsSelected) {
            this.selectedDataPoints = new HashMap();
            this.selectedModelRows = new ArrayList();
        }
        this.filterTable();
        this.chartPanel.getChart().fireChartChanged();
    }

    private void selectEntity(XYItemEntity entity, boolean removeSelected) {
        Integer seriesIndex = entity.getSeriesIndex();
        Integer itemIndex = entity.getItem();
        if (this.selectedDataPoints.containsKey(seriesIndex)) {
            if (this.selectedDataPoints.get(seriesIndex).contains(itemIndex)) {
                if (removeSelected) {
                    this.selectedDataPoints.get(seriesIndex).remove(itemIndex);
                    if (this.selectedDataPoints.get(seriesIndex).isEmpty()) {
                        this.selectedDataPoints.remove(seriesIndex);
                    }
                    this.selectedModelRows.remove(this.dataPointToRowNumber.get(seriesIndex + "_" + itemIndex));
                }
            } else {
                this.selectedDataPoints.get(seriesIndex).add(itemIndex);
                this.selectedModelRows.add(this.dataPointToRowNumber.get(seriesIndex + "_" + itemIndex));
            }
        } else {
            ArrayList<Integer> itemList = new ArrayList<Integer>();
            itemList.add(itemIndex);
            this.selectedDataPoints.put(seriesIndex, itemList);
            if (!this.selectedModelRows.contains(this.dataPointToRowNumber.get(seriesIndex + "_" + itemIndex))) {
                this.selectedModelRows.add(this.dataPointToRowNumber.get(seriesIndex + "_" + itemIndex));
            }
        }
    }

    public void mouseMovedInChart(ChartMouseEvent event) {
    }

    public void filterTable() {
        if (this.tableModel instanceof SelfUpdatingTableModel) {
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.tableModel);
            sorter.setRowFilter(new SelectedValuesTableFilter());
            this.selectedValuesTable.setRowSorter(sorter);
        } else {
            ((TableRowSorter)this.selectedValuesTable.getRowSorter()).setRowFilter(new SelectedValuesTableFilter());
        }
        ((TitledBorder)this.selectedValuesPanel.getBorder()).setTitle("Selected Values (" + this.selectedValuesTable.getRowCount() + ")");
        this.selectedValuesPanel.repaint();
    }

    public ArrayList<ChartEntity> getEntitiesForPoint(int viewX, int viewY) {
        ArrayList<ChartEntity> entitiesForPoint = new ArrayList<ChartEntity>();
        ChartRenderingInfo info = this.chartPanel.getChartRenderingInfo();
        if (info != null) {
            Insets insets = this.chartPanel.getInsets();
            double x = (double)(viewX - insets.left) / this.chartPanel.getScaleX();
            double y = (double)(viewY - insets.top) / this.chartPanel.getScaleY();
            EntityCollection allEntities = info.getEntityCollection();
            int numEntities = allEntities.getEntityCount();
            for (int i = 0; i < numEntities; ++i) {
                ChartEntity entity = allEntities.getEntity(i);
                if (!entity.getArea().contains(x, y)) continue;
                entitiesForPoint.add(entity);
            }
        }
        return entitiesForPoint;
    }

    @Override
    public void setSelectedExportFolder(String selectedFolder) {
        this.lastSelectedFolder = selectedFolder;
    }

    @Override
    public String getDefaultExportFolder() {
        return this.lastSelectedFolder;
    }

    @Override
    public void setVisibleColumns(HashMap<Integer, Boolean> showColumns) {
        this.visibleColumns = showColumns;
    }

    @Override
    public HashMap<Integer, Boolean> getVisibleColumns() {
        return this.visibleColumns;
    }

    @Override
    public JTable getTable() {
        return this.selectedValuesTable;
    }

    @Override
    public ArrayList<TableColumn> getAllTableColumns() {
        return this.allTableColumns;
    }

    @Override
    public Image getNormalIcon() {
        return this.normalIcon;
    }

    @Override
    public Image getWaitingIcon() {
        return this.waitingIcon;
    }

    private int getNumberOfBins(double[] values) {
        double minValue = Double.MAX_VALUE;
        double maxValue = Double.MIN_VALUE;
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (int i = 0; i < values.length; ++i) {
            stats.addValue(values[i]);
            if (values[i] > maxValue) {
                maxValue = values[i];
            }
            if (!(values[i] < minValue)) continue;
            minValue = values[i];
        }
        double q1 = stats.getPercentile(25.0);
        double q3 = stats.getPercentile(75.0);
        double range = Math.abs(maxValue - minValue);
        if (q3 - q1 == 0.0 || values.length == 0) {
            return 10;
        }
        int freedmanDiaconisValue = (int)Math.ceil(Math.pow(values.length, 0.0) * range / (2.0 * (q3 - q1)));
        if (freedmanDiaconisValue == 0 || freedmanDiaconisValue < 10) {
            return 10;
        }
        return freedmanDiaconisValue;
    }

    public Vector<String> getColummnNames() {
        return this.colummnNames;
    }

    public HashMap<String, String> getDataFilters() {
        return this.filters;
    }

    public void setDataFilters(HashMap<String, String> filters) {
        this.filters = filters;
    }

    private void filterData() {
        this.rowsAfterDataFiltering = new ArrayList();
        boolean filterError = false;
        boolean selfUpdating = true;
        if (this.tableModel instanceof SelfUpdatingTableModel) {
            SelfUpdatingTableModel selfUpdatingTableModel = (SelfUpdatingTableModel)this.tableModel;
            selfUpdating = selfUpdatingTableModel.isSelfUpdating();
            selfUpdatingTableModel.setSelfUpdating(false);
        }
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            boolean include = true;
            for (int j = 0; j < this.tableModel.getColumnCount(); ++j) {
                String filter = this.filters.get(this.tableModel.getColumnName(j));
                if (filter == null) continue;
                if (filter.startsWith(">")) {
                    if (this.tableModel.getValueAt(i, j) instanceof String) {
                        filterError = true;
                        continue;
                    }
                    try {
                        double value = Double.valueOf(filter.substring(1));
                        if (this.tableModel.getValueAt(i, j) instanceof Integer) {
                            if (!((double)((Integer)this.tableModel.getValueAt(i, j)).intValue() <= value)) continue;
                            include = false;
                            continue;
                        }
                        if (this.tableModel.getValueAt(i, j) instanceof Double) {
                            if (!((Double)this.tableModel.getValueAt(i, j) <= value)) continue;
                            include = false;
                            continue;
                        }
                        if (!(this.tableModel.getValueAt(i, j) instanceof XYDataPoint) || !(((XYDataPoint)this.tableModel.getValueAt(i, j)).getX() <= value)) continue;
                        include = false;
                    }
                    catch (NumberFormatException e) {
                        filterError = true;
                    }
                    continue;
                }
                if (filter.startsWith("<")) {
                    if (this.tableModel.getValueAt(i, j) instanceof String) {
                        filterError = true;
                        continue;
                    }
                    try {
                        double value = Double.valueOf(filter.substring(1));
                        if (this.tableModel.getValueAt(i, j) instanceof Integer) {
                            if (!((double)((Integer)this.tableModel.getValueAt(i, j)).intValue() >= value)) continue;
                            include = false;
                            continue;
                        }
                        if (this.tableModel.getValueAt(i, j) instanceof Double) {
                            if (!((Double)this.tableModel.getValueAt(i, j) >= value)) continue;
                            include = false;
                            continue;
                        }
                        if (!(this.tableModel.getValueAt(i, j) instanceof XYDataPoint) || !(((XYDataPoint)this.tableModel.getValueAt(i, j)).getX() >= value)) continue;
                        include = false;
                    }
                    catch (NumberFormatException e) {
                        filterError = true;
                    }
                    continue;
                }
                if (!filter.startsWith("=")) continue;
                if (this.tableModel.getValueAt(i, j) instanceof String) {
                    String pattern = filter.substring(1);
                    if (((String)this.tableModel.getValueAt(i, j)).equalsIgnoreCase(pattern)) continue;
                    include = false;
                    continue;
                }
                try {
                    double value = Double.valueOf(filter.substring(1));
                    if (this.tableModel.getValueAt(i, j) instanceof Integer) {
                        if ((double)((Integer)this.tableModel.getValueAt(i, j)).intValue() == value) continue;
                        include = false;
                        continue;
                    }
                    if (this.tableModel.getValueAt(i, j) instanceof Double) {
                        if ((Double)this.tableModel.getValueAt(i, j) == value) continue;
                        include = false;
                        continue;
                    }
                    if (!(this.tableModel.getValueAt(i, j) instanceof XYDataPoint) || ((XYDataPoint)this.tableModel.getValueAt(i, j)).getX() == value) continue;
                    include = false;
                    continue;
                }
                catch (NumberFormatException e) {
                    filterError = true;
                }
            }
            if (!include) continue;
            this.rowsAfterDataFiltering.add(i);
        }
        if (this.tableModel instanceof SelfUpdatingTableModel) {
            ((SelfUpdatingTableModel)this.tableModel).setSelfUpdating(selfUpdating);
        }
        if (filterError) {
            JOptionPane.showMessageDialog(this, "There was an error with one of the filters. Please check the filter settings.", "Filter Error", 1);
        }
    }

    public class NormalKernelDensityEstimator {
        private final int n = 4096;
        private EmpiricalDist empiricalDist;
        private KernelDensityGen kernelDensityGen;
        private double datasetSize;

        private void init(double[] data) {
            this.datasetSize = data.length;
            Arrays.sort(data);
            this.empiricalDist = new EmpiricalDist(data);
            MRG31k3p stream = new MRG31k3p();
            NormalGen normalKernelDensityGen = new NormalGen((RandomStream)stream);
            this.kernelDensityGen = new KernelDensityGen((RandomStream)stream, this.empiricalDist, normalKernelDensityGen);
        }

        public ArrayList estimateDensityFunction(Double[] data) {
            this.init(this.excludeNullValues(data));
            return this.estimateDensityFunction();
        }

        public ArrayList estimateDensityFunction(double[] data) {
            this.init(data);
            return this.estimateDensityFunction();
        }

        private ArrayList estimateDensityFunction() {
            ArrayList<double[]> densityFunction = new ArrayList<double[]>();
            double[] randomSamples = new double[4096];
            for (int i = 0; i < 4096; ++i) {
                double nextDouble;
                randomSamples[i] = nextDouble = this.kernelDensityGen.nextDouble();
            }
            Arrays.sort(randomSamples);
            densityFunction.add(randomSamples);
            NormalDist kern = new NormalDist();
            double bandWidth = 0.99 * Math.min(this.empiricalDist.getSampleStandardDeviation(), this.empiricalDist.getInterQuartileRange() / 1.34) / Math.pow(this.datasetSize, 0.2);
            double[] estimatedDensityValues = KernelDensity.computeDensity((EmpiricalDist)this.empiricalDist, (ContinuousDistribution)kern, (double)bandWidth, (double[])randomSamples);
            densityFunction.add(estimatedDensityValues);
            return densityFunction;
        }

        public double[] excludeNullValues(Double[] data) {
            ArrayList<Double> list = new ArrayList<Double>();
            for (Double value : data) {
                if (value == null) continue;
                list.add(value);
            }
            double[] newArray = new double[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                newArray[i] = (Double)list.get(i);
            }
            return newArray;
        }
    }

    public class SelectedValuesTableFilter
    extends RowFilter<DefaultTableModel, Integer> {
        @Override
        public boolean include(RowFilter.Entry<? extends DefaultTableModel, ? extends Integer> entry) {
            if (!XYPlottingDialog.this.rowsAfterDataFiltering.contains(entry.getIdentifier())) {
                return false;
            }
            return XYPlottingDialog.this.selectedModelRows.isEmpty() || XYPlottingDialog.this.selectedModelRows.contains(entry.getIdentifier());
        }
    }
}

