/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.mascot;

import com.compomics.mascotdatfile.util.exception.MascotDatfileException;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ProteinHit
implements Serializable {
    private static Logger logger = Logger.getLogger(ProteinHit.class);
    private String iAccession = null;
    private int iFrameNumber = 0;
    private int iStart = 0;
    private int iStop = 0;
    private int iMultiplicity = 0;

    public ProteinHit(String aPeptideHit_prot) {
        this.parsePeptideHit_protString(aPeptideHit_prot);
    }

    private void parsePeptideHit_protString(String aProt) {
        int lQuote1 = aProt.indexOf(34);
        int lQuote2 = aProt.indexOf(34, lQuote1 + 1);
        if (lQuote1 < 0 || lQuote2 < 0) {
            throw new MascotDatfileException("ProteinHit accession not found. The protein instance could not be created. " + aProt);
        }
        this.iAccession = aProt.substring(lQuote1 + 1, lQuote2);
        StringTokenizer st = new StringTokenizer(aProt = aProt.substring(lQuote2 + 2), ":");
        if (st.countTokens() != 4) {
            throw new MascotDatfileException("Illegal amount of tokens(" + st.countTokens() + ") to create the ProteinHit instance. There must be 5 tokens. " + aProt);
        }
        this.iFrameNumber = Integer.parseInt(st.nextToken());
        this.iStart = Integer.parseInt(st.nextToken());
        this.iStop = Integer.parseInt(st.nextToken());
        this.iMultiplicity = Integer.parseInt(st.nextToken());
    }

    public String getAccession() {
        return this.iAccession;
    }

    public void setAccession(String aAccession) {
        this.iAccession = aAccession;
    }

    public int getFrameNumber() {
        return this.iFrameNumber;
    }

    public void setFrameNumber(int aFrameNumber) {
        this.iFrameNumber = aFrameNumber;
    }

    public int getStart() {
        return this.iStart;
    }

    public void setStart(int aStart) {
        this.iStart = aStart;
    }

    public int getStop() {
        return this.iStop;
    }

    public void setStop(int aStop) {
        this.iStop = aStop;
    }

    public int getMultiplicity() {
        return this.iMultiplicity;
    }

    public void setMultiplicity(int aMultiplicity) {
        this.iMultiplicity = aMultiplicity;
    }

    public int getPeptideStartInProtein_PeptideCentricDatabase() {
        String result = null;
        int lStart = this.iAccession.indexOf(40) + 1;
        int lStop = this.iAccession.lastIndexOf(45);
        result = lStart == -1 || lStop == -1 ? "" + this.iStart : this.iAccession.substring(lStart, lStop);
        return Integer.parseInt(result);
    }

    public int getPeptideStopInProtein_PeptideCentricDatabase() {
        String result = null;
        int lStart = this.iAccession.indexOf(45) + 1;
        int lStop = this.iAccession.indexOf(41);
        result = lStart == -1 || lStop == -1 ? "" + this.iStop : this.iAccession.substring(lStart, lStop);
        return Integer.parseInt(result);
    }
}

