/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.research.tool.spectrumviewer.spectrumviewer_gui;

import com.compomics.mascotdatfile.research.tool.spectrumviewer.spectrumviewer_gui.DataBridge;
import com.compomics.mascotdatfile.research.tool.spectrumviewer.spectrumviewer_gui.SpectrumViewer_Filter_JDialog;
import com.compomics.mascotdatfile.research.tool.spectrumviewer.spectrumviewer_gui.Spectrumviewer_URL_JDialog;
import com.compomics.mascotdatfile.research.tool.spectrumviewer.spectrumviewer_model.DatfileTreePanel;
import com.compomics.mascotdatfile.research.util.DatfileLocation;
import com.compomics.mascotdatfile.util.interfaces.MascotDatfileInf;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class Spectrumviewer_gui
extends JFrame
implements DataBridge {
    private static Logger logger = Logger.getLogger(Spectrumviewer_gui.class);
    private JButton btnHardDisk = null;
    private JButton btnDatabase = null;
    private JButton btnUrl = null;
    private JPanel jpanMenuBar = null;
    private JPanel jpanDatfileTree = null;
    private DatfileTreePanel dtp = null;
    private JMenuBar mbar1 = null;
    private JMenu menuOpen = null;
    private JMenu menuDo = null;
    private JMenuItem menuItem1 = null;
    private String iPropertiesFile = "Spectrumviewer_gui.properties";

    public Spectrumviewer_gui() {
        super("Spectrumviewer");
        this.setDefaultCloseOperation(3);
        this.constructScreen();
        this.validate();
        this.pack();
    }

    public void constructScreen() {
        this.mbar1 = new JMenuBar();
        this.menuOpen = new JMenu("Datfile");
        this.menuOpen.setMnemonic(68);
        this.menuDo = new JMenu("Tools");
        this.menuDo.setMnemonic(84);
        this.mbar1.add(this.menuOpen);
        this.mbar1.add(this.menuDo);
        this.menuItem1 = new JMenuItem("URL Mascot Server", 85);
        this.menuItem1.setAccelerator(KeyStroke.getKeyStroke(85, 8));
        this.menuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Spectrumviewer_gui.this.launch_URL_JDialog();
            }
        });
        this.menuOpen.add(this.menuItem1);
        this.menuItem1 = new JMenuItem("Hard Disk", 72);
        this.menuItem1.setAccelerator(KeyStroke.getKeyStroke(72, 8));
        this.menuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Spectrumviewer_gui.this.launch_HDD_JDialog(false);
            }
        });
        this.menuOpen.add(this.menuItem1);
        this.menuItem1 = new JMenuItem("Hard Disk (using index)", 73);
        this.menuItem1.setAccelerator(KeyStroke.getKeyStroke(73, 8));
        this.menuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Spectrumviewer_gui.this.launch_HDD_JDialog(true);
            }
        });
        this.menuOpen.add(this.menuItem1);
        this.menuItem1 = new JMenuItem("Filter", 70);
        this.menuItem1.setAccelerator(KeyStroke.getKeyStroke(70, 8));
        this.menuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Spectrumviewer_gui.this.launch_Filter_JDialog();
            }
        });
        this.menuDo.add(this.menuItem1);
        this.menuItem1 = new JMenuItem("Select Query", 83);
        this.menuItem1.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        this.menuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Spectrumviewer_gui.this.dtp == null) {
                    JOptionPane.showMessageDialog(Spectrumviewer_gui.this.jpanMenuBar, "First load a datfile by the Datfile menu.");
                } else {
                    String lInput = JOptionPane.showInputDialog(Spectrumviewer_gui.this.jpanMenuBar, "Insert the Querynumber or SpectrumFilename.", "Select Query", 3).trim();
                    if (lInput != null) {
                        Spectrumviewer_gui.this.dtp.select_jpanTree_node(lInput);
                    }
                }
            }
        });
        this.menuDo.add(this.menuItem1);
        this.menuItem1 = new JMenuItem("Pdf output", 80);
        this.menuItem1.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        this.menuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Spectrumviewer_gui.this.pdfOutputTriggered();
            }
        });
        this.menuDo.add(this.menuItem1);
        this.jpanMenuBar = new JPanel();
        this.jpanMenuBar.setLayout(new BorderLayout(5, 5));
        this.jpanMenuBar.add(this.mbar1);
        this.jpanDatfileTree = new JPanel(new BorderLayout(5, 5));
        this.jpanDatfileTree.add(new JLabel("Select a datfile through the Datfile menu.", 0));
        JPanel jpanMain = new JPanel(new BorderLayout());
        jpanMain.add((Component)this.jpanMenuBar, "North");
        jpanMain.add((Component)this.jpanDatfileTree, "Center");
        this.getContentPane().add(jpanMain);
    }

    public void passMascotDatfile(MascotDatfileInf mdf, String aFilename) {
        this.jpanDatfileTree.removeAll();
        this.dtp = new DatfileTreePanel(mdf);
        this.jpanDatfileTree.add((Component)this.dtp, "Center");
        this.jpanDatfileTree.setBorder(BorderFactory.createBevelBorder(0));
        this.jpanDatfileTree.validate();
        this.setTitle("Spectrumviewer - MascotDatfile " + aFilename);
        this.pack();
    }

    public void passFilterSettings(double aIntensityThreshold) {
        this.dtp.setFilterSettingsOnTreeModel(aIntensityThreshold);
        this.validate();
    }

    private void pdfOutputTriggered() {
        if (this.dtp != null) {
            boolean lbContinue = true;
            String previousPath = "/";
            FileFilter filter = new FileFilter(){

                public boolean accept(File f) {
                    boolean result = false;
                    if (f.isDirectory() || f.getName().endsWith(".pdf")) {
                        result = true;
                    }
                    return result;
                }

                public String getDescription() {
                    return "PDF file";
                }
            };
            while (lbContinue) {
                JFileChooser jfc = new JFileChooser(previousPath);
                jfc.setDialogTitle("Save spectrum panel as PDF file");
                jfc.setDialogType(1);
                jfc.setFileFilter(filter);
                int returnVal = jfc.showSaveDialog(this.getParent());
                if (returnVal == 0) {
                    int reply;
                    File file = jfc.getSelectedFile();
                    if (jfc.getFileFilter() == filter && !file.getName().toLowerCase().endsWith(".pdf")) {
                        file = new File(file.getAbsolutePath() + ".pdf");
                    }
                    if (file.exists() && (reply = JOptionPane.showConfirmDialog(this.getParent(), new String[]{"File '" + file.getAbsolutePath() + "' exists.", "Do you wish to overwrite?"}, "File exists!", 0, 3)) != 0) {
                        previousPath = file.getParent();
                        continue;
                    }
                    JPanel jpanSpectrum = this.dtp.getSpectrumPanel();
                    float lWidthFloat = new Double(jpanSpectrum.getSize().getWidth()).floatValue() + 20.0f;
                    float lHeightFloat = new Double(jpanSpectrum.getSize().getHeight()).floatValue();
                    int lWidthInt = new Double(jpanSpectrum.getSize().getWidth()).intValue();
                    int lHeightInt = new Double(jpanSpectrum.getSize().getHeight()).intValue();
                    Document document = new Document(new Rectangle((float)lWidthInt, (float)lHeightInt));
                    try {
                        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
                        document.open();
                        PdfContentByte cb = writer.getDirectContent();
                        PdfTemplate tp = cb.createTemplate(lWidthFloat, lHeightFloat);
                        Graphics2D g2 = tp.createGraphicsShapes(lWidthFloat, lHeightFloat);
                        jpanSpectrum.print(g2);
                        g2.dispose();
                        cb.addTemplate(tp, 0.0f, 0.0f);
                        writer.flush();
                        JOptionPane.showMessageDialog(this, "Data successfully written to '" + file + "'!", "Output completed!", 1);
                        document.close();
                    }
                    catch (DocumentException e) {
                        JOptionPane.showMessageDialog(this, new String[]{"Unable to create PDF file!", e.getMessage()}, "Unable to create PDF file!", 2);
                    }
                    catch (FileNotFoundException e) {
                        JOptionPane.showMessageDialog(this, new String[]{"Unable to write file!", e.getMessage()}, "Unable to write file!", 2);
                    }
                    lbContinue = false;
                    continue;
                }
                lbContinue = false;
            }
        } else {
            JOptionPane.showMessageDialog(this, "You need to load a datfile and SpectrumPanel first!", "No datfile loaded yet!", 0);
        }
    }

    private void launch_URL_JDialog() {
        Spectrumviewer_URL_JDialog d = new Spectrumviewer_URL_JDialog(this, this, "Spectrumviewer URL dialog", this.iPropertiesFile);
    }

    private void launch_HDD_JDialog(boolean aIndexed) {
        File lDatfileFile = null;
        boolean lbContinue = true;
        while (lbContinue) {
            JFileChooser lJFileChooser = new JFileChooser();
            int lReturnVal = lJFileChooser.showOpenDialog(this);
            if (lReturnVal == 0) {
                lDatfileFile = lJFileChooser.getSelectedFile();
                if (lDatfileFile == null || !lDatfileFile.exists()) {
                    JOptionPane.showMessageDialog(this, "You need to specify an existing datfile!", "Datfile not found!", 2);
                    continue;
                }
                lbContinue = false;
                continue;
            }
            if (lReturnVal != 1) continue;
            return;
        }
        String errorString = null;
        MascotDatfileInf lMdf = null;
        try {
            this.setCursor(new Cursor(3));
            DatfileLocation dfl = new DatfileLocation(0, lDatfileFile.getPath());
            lMdf = dfl.getDatfile(aIndexed);
        }
        catch (ClassNotFoundException cnfe) {
            errorString = "HD class was not found! (" + cnfe.getMessage() + ")";
        }
        catch (IllegalAccessException iae) {
            errorString = "(" + iae.getMessage() + ")";
        }
        catch (InstantiationException ie) {
            errorString = "Could not create instance of the MascotDatfile class! (" + ie.getMessage() + ")";
        }
        catch (SQLException sqle) {
            errorString = "(" + sqle.getMessage() + ")";
        }
        this.setCursor(new Cursor(0));
        if (errorString != null) {
            JOptionPane.showMessageDialog(this, new String[]{"Unable to load " + lDatfileFile.getPath() + ". " + errorString, "\n"}, "Unable to get the datfile!", 0);
        } else {
            this.passMascotDatfile(lMdf, lDatfileFile.getPath());
        }
    }

    private void launch_Filter_JDialog() {
        SpectrumViewer_Filter_JDialog d = new SpectrumViewer_Filter_JDialog((Frame)this, this, "Spectrumviewer Filter Settings", this.iPropertiesFile);
    }

    public static void main(String[] args) {
        Spectrumviewer_gui frame = new Spectrumviewer_gui();
        frame.setSize(750, 100);
        frame.setLocation(50, 50);
        frame.setVisible(true);
    }
}

