/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.research.script;

import com.compomics.mascotdatfile.research.util.DatfileLocation;
import com.compomics.mascotdatfile.util.interfaces.FragmentIon;
import com.compomics.mascotdatfile.util.interfaces.MascotDatfileInf;
import com.compomics.mascotdatfile.util.interfaces.QueryToPeptideMapInf;
import com.compomics.mascotdatfile.util.mascot.PeptideHit;
import com.compomics.mascotdatfile.util.mascot.PeptideHitAnnotation;
import com.compomics.mascotdatfile.util.mascot.Query;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class AminoAcidScoring {
    private static Logger logger = Logger.getLogger(AminoAcidScoring.class);

    public static void main(String[] args) {
        File testExistence;
        if (args == null || args.length != 4) {
            AminoAcidScoring.printUsage();
        }
        if (!(testExistence = new File(args[0])).exists()) {
            AminoAcidScoring.printError("The datfile you specified ('" + args[0] + "') does not exist!");
        }
        int queryNumber = -1;
        try {
            queryNumber = Integer.parseInt(args[1]);
            if (queryNumber < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            AminoAcidScoring.printError("The querynumber you specified ('" + args[1] + "') is not a positive, whole number!");
        }
        int peptideHitNumber = -1;
        try {
            peptideHitNumber = Integer.parseInt(args[2]);
            if (peptideHitNumber < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            AminoAcidScoring.printError("The peptidehit number you specified ('" + args[2] + "') is not a positive, whole number!");
        }
        int scoretype = -1;
        try {
            scoretype = Integer.parseInt(args[3]);
            if (scoretype < 0 || scoretype > 1) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            AminoAcidScoring.printError("The scoringtype you specified ('" + args[3] + "') is not known to me.\nRun this program without parameters to find out about valid options for this parameter.!");
        }
        DatfileLocation dfl = new DatfileLocation(0, new String[]{args[0]});
        try {
            MascotDatfileInf mdf = dfl.getDatfile();
            Query query = (Query)mdf.getQueryList().get(queryNumber - 1);
            QueryToPeptideMapInf qtpm = mdf.getQueryToPeptideMap();
            PeptideHit ph = qtpm.getPeptideHitOfOneQuery(queryNumber, peptideHitNumber);
            if (ph == null) {
                AminoAcidScoring.printError("Peptidehit " + peptideHitNumber + " from Query " + queryNumber + " does not exist!!");
            }
            PeptideHitAnnotation pha = ph.getPeptideHitAnnotation(mdf.getMasses(), mdf.getParametersSection());
            Vector ions = null;
            switch (scoretype) {
                case 0: {
                    ions = pha.getMatchedIonsByMascot(query.getPeakList(), ph.getPeaksUsedFromIons1());
                    break;
                }
                case 1: {
                    ions = pha.getFusedMatchedIons(query.getPeakList(), ph.getPeaksUsedFromIons1(), query.getMaxIntensity(), 0.1);
                }
            }
            String sequence = ph.getSequence();
            int length = sequence.length();
            boolean[] yIons = new boolean[length];
            boolean[] bIons = new boolean[length];
            block16: for (int i = 0; i < ions.size(); ++i) {
                FragmentIon lFragmentIon = (FragmentIon)ions.elementAt(i);
                switch (lFragmentIon.getID()) {
                    case 7: {
                        yIons[lFragmentIon.getNumber() - 1] = true;
                        continue block16;
                    }
                    case 1: {
                        bIons[lFragmentIon.getNumber() - 1] = true;
                        continue block16;
                    }
                    default: {
                        System.err.println(" * Ion found by Mascot that is disregarded: " + lFragmentIon.getLabel());
                    }
                }
            }
            String[] modifiedAA = AminoAcidScoring.parseModifiedStringIntoComponents(ph.getModifiedSequence());
            StringBuffer formattedSequence = new StringBuffer("<html>");
            for (int i = 0; i < bIons.length; ++i) {
                boolean italic = false;
                boolean bold = false;
                if (i == 0) {
                    if (bIons[i]) {
                        italic = true;
                    }
                    if (yIons[yIons.length - (i + 1)] && yIons[yIons.length - (i + 2)]) {
                        bold = true;
                    }
                } else if (i == length - 1) {
                    if (bIons[i] && bIons[i - 1]) {
                        italic = true;
                    }
                    if (yIons[yIons.length - (i + 1)]) {
                        bold = true;
                    }
                } else {
                    if (bIons[i] && bIons[i - 1]) {
                        italic = true;
                    }
                    if (yIons[yIons.length - (i + 1)] && yIons[yIons.length - (i + 2)]) {
                        bold = true;
                    }
                }
                formattedSequence.append((italic ? "<u>" : "") + (bold ? "<font color=\"red\">" : "") + modifiedAA[i].replaceAll("<", "&lt;").replaceAll(">", "&gt;") + (italic ? "</u>" : "") + (bold ? "</font>" : ""));
            }
            formattedSequence.append("</html>");
            JLabel label = new JLabel(formattedSequence.toString());
            SpectrumPanel sp1 = new SpectrumPanel(query.getMZArray(), query.getIntensityArray(), query.getPrecursorMZ(), query.getChargeString(), query.getTitle());
            sp1.setAnnotations(ions);
            JFrame app1 = new JFrame("Spectrum for " + query.getTitle() + " - " + ph.getModifiedSequence() + " (Mascot ions)" + " - " + "Score: " + ph.getIonsScore());
            app1.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    e.getWindow().dispose();
                    System.exit(0);
                }
            });
            JPanel jpanLabel = new JPanel();
            jpanLabel.add(label);
            app1.getContentPane().add((Component)jpanLabel, "North");
            app1.getContentPane().add((Component)sp1, "Center");
            app1.setLocation(100, 100);
            app1.setSize(1200, 300);
            app1.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String[] parseModifiedStringIntoComponents(String aModSeq) {
        int endIndex;
        Vector<String> parts = new Vector<String>();
        String temp = aModSeq;
        String part = temp.substring(0, temp.indexOf("-") + 1).trim();
        int start = temp.indexOf("-") + 1;
        if ((temp = temp.substring(start).trim()).charAt(endIndex = 1) == '<') {
            ++endIndex;
            while (temp.charAt(endIndex) != '>') {
                ++endIndex;
            }
            ++endIndex;
        }
        part = part + temp.substring(0, endIndex);
        temp = temp.substring(endIndex);
        parts.add(part);
        while (temp.length() > 0) {
            start = 0;
            endIndex = 1;
            if (temp.charAt(start + endIndex) == '<') {
                ++endIndex;
                while (temp.charAt(start + endIndex) != '>') {
                    ++endIndex;
                }
                ++endIndex;
            } else if (temp.charAt(start + endIndex) == '-') {
                endIndex = temp.length();
            }
            part = temp.substring(0, endIndex);
            temp = temp.substring(endIndex);
            parts.add(part);
        }
        String[] result = new String[parts.size()];
        parts.toArray(result);
        return result;
    }

    private static void printUsage() {
        AminoAcidScoring.printError("Usage:\tAminoAcidScoring <path and filename from datfile> <querynumber> <peptidehitnumber> <scoringtype>\n\n\tWhere scoringtype can be:\n\t\t\t0 for Mascot scoring\n\t\t\t1 for Fused scoring\n\nExample:\n\tAminoAcidScoring C:\\mascot\\datfiles\\F010345.dat 598 3 1\nWill load the Third PeptideHit from Query 598 of F010345.dat with fused(1) annotations into the AminoAcideScoring Panel.");
    }

    private static void printError(String aMsg) {
        System.err.println("\n\n" + aMsg + "\n\n");
        System.exit(1);
    }
}

