/*
 * Decompiled with CFR 0.152.
 */
package de.proteinms.xtandemparser.xtandem;

import de.proteinms.xtandemparser.interfaces.Peak;
import de.proteinms.xtandemparser.interfaces.Peaklist;
import de.proteinms.xtandemparser.parser.XTandemParser;
import de.proteinms.xtandemparser.xtandem.Domain;
import de.proteinms.xtandemparser.xtandem.FragmentIon;
import de.proteinms.xtandemparser.xtandem.InSilicoDigester;
import de.proteinms.xtandemparser.xtandem.InputParams;
import de.proteinms.xtandemparser.xtandem.ModificationMap;
import de.proteinms.xtandemparser.xtandem.Peptide;
import de.proteinms.xtandemparser.xtandem.PeptideMap;
import de.proteinms.xtandemparser.xtandem.PerformParams;
import de.proteinms.xtandemparser.xtandem.ProteinMap;
import de.proteinms.xtandemparser.xtandem.Spectrum;
import de.proteinms.xtandemparser.xtandem.SpectrumPeak;
import de.proteinms.xtandemparser.xtandem.SupportData;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.SAXException;

public class XTandemFile
implements Serializable {
    private String iFileName = null;
    private ArrayList<Spectrum> iSpectraList = null;
    private PeptideMap iPeptideMap = null;
    private ProteinMap iProteinMap = null;
    private ModificationMap iModMap = null;
    private XTandemParser iXTParser = null;
    private HashMap<String, Integer> iIdToNumberMap;
    private InputParams iInputParams = null;
    private PerformParams iPerformParams = null;
    private String iRawFile = null;
    private String iRawFileType = null;
    private int iSpectraNumber = 0;
    private HashMap<Integer, Peaklist> iRawFileMap;

    public XTandemFile(String aXTandemFile) throws SAXException {
        try {
            File inputFile = new File(aXTandemFile);
            if (!inputFile.exists()) {
                throw new IllegalArgumentException("XTandem xml-file " + aXTandemFile + " doesn't exist.");
            }
            this.iXTParser = new XTandemParser(inputFile);
            this.setFileName(aXTandemFile);
            this.iSpectraList = this.getSpectraList();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public InputParams getInputParameters() {
        if (this.iInputParams == null) {
            this.iInputParams = new InputParams(this.iXTParser.getInputParamMap());
        }
        return this.iInputParams;
    }

    public PerformParams getPerformParameters() {
        if (this.iPerformParams == null) {
            this.iPerformParams = new PerformParams(this.iXTParser.getPerformParamMap());
        }
        return this.iPerformParams;
    }

    public static HashMap getMassesMap() {
        HashMap<String, Double> map = new HashMap<String, Double>();
        map.put("A", 71.03711);
        map.put("B", 114.53493);
        map.put("C", 103.009185);
        map.put("D", 115.026943);
        map.put("E", 129.042593);
        map.put("F", 147.068414);
        map.put("G", 57.021464);
        map.put("H", 137.058912);
        map.put("I", 113.084064);
        map.put("J", 0.0);
        map.put("K", 128.094963);
        map.put("L", 113.084064);
        map.put("M", 131.040485);
        map.put("N", 114.042927);
        map.put("O", 0.0);
        map.put("P", 97.052764);
        map.put("Q", 128.058578);
        map.put("R", 156.101111);
        map.put("S", 87.032028);
        map.put("T", 101.047679);
        map.put("U", 0.0);
        map.put("V", 99.068414);
        map.put("W", 186.079313);
        map.put("X", 111.0);
        map.put("Y", 163.06332);
        map.put("Z", 128.55059);
        map.put("Hydrogen", 1.007825);
        map.put("Carbon", 12.0);
        map.put("Nitrogen", 14.00307);
        map.put("Oxygen", 15.99491);
        map.put("Electron", 0.00549);
        map.put("C_term", 17.002735);
        map.put("N_term", 1.007825);
        return map;
    }

    public ModificationMap getModificationMap() {
        if (this.iModMap == null) {
            this.iModMap = new ModificationMap(this.iXTParser.getRawModMap(), this.getPeptideMap(), this.getInputParameters(), this.iXTParser.getNumberOfSpectra());
        }
        return this.iModMap;
    }

    public Vector getFragmentIonsForPeptide(Peptide peptide, Domain domain, double fragmentIonAccuracy) {
        Vector<FragmentIon[]> fragIons = new Vector<FragmentIon[]>();
        int charge = this.getSpectrum(peptide.getSpectrumNumber()).getPrecursorCharge();
        InSilicoDigester digester = new InSilicoDigester(peptide, domain, this.getModificationMap(), XTandemFile.getMassesMap(), charge, fragmentIonAccuracy);
        SupportData supData = this.getSupportData(peptide.getSpectrumNumber());
        ArrayList<Double> mzList = supData.getXValuesFragIonMass2Charge();
        ArrayList<Double> intList = supData.getYValuesFragIonMass2Charge();
        Peak[] peaks = new SpectrumPeak[mzList.size()];
        for (int i = 0; i < mzList.size(); ++i) {
            peaks[i] = new SpectrumPeak();
            ((SpectrumPeak)peaks[i]).setMz(mzList.get(i));
            ((SpectrumPeak)peaks[i]).setIntensity(intList.get(i));
        }
        Vector matchedMHIons = digester.getMatchedIons(12, peaks);
        FragmentIon[] matchMHIons = new FragmentIon[matchedMHIons.size()];
        for (int i = 0; i < matchedMHIons.size(); ++i) {
            matchMHIons[i] = (FragmentIon)matchedMHIons.get(i);
        }
        Vector matchedMHNH3Ions = digester.getMatchedIons(13, peaks);
        FragmentIon[] matchMHNH3Ions = new FragmentIon[matchedMHNH3Ions.size()];
        for (int i = 0; i < matchedMHNH3Ions.size(); ++i) {
            matchMHNH3Ions[i] = (FragmentIon)matchedMHNH3Ions.get(i);
        }
        Vector matchedMHH2OIons = digester.getMatchedIons(14, peaks);
        FragmentIon[] matchMHH2OIons = new FragmentIon[matchedMHH2OIons.size()];
        for (int i = 0; i < matchedMHH2OIons.size(); ++i) {
            matchMHH2OIons[i] = (FragmentIon)matchedMHH2OIons.get(i);
        }
        Vector matchedAIons = digester.getMatchedIons(0, peaks);
        FragmentIon[] matchAIons = new FragmentIon[matchedAIons.size()];
        for (int i = 0; i < matchedAIons.size(); ++i) {
            matchAIons[i] = (FragmentIon)matchedAIons.get(i);
        }
        Vector matchedAH2OIons = digester.getMatchedIons(2, peaks);
        FragmentIon[] matchAH2OIons = new FragmentIon[matchedAH2OIons.size()];
        for (int i = 0; i < matchedAH2OIons.size(); ++i) {
            matchAH2OIons[i] = (FragmentIon)matchedAH2OIons.get(i);
        }
        Vector matchedANH3Ions = digester.getMatchedIons(1, peaks);
        FragmentIon[] matchANH3Ions = new FragmentIon[matchedANH3Ions.size()];
        for (int i = 0; i < matchedANH3Ions.size(); ++i) {
            matchANH3Ions[i] = (FragmentIon)matchedANH3Ions.get(i);
        }
        Vector matchedBIons = digester.getMatchedIons(3, peaks);
        FragmentIon[] matchBIons = new FragmentIon[matchedBIons.size()];
        for (int i = 0; i < matchedBIons.size(); ++i) {
            matchBIons[i] = (FragmentIon)matchedBIons.get(i);
        }
        Vector matchedBH2OIons = digester.getMatchedIons(5, peaks);
        FragmentIon[] matchBH2OIons = new FragmentIon[matchedBH2OIons.size()];
        for (int i = 0; i < matchedBH2OIons.size(); ++i) {
            matchBH2OIons[i] = (FragmentIon)matchedBH2OIons.get(i);
        }
        Vector matchedBNH3Ions = digester.getMatchedIons(4, peaks);
        FragmentIon[] matchBNH3Ions = new FragmentIon[matchedBNH3Ions.size()];
        for (int i = 0; i < matchedBNH3Ions.size(); ++i) {
            matchBNH3Ions[i] = (FragmentIon)matchedBNH3Ions.get(i);
        }
        Vector matchedCIons = digester.getMatchedIons(6, peaks);
        FragmentIon[] matchCIons = new FragmentIon[matchedCIons.size()];
        for (int i = 0; i < matchedCIons.size(); ++i) {
            matchCIons[i] = (FragmentIon)matchedCIons.get(i);
        }
        Vector matchedXIons = digester.getMatchedIons(7, peaks);
        FragmentIon[] matchXIons = new FragmentIon[matchedXIons.size()];
        for (int i = 0; i < matchedXIons.size(); ++i) {
            matchXIons[i] = (FragmentIon)matchedXIons.get(i);
        }
        Vector matchedYIons = digester.getMatchedIons(8, peaks);
        FragmentIon[] matchYIons = new FragmentIon[matchedYIons.size()];
        for (int i = 0; i < matchedYIons.size(); ++i) {
            matchYIons[i] = (FragmentIon)matchedYIons.get(i);
        }
        Vector matchedYH2OIons = digester.getMatchedIons(10, peaks);
        FragmentIon[] matchYH2OIons = new FragmentIon[matchedYH2OIons.size()];
        for (int i = 0; i < matchedYH2OIons.size(); ++i) {
            matchYH2OIons[i] = (FragmentIon)matchedYH2OIons.get(i);
        }
        Vector matchedYNH3Ions = digester.getMatchedIons(9, peaks);
        FragmentIon[] matchYNH3Ions = new FragmentIon[matchedYNH3Ions.size()];
        for (int i = 0; i < matchedYNH3Ions.size(); ++i) {
            matchYNH3Ions[i] = (FragmentIon)matchedYNH3Ions.get(i);
        }
        Vector matchedZIons = digester.getMatchedIons(11, peaks);
        FragmentIon[] matchZIons = new FragmentIon[matchedZIons.size()];
        for (int i = 0; i < matchedZIons.size(); ++i) {
            matchZIons[i] = (FragmentIon)matchedZIons.get(i);
        }
        fragIons.add(matchMHIons);
        fragIons.add(matchMHNH3Ions);
        fragIons.add(matchMHH2OIons);
        fragIons.add(matchAIons);
        fragIons.add(matchAH2OIons);
        fragIons.add(matchANH3Ions);
        fragIons.add(matchBIons);
        fragIons.add(matchBH2OIons);
        fragIons.add(matchBNH3Ions);
        fragIons.add(matchCIons);
        fragIons.add(matchXIons);
        fragIons.add(matchYIons);
        fragIons.add(matchYH2OIons);
        fragIons.add(matchYNH3Ions);
        fragIons.add(matchZIons);
        return fragIons;
    }

    public PeptideMap getPeptideMap() {
        if (this.iPeptideMap == null) {
            this.iPeptideMap = new PeptideMap(this.iXTParser.getRawPeptideMap(), this.getProteinMap(), this.iXTParser.getNumberOfSpectra());
        }
        return this.iPeptideMap;
    }

    public Iterator getSpectraIterator() {
        if (this.iSpectraList == null) {
            this.iSpectraList = this.getSpectraList();
            return this.iSpectraList.iterator();
        }
        return this.iSpectraList.iterator();
    }

    public ArrayList<Spectrum> getSpectraList() {
        if (this.iSpectraList == null) {
            this.iSpectraNumber = this.iXTParser.getNumberOfSpectra();
            this.iSpectraList = new ArrayList();
            HashMap<String, String> spectrumSection = this.iXTParser.getRawSpectrumMap();
            this.iIdToNumberMap = new HashMap();
            for (int i = 1; i < this.iSpectraNumber + 1; ++i) {
                int spectrumID = Integer.parseInt(spectrumSection.get("id" + i));
                this.iIdToNumberMap.put(spectrumSection.get("id" + i), i);
                double precursorMh = Double.parseDouble(spectrumSection.get("mh" + i));
                int precursorCharge = Integer.parseInt(spectrumSection.get("z" + i));
                String precursorRetentionTime = spectrumSection.get("rt" + i);
                ArrayList<Double> valueList = new ArrayList<Double>();
                double expectValue = Double.parseDouble(spectrumSection.get("expect" + i));
                valueList.add(expectValue);
                double summedScore = Double.parseDouble(spectrumSection.get("sumI" + i));
                valueList.add(summedScore);
                double maxFragIonIntensity = Double.parseDouble(spectrumSection.get("maxI" + i));
                valueList.add(maxFragIonIntensity);
                double intensityMultiplier = Double.parseDouble(spectrumSection.get("fI" + i));
                valueList.add(intensityMultiplier);
                String label = spectrumSection.get("label" + i);
                this.iSpectraList.add(new Spectrum(spectrumID, precursorMh, precursorCharge, precursorRetentionTime, valueList, label, i));
            }
        }
        return this.iSpectraList;
    }

    public Spectrum getSpectrum(int aSpectrumNumber) {
        return this.getSpectraList().get(aSpectrumNumber - 1);
    }

    public int getSpectrumNumberForId(String aSpectrumID) {
        if (this.iSpectraList == null) {
            this.iSpectraList = this.getSpectraList();
        }
        int spectrumNumber = this.iIdToNumberMap.get(aSpectrumID);
        return spectrumNumber;
    }

    public SupportData getSupportData(int aSpectrumNumber) {
        return new SupportData(this.iXTParser.getSupportDataMap(), aSpectrumNumber);
    }

    public ProteinMap getProteinMap() {
        if (this.iProteinMap == null) {
            this.iProteinMap = new ProteinMap(this.iXTParser.getProteinIDList(), this.iXTParser.getRawProteinMap());
        }
        return this.iProteinMap;
    }

    public String getFileName() {
        if (this.iFileName == null) {
            return "N/A";
        }
        return this.iFileName;
    }

    private void setFileName(String aFileName) {
        this.iFileName = aFileName;
    }

    public XTandemParser getXTandemParser() {
        return this.iXTParser;
    }

    public int getSpectraNumber() {
        return this.iSpectraNumber;
    }
}

