/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.sampling;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.engine.optimizer.sampling.Sampling;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public abstract class SamplingBase
implements Sampling {
    private long size;
    private double factor;
    private long statements;
    protected Graph graph;

    public SamplingBase(Graph graph, double factor) {
        if (graph == null) {
            throw new NullPointerException("Please provide a graph object");
        }
        if (factor < 0.0 || factor > 1.0) {
            throw new IllegalArgumentException("Factor has to be a value of the interval [0,1]: " + factor);
        }
        this.graph = graph;
        this.size = this.getSize();
        this.factor = factor;
        this.statements = this.getNumOfStatements();
    }

    public Graph sample() {
        if (this.size == this.statements) {
            return this.graph;
        }
        long count = 0L;
        Graph sample = Factory.createDefaultGraph();
        while (count < this.statements) {
            Triple triple = this.getNextTriple();
            if (sample.contains(triple)) continue;
            sample.add(triple);
            ++count;
        }
        return sample;
    }

    public abstract Triple getNextTriple();

    private long getSize() {
        long size = 0L;
        ExtendedIterator iter = this.graph.find(Node.ANY, Node.ANY, Node.ANY);
        while (iter.hasNext()) {
            iter.next();
            ++size;
        }
        return size;
    }

    private long getNumOfStatements() {
        return new Double((double)this.size * this.factor).longValue();
    }
}

