/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitorBase;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

class VarFinder {
    VarUsageVisitor varUsageVisitor;

    static Set optDefined(Op op) {
        return VarUsageVisitor.apply((Op)op).optDefines;
    }

    private static Set fixed(Op op) {
        return VarUsageVisitor.apply((Op)op).defines;
    }

    static Set filter(Op op) {
        return VarUsageVisitor.apply((Op)op).filterMentions;
    }

    private static void vars(Set vars, Triple triple) {
        VarFinder.slot(vars, triple.getSubject());
        VarFinder.slot(vars, triple.getPredicate());
        VarFinder.slot(vars, triple.getObject());
    }

    private static void vars(Set acc, BasicPattern pattern) {
        ListIterator iter = pattern.iterator();
        while (iter.hasNext()) {
            Triple triple = (Triple)iter.next();
            VarFinder.vars(acc, triple);
        }
    }

    private static void slot(Set vars, Node node) {
        if (Var.isVar(node)) {
            vars.add(Var.alloc(node));
        }
    }

    VarFinder(Op op) {
        this.varUsageVisitor = VarUsageVisitor.apply(op);
    }

    public Set getOpt() {
        return this.varUsageVisitor.optDefines;
    }

    public Set getFilter() {
        return this.varUsageVisitor.filterMentions;
    }

    public Set getFixed() {
        return this.varUsageVisitor.defines;
    }

    private static class VarUsageVisitor
    extends OpVisitorBase {
        Set defines = null;
        Set optDefines = null;
        Set filterMentions = null;

        static VarUsageVisitor apply(Op op) {
            VarUsageVisitor v = new VarUsageVisitor();
            op.visit(v);
            return v;
        }

        VarUsageVisitor() {
            this.defines = new HashSet();
            this.optDefines = new HashSet();
            this.filterMentions = new HashSet();
        }

        VarUsageVisitor(Set _defines, Set _optDefines, Set _filterMentions) {
            this.defines = _defines;
            this.optDefines = _optDefines;
            this.filterMentions = _filterMentions;
        }

        public void visit(OpQuadPattern quadPattern) {
            VarFinder.slot(this.defines, quadPattern.getGraphNode());
            BasicPattern triples = quadPattern.getBasicPattern();
            VarFinder.vars(this.defines, triples);
        }

        public void visit(OpBGP opBGP) {
            BasicPattern triples = opBGP.getPattern();
            VarFinder.vars(this.defines, triples);
        }

        public void visit(OpExt opExt) {
            opExt.effectiveOp().visit(this);
        }

        public void visit(OpJoin opJoin) {
            VarUsageVisitor leftUsage = VarUsageVisitor.apply(opJoin.getLeft());
            VarUsageVisitor rightUsage = VarUsageVisitor.apply(opJoin.getRight());
            this.defines.addAll(leftUsage.defines);
            this.optDefines.addAll(leftUsage.optDefines);
            this.filterMentions.addAll(leftUsage.filterMentions);
            this.defines.addAll(rightUsage.defines);
            this.optDefines.addAll(rightUsage.optDefines);
            this.filterMentions.addAll(rightUsage.filterMentions);
        }

        public void visit(OpLeftJoin opLeftJoin) {
            VarUsageVisitor leftUsage = VarUsageVisitor.apply(opLeftJoin.getLeft());
            VarUsageVisitor rightUsage = VarUsageVisitor.apply(opLeftJoin.getRight());
            this.defines.addAll(leftUsage.defines);
            this.optDefines.addAll(leftUsage.optDefines);
            this.filterMentions.addAll(leftUsage.filterMentions);
            this.optDefines.addAll(rightUsage.defines);
            this.optDefines.addAll(rightUsage.optDefines);
            this.filterMentions.addAll(rightUsage.filterMentions);
            if (opLeftJoin.getExprs() != null) {
                opLeftJoin.getExprs().varsMentioned(this.filterMentions);
            }
        }

        public void visit(OpUnion opUnion) {
            VarUsageVisitor leftUsage = VarUsageVisitor.apply(opUnion.getLeft());
            VarUsageVisitor rightUsage = VarUsageVisitor.apply(opUnion.getRight());
            this.defines.addAll(leftUsage.defines);
            this.optDefines.addAll(leftUsage.optDefines);
            this.filterMentions.addAll(leftUsage.filterMentions);
            this.defines.addAll(rightUsage.defines);
            this.optDefines.addAll(rightUsage.optDefines);
            this.filterMentions.addAll(rightUsage.filterMentions);
        }

        public void visit(OpGraph opGraph) {
            VarFinder.slot(this.defines, opGraph.getNode());
        }

        public void visit(OpFilter opFilter) {
            opFilter.getExprs().varsMentioned(this.filterMentions);
            opFilter.getSubOp().visit(this);
        }

        public void visit(OpAssign opAssign) {
            opAssign.getSubOp().visit(this);
            List vars = opAssign.getVarExprList().getVars();
            this.defines.addAll(vars);
        }

        public void visit(OpProject opProject) {
            List vars = opProject.getVars();
            VarUsageVisitor subUsage = VarUsageVisitor.apply(opProject.getSubOp());
            subUsage.defines.retainAll(vars);
            subUsage.optDefines.retainAll(vars);
            subUsage.optDefines.retainAll(vars);
            this.defines.addAll(subUsage.defines);
            this.optDefines.addAll(subUsage.optDefines);
            this.filterMentions.addAll(subUsage.filterMentions);
        }

        public void visit(OpTable opTable) {
        }

        public void visit(OpNull opNull) {
        }
    }
}

