/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ontocat.special;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import uk.ac.ebi.ontocat.Ontology;
import uk.ac.ebi.ontocat.OntologyService;
import uk.ac.ebi.ontocat.OntologyServiceException;
import uk.ac.ebi.ontocat.OntologyTerm;

public abstract class AbstractOntologyServiceTest {
    protected static OntologyService os;
    protected static String ONTOLOGY_ACCESSION;
    protected static String TERM_ACCESSION;
    protected static final Logger log;

    @Test
    public final void testGetOntologies() throws OntologyServiceException {
        AbstractOntologyServiceTest.printCurrentTest();
        List<Ontology> list = os.getOntologies();
        Assert.assertNotSame((String)"Empty list returned!", (Object)0, (Object)list.size());
        for (Ontology oe : list) {
            AbstractOntologyServiceTest.println(oe);
        }
    }

    @Test
    public final void testGetOntology() throws OntologyServiceException {
        AbstractOntologyServiceTest.printCurrentTest();
        Ontology oe = os.getOntology(ONTOLOGY_ACCESSION);
        Assert.assertNotNull((String)"Null returned!", (Object)oe);
        AbstractOntologyServiceTest.println(oe);
    }

    @Test
    public final void testSearchOntology() throws OntologyServiceException {
        AbstractOntologyServiceTest.printCurrentTest();
        List<OntologyTerm> list = os.searchOntology(ONTOLOGY_ACCESSION, "gene", new OntologyService.SearchOptions[0]);
        Assert.assertNotSame((String)"Empty list returned!", (Object)0, (Object)list.size());
        for (OntologyTerm ot : list) {
            AbstractOntologyServiceTest.println(ot);
        }
        log.info(list.size());
    }

    @Test
    public void testSearchAll() throws OntologyServiceException {
        AbstractOntologyServiceTest.printCurrentTest();
        List<OntologyTerm> list = os.searchAll("intracellular", OntologyService.SearchOptions.EXACT, OntologyService.SearchOptions.INCLUDE_PROPERTIES);
        Assert.assertNotSame((String)"Empty list returned!", (Object)0, (Object)list.size());
        for (OntologyTerm ot : list) {
            AbstractOntologyServiceTest.println(ot);
        }
    }

    @Test
    public final void testGetRootTerms() throws OntologyServiceException {
        AbstractOntologyServiceTest.printCurrentTest();
        List<OntologyTerm> list = os.getRootTerms(ONTOLOGY_ACCESSION);
        Assert.assertNotSame((String)"Empty list returned!", (Object)0, (Object)list.size());
        Assert.assertNotSame((String)"Empty list returned!", (Object)0, (Object)list.size());
        for (OntologyTerm ot : list) {
            AbstractOntologyServiceTest.println(ot);
        }
    }

    @Test
    public final void testGetTerm() throws OntologyServiceException {
        AbstractOntologyServiceTest.printCurrentTest();
        OntologyTerm ot = os.getTerm(ONTOLOGY_ACCESSION, TERM_ACCESSION);
        Assert.assertNotNull((String)"Null returned", (Object)ot);
        AbstractOntologyServiceTest.println(ot);
    }

    @Test
    public final void testGetTermByAccessionOnly() throws OntologyServiceException {
        AbstractOntologyServiceTest.printCurrentTest();
        OntologyTerm ot = os.getTerm(TERM_ACCESSION);
        Assert.assertNotNull((String)"Null returned", (Object)ot);
        AbstractOntologyServiceTest.println(ot);
    }

    @Test
    public final void testGetTermPath() throws OntologyServiceException {
        AbstractOntologyServiceTest.printCurrentTest();
        List<OntologyTerm> list = os.getTermPath(ONTOLOGY_ACCESSION, TERM_ACCESSION);
        junit.framework.Assert.assertTrue((String)"No path found!", (list.size() > 1 ? 1 : 0) != 0);
        for (OntologyTerm ot : list) {
            AbstractOntologyServiceTest.println(ot);
        }
    }

    @Test
    public void testGetChildren() throws OntologyServiceException {
        AbstractOntologyServiceTest.printCurrentTest();
        List<OntologyTerm> list = os.getChildren(ONTOLOGY_ACCESSION, TERM_ACCESSION);
        Assert.assertNotSame((String)"Empty list returned!", (Object)0, (Object)list.size());
        for (OntologyTerm ot : list) {
            AbstractOntologyServiceTest.println(ot);
        }
    }

    @Test
    @Ignore(value="This runs for more than 10 minutes on a remote service")
    public final void testGetAllChildren() throws OntologyServiceException {
        AbstractOntologyServiceTest.printCurrentTest();
        Set<OntologyTerm> set = os.getAllChildren(ONTOLOGY_ACCESSION, TERM_ACCESSION);
        Assert.assertNotSame((String)"Empty set returned!", (Object)0, (Object)set.size());
        for (OntologyTerm ot : set) {
            AbstractOntologyServiceTest.println(ot);
        }
    }

    @Test
    public final void testGetParents() throws OntologyServiceException {
        AbstractOntologyServiceTest.printCurrentTest();
        List<OntologyTerm> list = os.getParents(ONTOLOGY_ACCESSION, TERM_ACCESSION);
        Assert.assertNotSame((String)"Empty list returned!", (Object)0, (Object)list.size());
        for (OntologyTerm ot : list) {
            AbstractOntologyServiceTest.println(ot);
        }
    }

    @Test
    public final void testGetAllParents() throws OntologyServiceException {
        AbstractOntologyServiceTest.printCurrentTest();
        Set<OntologyTerm> set = os.getAllParents(ONTOLOGY_ACCESSION, TERM_ACCESSION);
        Assert.assertNotSame((String)"Empty set returned!", (Object)0, (Object)set.size());
        for (OntologyTerm ot : set) {
            AbstractOntologyServiceTest.println(ot);
        }
    }

    @Test
    public final void testGetAnnotations() throws OntologyServiceException {
        AbstractOntologyServiceTest.printCurrentTest();
        Map<String, List<String>> map = os.getAnnotations(ONTOLOGY_ACCESSION, TERM_ACCESSION);
        Assert.assertNotSame((String)"Empty map returned!", (Object)0, (Object)map.size());
        for (Map.Entry<String, List<String>> e : map.entrySet()) {
            AbstractOntologyServiceTest.println(e.getKey());
            for (String s : e.getValue()) {
                AbstractOntologyServiceTest.println("\t" + s);
            }
        }
    }

    @Test
    public final void testGetDefinitions() throws OntologyServiceException {
        AbstractOntologyServiceTest.printCurrentTest();
        AbstractOntologyServiceTest.println(ONTOLOGY_ACCESSION + " " + TERM_ACCESSION);
        List<String> list = os.getDefinitions(ONTOLOGY_ACCESSION, TERM_ACCESSION);
        Assert.assertNotSame((String)"Empty list returned!", (Object)0, (Object)list.size());
        AbstractOntologyServiceTest.println(list.get(0));
    }

    @Test
    public final void testGetSynonyms() throws OntologyServiceException {
        AbstractOntologyServiceTest.printCurrentTest();
        List<String> list = os.getSynonyms(ONTOLOGY_ACCESSION, TERM_ACCESSION);
        Assert.assertNotSame((String)"Empty list returned!", (Object)0, (Object)list.size());
        AbstractOntologyServiceTest.println(list.get(0));
    }

    protected static void printCurrentTest() {
        AbstractOntologyServiceTest.println();
        AbstractOntologyServiceTest.println("**************************");
        AbstractOntologyServiceTest.println(Thread.currentThread().getStackTrace()[2].getMethodName().substring(4));
        AbstractOntologyServiceTest.println("*************************");
        AbstractOntologyServiceTest.println();
    }

    private static void println() {
        System.out.println();
    }

    protected static void println(Object o) {
        System.out.println(o);
    }

    static {
        TERM_ACCESSION = "GO:0043227";
        log = Logger.getLogger(AbstractOntologyServiceTest.class);
    }
}

