/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.tableau;

import java.io.Serializable;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.model.AnnotatedEquality;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.Equality;
import org.semanticweb.HermiT.tableau.DependencySet;
import org.semanticweb.HermiT.tableau.ExtensionManager;
import org.semanticweb.HermiT.tableau.GroundDisjunctionHeader;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.PermanentDependencySet;
import org.semanticweb.HermiT.tableau.Tableau;

public final class GroundDisjunction
implements Serializable {
    private static final long serialVersionUID = 6245673952732442673L;
    protected final GroundDisjunctionHeader m_groundDisjunctionHeader;
    protected final Node[] m_arguments;
    protected final boolean[] m_isCore;
    protected PermanentDependencySet m_dependencySet;
    protected GroundDisjunction m_previousGroundDisjunction;
    protected GroundDisjunction m_nextGroundDisjunction;

    public GroundDisjunction(Tableau tableau, GroundDisjunctionHeader groundDisjunctionHeader, Node[] nodeArray, boolean[] blArray, DependencySet dependencySet) {
        this.m_groundDisjunctionHeader = groundDisjunctionHeader;
        this.m_arguments = nodeArray;
        this.m_isCore = blArray;
        this.m_dependencySet = tableau.m_dependencySetFactory.getPermanent(dependencySet);
        tableau.m_dependencySetFactory.addUsage(this.m_dependencySet);
    }

    public GroundDisjunction getPreviousGroundDisjunction() {
        return this.m_previousGroundDisjunction;
    }

    public GroundDisjunction getNextGroundDisjunction() {
        return this.m_nextGroundDisjunction;
    }

    public void destroy(Tableau tableau) {
        tableau.m_dependencySetFactory.removeUsage(this.m_dependencySet);
        this.m_dependencySet = null;
    }

    public int getNumberOfDisjuncts() {
        return this.m_groundDisjunctionHeader.m_dlPredicates.length;
    }

    public DLPredicate getDLPredicate(int n) {
        return this.m_groundDisjunctionHeader.m_dlPredicates[n];
    }

    public Node getArgument(int n, int n2) {
        return this.m_arguments[this.m_groundDisjunctionHeader.m_disjunctStart[n] + n2];
    }

    public boolean isCore(int n) {
        return this.m_isCore[n];
    }

    public DependencySet getDependencySet() {
        return this.m_dependencySet;
    }

    public GroundDisjunctionHeader getGroundDisjunctionHeader() {
        return this.m_groundDisjunctionHeader;
    }

    public boolean isPruned() {
        for (int i = this.m_arguments.length - 1; i >= 0; --i) {
            if (!this.m_arguments[i].isPruned()) continue;
            return true;
        }
        return false;
    }

    public boolean isSatisfied(Tableau tableau) {
        ExtensionManager extensionManager = tableau.m_extensionManager;
        block5: for (int i = 0; i < this.getNumberOfDisjuncts(); ++i) {
            DLPredicate dLPredicate = this.getDLPredicate(i);
            switch (dLPredicate.getArity()) {
                case 1: {
                    if (!extensionManager.containsAssertion(dLPredicate, this.getArgument(i, 0).getCanonicalNode())) continue block5;
                    return true;
                }
                case 2: {
                    if (!extensionManager.containsAssertion(dLPredicate, this.getArgument(i, 0).getCanonicalNode(), this.getArgument(i, 1).getCanonicalNode())) continue block5;
                    return true;
                }
                case 3: {
                    if (dLPredicate instanceof AnnotatedEquality) {
                        if (!extensionManager.containsAnnotatedEquality((AnnotatedEquality)dLPredicate, this.getArgument(i, 0).getCanonicalNode(), this.getArgument(i, 1).getCanonicalNode(), this.getArgument(i, 2).getCanonicalNode())) continue block5;
                        return true;
                    }
                }
                default: {
                    throw new IllegalStateException("Invalid arity of DL-predicate.");
                }
            }
        }
        return false;
    }

    public boolean addDisjunctToTableau(Tableau tableau, int n, DependencySet dependencySet) {
        DLPredicate dLPredicate = this.getDLPredicate(n);
        switch (dLPredicate.getArity()) {
            case 1: {
                dependencySet = this.getArgument(n, 0).addCanonicalNodeDependencySet(dependencySet);
                return tableau.m_extensionManager.addAssertion(dLPredicate, this.getArgument(n, 0).getCanonicalNode(), dependencySet, this.isCore(n));
            }
            case 2: {
                dependencySet = this.getArgument(n, 0).addCanonicalNodeDependencySet(dependencySet);
                dependencySet = this.getArgument(n, 1).addCanonicalNodeDependencySet(dependencySet);
                return tableau.m_extensionManager.addAssertion(dLPredicate, this.getArgument(n, 0).getCanonicalNode(), this.getArgument(n, 1).getCanonicalNode(), dependencySet, this.isCore(n));
            }
            case 3: {
                if (!(dLPredicate instanceof AnnotatedEquality)) break;
                dependencySet = this.getArgument(n, 0).addCanonicalNodeDependencySet(dependencySet);
                dependencySet = this.getArgument(n, 1).addCanonicalNodeDependencySet(dependencySet);
                dependencySet = this.getArgument(n, 2).addCanonicalNodeDependencySet(dependencySet);
                return tableau.m_extensionManager.addAnnotatedEquality((AnnotatedEquality)dLPredicate, this.getArgument(n, 0).getCanonicalNode(), this.getArgument(n, 1).getCanonicalNode(), this.getArgument(n, 2).getCanonicalNode(), dependencySet);
            }
        }
        throw new IllegalStateException("Unsupported predicate arity.");
    }

    public String toString(Prefixes prefixes) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.getNumberOfDisjuncts(); ++i) {
            DLPredicate dLPredicate;
            if (i != 0) {
                stringBuffer.append(" v ");
            }
            if (Equality.INSTANCE.equals(dLPredicate = this.getDLPredicate(i))) {
                stringBuffer.append(this.getArgument(i, 0).getNodeID());
                stringBuffer.append(" == ");
                stringBuffer.append(this.getArgument(i, 1).getNodeID());
                continue;
            }
            if (dLPredicate instanceof AnnotatedEquality) {
                AnnotatedEquality annotatedEquality = (AnnotatedEquality)dLPredicate;
                stringBuffer.append('[');
                stringBuffer.append(this.getArgument(i, 0).getNodeID());
                stringBuffer.append(" == ");
                stringBuffer.append(this.getArgument(i, 1).getNodeID());
                stringBuffer.append("]@atMost(");
                stringBuffer.append(annotatedEquality.getCaridnality());
                stringBuffer.append(' ');
                stringBuffer.append(annotatedEquality.getOnRole().toString(prefixes));
                stringBuffer.append(' ');
                stringBuffer.append(annotatedEquality.getToConcept().toString(prefixes));
                stringBuffer.append(")(");
                stringBuffer.append(this.getArgument(i, 2).getNodeID());
                stringBuffer.append(')');
                continue;
            }
            stringBuffer.append(dLPredicate.toString(prefixes));
            stringBuffer.append('(');
            for (int j = 0; j < dLPredicate.getArity(); ++j) {
                if (j != 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.getArgument(i, j).getNodeID());
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(Prefixes.STANDARD_PREFIXES);
    }
}

