/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger.commands;

import java.io.PrintWriter;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.debugger.commands.AbstractCommand;
import org.semanticweb.HermiT.existentials.ExistentialExpansionStrategy;
import org.semanticweb.HermiT.existentials.IndividualReuseStrategy;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.tableau.Node;

public class ReuseNodeForCommand
extends AbstractCommand {
    public ReuseNodeForCommand(Debugger debugger) {
        super(debugger);
    }

    public String getCommandName() {
        return "reuseNodeFor";
    }

    public String[] getDescription() {
        return new String[]{"nodeID", "prints concepts for which the given node is a reuse node under individual reuse strategy"};
    }

    public void printHelp(PrintWriter printWriter) {
        printWriter.println("usage: reuseNodeFor nodeID");
        printWriter.println("    If individual reuse strategy is used, prints the concepts for which the given node is a reuse node.");
    }

    public void execute(String[] stringArray) {
        int n;
        if (stringArray.length < 2) {
            this.m_debugger.getOutput().println("Node ID is missing.");
            return;
        }
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            this.m_debugger.getOutput().println("Invalid ID of the node.");
            return;
        }
        Node node = this.m_debugger.getTableau().getNode(n);
        if (node == null) {
            this.m_debugger.getOutput().println("Node with ID '" + n + "' not found.");
            return;
        }
        ExistentialExpansionStrategy existentialExpansionStrategy = this.m_debugger.getTableau().getExistentialsExpansionStrategy();
        if (existentialExpansionStrategy instanceof IndividualReuseStrategy) {
            IndividualReuseStrategy individualReuseStrategy = (IndividualReuseStrategy)existentialExpansionStrategy;
            AtomicConcept atomicConcept = individualReuseStrategy.getConceptForNode(node);
            this.m_debugger.getOutput().print("Node '");
            this.m_debugger.getOutput().print(node.getNodeID());
            this.m_debugger.getOutput().print("' is ");
            if (atomicConcept == null) {
                this.m_debugger.getOutput().println("not a reuse node for any concept.");
            } else {
                this.m_debugger.getOutput().print("a reuse node for the '");
                this.m_debugger.getOutput().print(atomicConcept.toString(this.m_debugger.getPrefixes()));
                this.m_debugger.getOutput().println("' concept.");
            }
        } else {
            this.m_debugger.getOutput().println("Node reuse strategy is not currently in effect.");
        }
    }
}

