/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.doublenum;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.semanticweb.HermiT.datatypes.ValueSpaceSubset;
import org.semanticweb.HermiT.datatypes.doublenum.DoubleInterval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoNaNDoubleSubset
implements ValueSpaceSubset {
    protected final List<DoubleInterval> m_intervals;

    public NoNaNDoubleSubset() {
        this.m_intervals = Collections.emptyList();
    }

    public NoNaNDoubleSubset(DoubleInterval doubleInterval) {
        this.m_intervals = Collections.singletonList(doubleInterval);
    }

    public NoNaNDoubleSubset(List<DoubleInterval> list) {
        this.m_intervals = list;
    }

    @Override
    public boolean hasCardinalityAtLeast(int n) {
        int n2 = n;
        for (int i = this.m_intervals.size() - 1; n2 > 0 && i >= 0; --i) {
            n2 = this.m_intervals.get(i).subtractSizeFrom(n2);
        }
        return n2 == 0;
    }

    @Override
    public boolean containsDataValue(Object object) {
        if (object instanceof Double) {
            double d = (Double)object;
            for (int i = this.m_intervals.size() - 1; i >= 0; --i) {
                if (!this.m_intervals.get(i).contains(d)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void enumerateDataValues(Collection<Object> collection) {
        for (int i = this.m_intervals.size() - 1; i >= 0; --i) {
            this.m_intervals.get(i).enumerateNumbers(collection);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("xsd:double{");
        for (int i = 0; i < this.m_intervals.size(); ++i) {
            if (i == 0) {
                stringBuffer.append('+');
            }
            stringBuffer.append(this.m_intervals.get(i).toString());
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

