/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.hierarchy;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.hierarchy.Hierarchy;
import org.semanticweb.HermiT.hierarchy.HierarchyNode;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.InverseRole;
import org.semanticweb.HermiT.model.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyPrinterFSS {
    protected final PrintWriter m_out;
    protected final String m_defaultPrefixIRI;
    protected final Set<String> m_prefixIRIs;
    protected Prefixes m_prefixes;

    public HierarchyPrinterFSS(PrintWriter printWriter, String string) {
        this.m_out = printWriter;
        this.m_defaultPrefixIRI = string;
        this.m_prefixIRIs = new TreeSet<String>();
        this.m_prefixIRIs.add(string);
        this.m_prefixIRIs.add(Prefixes.s_semanticWebPrefixes.get("owl"));
    }

    public void loadAtomicConceptPrefixIRIs(Collection<AtomicConcept> collection) {
        for (AtomicConcept atomicConcept : collection) {
            String string = atomicConcept.getIRI();
            int n = string.indexOf(35);
            if (n == -1) continue;
            String string2 = string.substring(0, n + 1);
            String string3 = string.substring(n + 1);
            if (!Prefixes.isValidLocalName(string3)) continue;
            this.m_prefixIRIs.add(string2);
        }
    }

    public void loadAtomicRolePrefixIRIs(Collection<AtomicRole> collection) {
        for (AtomicRole atomicRole : collection) {
            String string = atomicRole.getIRI();
            int n = string.indexOf(35);
            if (n == -1) continue;
            String string2 = string.substring(0, n + 1);
            String string3 = string.substring(n + 1);
            if (!Prefixes.isValidLocalName(string3)) continue;
            this.m_prefixIRIs.add(string2);
        }
    }

    public void startPrinting() {
        String string = Prefixes.s_semanticWebPrefixes.get("owl");
        this.m_prefixes = new Prefixes();
        this.m_prefixes.declareDefaultPrefix(this.m_defaultPrefixIRI);
        this.m_prefixes.declarePrefix("owl", string);
        int n = 1;
        for (String object : this.m_prefixIRIs) {
            if (this.m_defaultPrefixIRI.equals(object) || string.equals(object)) continue;
            String string2 = "a" + n++;
            this.m_prefixes.declarePrefix(string2, object);
        }
        for (Map.Entry entry : this.m_prefixes.getPrefixIRIsByPrefixName().entrySet()) {
            if ("owl".equals(entry.getKey())) continue;
            this.m_out.println("Prefix(" + (String)entry.getKey() + ":=<" + (String)entry.getValue() + ">)");
        }
        this.m_out.println();
        this.m_out.println("Ontology(<" + this.m_prefixes.getPrefixIRIsByPrefixName().get("") + ">");
        this.m_out.println();
    }

    public void printAtomicConceptHierarchy(Hierarchy<AtomicConcept> hierarchy) {
        Hierarchy<AtomicConcept> hierarchy2 = hierarchy.transform(new IdentityTransformer(), AtomicConceptComparator.INSTANCE);
        AtomicConceptPrinter atomicConceptPrinter = new AtomicConceptPrinter(hierarchy2.getBottomNode());
        hierarchy2.traverseDepthFirst(atomicConceptPrinter);
        atomicConceptPrinter.printNode(0, hierarchy2.getBottomNode(), null, true);
    }

    public void printRoleHierarchy(Hierarchy<? extends Role> hierarchy, boolean bl) {
        Hierarchy<Role> hierarchy2 = hierarchy.transform(new IdentityTransformer(), RoleComparator.INSTANCE);
        RolePrinter rolePrinter = new RolePrinter(hierarchy2, bl);
        hierarchy2.traverseDepthFirst(rolePrinter);
        rolePrinter.printNode(0, hierarchy2.getBottomNode(), null, true);
    }

    public void endPrinting() {
        this.m_out.println();
        this.m_out.println(")");
        this.m_out.flush();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class IdentityTransformer<E>
    implements Hierarchy.Transformer<E, E> {
        protected IdentityTransformer() {
        }

        @Override
        public E transform(E e) {
            return e;
        }

        @Override
        public E determineRepresentative(E e, Set<E> set) {
            return ((SortedSet)set).first();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AtomicConceptComparator
    implements Comparator<AtomicConcept> {
        public static final AtomicConceptComparator INSTANCE = new AtomicConceptComparator();

        protected AtomicConceptComparator() {
        }

        @Override
        public int compare(AtomicConcept atomicConcept, AtomicConcept atomicConcept2) {
            int n = this.getAtomicConceptClass(atomicConcept) - this.getAtomicConceptClass(atomicConcept2);
            if (n != 0) {
                return n;
            }
            return atomicConcept.getIRI().compareTo(atomicConcept2.getIRI());
        }

        protected int getAtomicConceptClass(AtomicConcept atomicConcept) {
            if (AtomicConcept.NOTHING.equals(atomicConcept)) {
                return 0;
            }
            if (AtomicConcept.THING.equals(atomicConcept)) {
                return 1;
            }
            return 2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RoleComparator
    implements Comparator<Role> {
        public static final RoleComparator INSTANCE = new RoleComparator();

        protected RoleComparator() {
        }

        @Override
        public int compare(Role role, Role role2) {
            int n = this.getRoleClass(role) - this.getRoleClass(role2);
            if (n != 0) {
                return n;
            }
            n = this.getRoleDirection(role) - this.getRoleDirection(role2);
            if (n != 0) {
                return n;
            }
            return this.getInnerAtomicRole(role).getIRI().compareTo(this.getInnerAtomicRole(role2).getIRI());
        }

        protected int getRoleClass(Role role) {
            if (AtomicRole.BOTTOM_OBJECT_ROLE.equals(role)) {
                return 0;
            }
            if (AtomicRole.TOP_OBJECT_ROLE.equals(role)) {
                return 1;
            }
            if (AtomicRole.BOTTOM_DATA_ROLE.equals(role)) {
                return 2;
            }
            if (AtomicRole.TOP_DATA_ROLE.equals(role)) {
                return 3;
            }
            return 4;
        }

        protected AtomicRole getInnerAtomicRole(Role role) {
            if (role instanceof AtomicRole) {
                return (AtomicRole)role;
            }
            return ((InverseRole)role).getInverseOf();
        }

        protected int getRoleDirection(Role role) {
            return role instanceof AtomicRole ? 0 : 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RolePrinter
    implements Hierarchy.HierarchyNodeVisitor<Role> {
        protected final Hierarchy<Role> m_hierarchy;
        protected final boolean m_objectProperties;

        public RolePrinter(Hierarchy<Role> hierarchy, boolean bl) {
            this.m_hierarchy = hierarchy;
            this.m_objectProperties = bl;
        }

        @Override
        public boolean redirect(HierarchyNode<Role>[] hierarchyNodeArray) {
            return true;
        }

        @Override
        public void visit(int n, HierarchyNode<Role> hierarchyNode, HierarchyNode<Role> hierarchyNode2, boolean bl) {
            if (!hierarchyNode.equals(this.m_hierarchy.getBottomNode())) {
                this.printNode(n, hierarchyNode, hierarchyNode2, bl);
            }
        }

        public void printNode(int n, HierarchyNode<Role> hierarchyNode, HierarchyNode<Role> hierarchyNode2, boolean bl) {
            Set<Role> set = hierarchyNode.getEquivalentElements();
            boolean bl2 = hierarchyNode2 != null;
            boolean bl3 = bl && set.size() > 1;
            boolean bl4 = false;
            if (bl) {
                for (Role object : set) {
                    if (!this.needsDeclaration(object)) continue;
                    bl4 = true;
                    break;
                }
            }
            if (bl2 || bl3 || bl4) {
                int n2;
                for (n2 = 2 * n; n2 > 0; --n2) {
                    HierarchyPrinterFSS.this.m_out.print(' ');
                }
                n2 = 1;
                if (bl2) {
                    if (this.m_objectProperties) {
                        HierarchyPrinterFSS.this.m_out.print("SubObjectPropertyOf( ");
                    } else {
                        HierarchyPrinterFSS.this.m_out.print("SubDataPropertyOf( ");
                    }
                    this.print(hierarchyNode.getRepresentative());
                    HierarchyPrinterFSS.this.m_out.print(' ');
                    this.print(hierarchyNode2.getRepresentative());
                    HierarchyPrinterFSS.this.m_out.print(" )");
                    n2 = 0;
                }
                if (bl3) {
                    if (n2 == 0) {
                        HierarchyPrinterFSS.this.m_out.print(' ');
                    }
                    if (this.m_objectProperties) {
                        HierarchyPrinterFSS.this.m_out.print("EquivalentObjectProperties(");
                    } else {
                        HierarchyPrinterFSS.this.m_out.print("EquivalentDataProperties(");
                    }
                    for (Role role : set) {
                        HierarchyPrinterFSS.this.m_out.print(' ');
                        this.print(role);
                    }
                    HierarchyPrinterFSS.this.m_out.print(" )");
                    n2 = 0;
                }
                if (bl4) {
                    for (Role role : set) {
                        if (!this.needsDeclaration(role)) continue;
                        if (n2 == 0) {
                            HierarchyPrinterFSS.this.m_out.print(' ');
                        }
                        HierarchyPrinterFSS.this.m_out.print("Declaration( ");
                        if (this.m_objectProperties) {
                            HierarchyPrinterFSS.this.m_out.print("ObjectProperty( ");
                        } else {
                            HierarchyPrinterFSS.this.m_out.print("DataProperty( ");
                        }
                        this.print(role);
                        HierarchyPrinterFSS.this.m_out.print(" ) )");
                        n2 = 0;
                    }
                }
                HierarchyPrinterFSS.this.m_out.println();
            }
        }

        protected void print(Role role) {
            if (role instanceof AtomicRole) {
                HierarchyPrinterFSS.this.m_out.print(HierarchyPrinterFSS.this.m_prefixes.abbreviateIRI(((AtomicRole)role).getIRI()));
            } else {
                HierarchyPrinterFSS.this.m_out.print("ObjectInverseOf( ");
                this.print(((InverseRole)role).getInverseOf());
                HierarchyPrinterFSS.this.m_out.print(" )");
            }
        }

        protected void print(AtomicRole atomicRole) {
            HierarchyPrinterFSS.this.m_out.print(HierarchyPrinterFSS.this.m_prefixes.abbreviateIRI(atomicRole.getIRI()));
        }

        protected boolean needsDeclaration(Role role) {
            return !AtomicRole.BOTTOM_OBJECT_ROLE.equals(role) && !AtomicRole.TOP_OBJECT_ROLE.equals(role) && !AtomicRole.BOTTOM_DATA_ROLE.equals(role) && !AtomicRole.TOP_DATA_ROLE.equals(role) && role instanceof AtomicRole;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AtomicConceptPrinter
    implements Hierarchy.HierarchyNodeVisitor<AtomicConcept> {
        protected final HierarchyNode<AtomicConcept> m_bottomNode;

        public AtomicConceptPrinter(HierarchyNode<AtomicConcept> hierarchyNode) {
            this.m_bottomNode = hierarchyNode;
        }

        @Override
        public boolean redirect(HierarchyNode<AtomicConcept>[] hierarchyNodeArray) {
            return true;
        }

        @Override
        public void visit(int n, HierarchyNode<AtomicConcept> hierarchyNode, HierarchyNode<AtomicConcept> hierarchyNode2, boolean bl) {
            if (!hierarchyNode.equals(this.m_bottomNode)) {
                this.printNode(n, hierarchyNode, hierarchyNode2, bl);
            }
        }

        public void printNode(int n, HierarchyNode<AtomicConcept> hierarchyNode, HierarchyNode<AtomicConcept> hierarchyNode2, boolean bl) {
            Set<AtomicConcept> set = hierarchyNode.getEquivalentElements();
            boolean bl2 = hierarchyNode2 != null;
            boolean bl3 = bl && set.size() > 1;
            boolean bl4 = false;
            if (bl) {
                for (AtomicConcept object : set) {
                    if (!this.needsDeclaration(object)) continue;
                    bl4 = true;
                    break;
                }
            }
            if (bl2 || bl3 || bl4) {
                int n2;
                for (n2 = 2 * n; n2 > 0; --n2) {
                    HierarchyPrinterFSS.this.m_out.print(' ');
                }
                n2 = 1;
                if (bl2) {
                    HierarchyPrinterFSS.this.m_out.print("SubClassOf( ");
                    this.print(hierarchyNode.getRepresentative());
                    HierarchyPrinterFSS.this.m_out.print(' ');
                    this.print(hierarchyNode2.getRepresentative());
                    HierarchyPrinterFSS.this.m_out.print(" )");
                    n2 = 0;
                }
                if (bl3) {
                    if (n2 == 0) {
                        HierarchyPrinterFSS.this.m_out.print(' ');
                    }
                    HierarchyPrinterFSS.this.m_out.print("EquivalentClasses(");
                    for (AtomicConcept atomicConcept : set) {
                        HierarchyPrinterFSS.this.m_out.print(' ');
                        this.print(atomicConcept);
                    }
                    HierarchyPrinterFSS.this.m_out.print(" )");
                    n2 = 0;
                }
                if (bl4) {
                    for (AtomicConcept atomicConcept : set) {
                        if (!this.needsDeclaration(atomicConcept)) continue;
                        if (n2 == 0) {
                            HierarchyPrinterFSS.this.m_out.print(' ');
                        }
                        HierarchyPrinterFSS.this.m_out.print("Declaration( Class( ");
                        this.print(atomicConcept);
                        HierarchyPrinterFSS.this.m_out.print(" ) )");
                        n2 = 0;
                    }
                }
                HierarchyPrinterFSS.this.m_out.println();
            }
        }

        protected void print(AtomicConcept atomicConcept) {
            HierarchyPrinterFSS.this.m_out.print(HierarchyPrinterFSS.this.m_prefixes.abbreviateIRI(atomicConcept.getIRI()));
        }

        protected boolean needsDeclaration(AtomicConcept atomicConcept) {
            return !AtomicConcept.NOTHING.equals(atomicConcept) && !AtomicConcept.THING.equals(atomicConcept);
        }
    }
}

