/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.Reasoner;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.InternalDatatype;
import org.semanticweb.HermiT.tableau.ReasoningTaskDescription;
import org.semanticweb.HermiT.tableau.Tableau;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLLogicalEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntailmentChecker
implements OWLAxiomVisitorEx<Boolean> {
    private final OWLDataFactory factory;
    private final Reasoner reasoner;
    protected Set<OWLAxiom> anonymousIndividualAxioms = new HashSet<OWLAxiom>();

    public EntailmentChecker(Reasoner reasoner, OWLDataFactory oWLDataFactory) {
        this.reasoner = reasoner;
        this.factory = oWLDataFactory;
    }

    public boolean entails(Set<? extends OWLAxiom> set) {
        this.anonymousIndividualAxioms.clear();
        for (OWLAxiom oWLAxiom : set) {
            if (!oWLAxiom.isLogicalAxiom() || oWLAxiom.accept(this).booleanValue()) continue;
            return false;
        }
        return this.checkAnonymousIndividuals();
    }

    public boolean entails(OWLAxiom oWLAxiom) {
        if (!oWLAxiom.accept(this).booleanValue()) {
            return false;
        }
        return this.checkAnonymousIndividuals();
    }

    protected boolean checkAnonymousIndividuals() {
        if (this.anonymousIndividualAxioms.isEmpty()) {
            return true;
        }
        AnonymousIndividualForestBuilder anonymousIndividualForestBuilder = new AnonymousIndividualForestBuilder();
        anonymousIndividualForestBuilder.constructConceptsForAnonymousIndividuals(this.factory, this.anonymousIndividualAxioms);
        for (OWLAxiom oWLAxiom : anonymousIndividualForestBuilder.getAnonIndAxioms()) {
            if (oWLAxiom.accept(this).booleanValue()) continue;
            return false;
        }
        for (OWLAxiom oWLAxiom : anonymousIndividualForestBuilder.getAnonNoNamedIndAxioms()) {
            Tableau tableau = this.reasoner.getTableau(oWLAxiom);
            if (!tableau.isSatisfiable(true, true, null, null, null, null, null, new ReasoningTaskDescription(false, "Anonymous individual check: " + oWLAxiom.toString(), new Object[0]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(OWLSubAnnotationPropertyOfAxiom oWLSubAnnotationPropertyOfAxiom) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(OWLAnnotationPropertyDomainAxiom oWLAnnotationPropertyDomainAxiom) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(OWLAnnotationPropertyRangeAxiom oWLAnnotationPropertyRangeAxiom) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(OWLDeclarationAxiom oWLDeclarationAxiom) {
        return Boolean.TRUE;
    }

    public Boolean visit(OWLImportsDeclaration oWLImportsDeclaration) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom) {
        ArrayList<OWLIndividual> arrayList = new ArrayList<OWLIndividual>(oWLDifferentIndividualsAxiom.getIndividuals());
        for (OWLIndividual oWLIndividual : arrayList) {
            if (!oWLIndividual.isAnonymous()) continue;
            throw new IllegalArgumentException("OWLDifferentIndividualsAxiom axioms are not allowed to be used with anonymous individuals (see OWL 2 Syntax Sec 11.2) but the axiom " + oWLDifferentIndividualsAxiom + " cotains an anonymous individual. ");
        }
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            OWLIndividual oWLIndividual;
            oWLIndividual = arrayList.get(i).asOWLNamedIndividual();
            for (int j = i + 1; j < arrayList.size(); ++j) {
                OWLNamedIndividual oWLNamedIndividual = arrayList.get(j).asOWLNamedIndividual();
                if (this.reasoner.hasType((OWLNamedIndividual)oWLIndividual, this.factory.getOWLObjectComplementOf(this.factory.getOWLObjectOneOf(oWLNamedIndividual)), false)) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(OWLSameIndividualAxiom oWLSameIndividualAxiom) {
        for (OWLIndividual oWLIndividual : oWLSameIndividualAxiom.getIndividuals()) {
            if (!oWLIndividual.isAnonymous()) continue;
            throw new IllegalArgumentException("OWLSameIndividualAxiom axioms are not allowed to be used with anonymous individuals (see OWL 2 Syntax Sec 11.2) but the axiom " + oWLSameIndividualAxiom + " cotains an anonymous individual. ");
        }
        Iterator<OWLIndividual> iterator = oWLSameIndividualAxiom.getIndividuals().iterator();
        if (iterator.hasNext()) {
            OWLIndividual oWLIndividual;
            oWLIndividual = iterator.next().asOWLNamedIndividual();
            while (iterator.hasNext()) {
                OWLNamedIndividual oWLNamedIndividual = iterator.next().asOWLNamedIndividual();
                if (this.reasoner.isSameIndividual((OWLNamedIndividual)oWLIndividual, oWLNamedIndividual)) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(OWLClassAssertionAxiom oWLClassAssertionAxiom) {
        OWLIndividual oWLIndividual = oWLClassAssertionAxiom.getIndividual();
        if (oWLIndividual.isAnonymous()) {
            this.anonymousIndividualAxioms.add(oWLClassAssertionAxiom);
            return true;
        }
        OWLClassExpression oWLClassExpression = oWLClassAssertionAxiom.getClassExpression();
        return this.reasoner.hasType(oWLIndividual.asOWLNamedIndividual(), oWLClassExpression, false);
    }

    @Override
    public Boolean visit(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
        OWLIndividual oWLIndividual = oWLObjectPropertyAssertionAxiom.getSubject();
        OWLIndividual oWLIndividual2 = (OWLIndividual)oWLObjectPropertyAssertionAxiom.getObject();
        if (oWLIndividual.isAnonymous() || oWLIndividual2.isAnonymous()) {
            this.anonymousIndividualAxioms.add(oWLObjectPropertyAssertionAxiom);
            return true;
        }
        return this.reasoner.hasObjectPropertyRelationship(oWLIndividual.asOWLNamedIndividual(), (OWLObjectPropertyExpression)oWLObjectPropertyAssertionAxiom.getProperty(), oWLIndividual2.asOWLNamedIndividual());
    }

    @Override
    public Boolean visit(OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom) {
        if (oWLNegativeObjectPropertyAssertionAxiom.getSubject().isAnonymous() || ((OWLIndividual)oWLNegativeObjectPropertyAssertionAxiom.getObject()).isAnonymous()) {
            throw new IllegalArgumentException("NegativeObjectPropertyAssertion axioms are not allowed to be used with anonymous individuals (see OWL 2 Syntax Sec 11.2) but the axiom " + oWLNegativeObjectPropertyAssertionAxiom + " cotains an anonymous subject or object. ");
        }
        OWLObjectHasValue oWLObjectHasValue = this.factory.getOWLObjectHasValue((OWLObjectPropertyExpression)oWLNegativeObjectPropertyAssertionAxiom.getProperty(), (OWLIndividual)oWLNegativeObjectPropertyAssertionAxiom.getObject());
        OWLObjectComplementOf oWLObjectComplementOf = this.factory.getOWLObjectComplementOf(oWLObjectHasValue);
        return this.reasoner.hasType(oWLNegativeObjectPropertyAssertionAxiom.getSubject().asOWLNamedIndividual(), oWLObjectComplementOf, false);
    }

    @Override
    public Boolean visit(OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom) {
        OWLIndividual oWLIndividual = oWLDataPropertyAssertionAxiom.getSubject();
        if (oWLIndividual.isAnonymous()) {
            this.anonymousIndividualAxioms.add(oWLDataPropertyAssertionAxiom);
            return true;
        }
        return this.reasoner.hasDataPropertyRelationship(oWLIndividual.asOWLNamedIndividual(), ((OWLDataPropertyExpression)oWLDataPropertyAssertionAxiom.getProperty()).asOWLDataProperty(), (OWLLiteral)oWLDataPropertyAssertionAxiom.getObject());
    }

    @Override
    public Boolean visit(OWLNegativeDataPropertyAssertionAxiom oWLNegativeDataPropertyAssertionAxiom) {
        if (oWLNegativeDataPropertyAssertionAxiom.getSubject().isAnonymous()) {
            throw new IllegalArgumentException("NegativeDataPropertyAssertion axioms are not allowed to be used with anonymous individuals (see OWL 2 Syntax Sec 11.2) and the subject " + oWLNegativeDataPropertyAssertionAxiom.getSubject() + " of the axiom " + oWLNegativeDataPropertyAssertionAxiom + " is anonymous. ");
        }
        OWLDataHasValue oWLDataHasValue = this.factory.getOWLDataHasValue((OWLDataPropertyExpression)oWLNegativeDataPropertyAssertionAxiom.getProperty(), (OWLLiteral)oWLNegativeDataPropertyAssertionAxiom.getObject());
        OWLObjectComplementOf oWLObjectComplementOf = this.factory.getOWLObjectComplementOf(oWLDataHasValue);
        return this.reasoner.hasType(oWLNegativeDataPropertyAssertionAxiom.getSubject().asOWLNamedIndividual(), oWLObjectComplementOf, false);
    }

    @Override
    public Boolean visit(OWLObjectPropertyDomainAxiom oWLObjectPropertyDomainAxiom) {
        return this.reasoner.isSubClassOf(this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)oWLObjectPropertyDomainAxiom.getProperty(), this.factory.getOWLThing()), oWLObjectPropertyDomainAxiom.getDomain());
    }

    @Override
    public Boolean visit(OWLObjectPropertyRangeAxiom oWLObjectPropertyRangeAxiom) {
        return this.reasoner.isSubClassOf(this.factory.getOWLThing(), this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)oWLObjectPropertyRangeAxiom.getProperty(), (OWLClassExpression)oWLObjectPropertyRangeAxiom.getRange()));
    }

    @Override
    public Boolean visit(OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom) {
        OWLObjectPropertyExpression oWLObjectPropertyExpression;
        OWLObjectPropertyExpression oWLObjectPropertyExpression2 = oWLInverseObjectPropertiesAxiom.getFirstProperty().getInverseProperty();
        return this.reasoner.isSubObjectPropertyExpressionOf(oWLObjectPropertyExpression2, oWLObjectPropertyExpression = oWLInverseObjectPropertiesAxiom.getSecondProperty()) && this.reasoner.isSubObjectPropertyExpressionOf(oWLObjectPropertyExpression, oWLObjectPropertyExpression2);
    }

    @Override
    public Boolean visit(OWLSymmetricObjectPropertyAxiom oWLSymmetricObjectPropertyAxiom) {
        return this.reasoner.isSymmetric((OWLObjectPropertyExpression)oWLSymmetricObjectPropertyAxiom.getProperty());
    }

    @Override
    public Boolean visit(OWLTransitiveObjectPropertyAxiom oWLTransitiveObjectPropertyAxiom) {
        return this.reasoner.isTransitive((OWLObjectPropertyExpression)oWLTransitiveObjectPropertyAxiom.getProperty());
    }

    @Override
    public Boolean visit(OWLReflexiveObjectPropertyAxiom oWLReflexiveObjectPropertyAxiom) {
        return this.reasoner.isReflexive((OWLObjectPropertyExpression)oWLReflexiveObjectPropertyAxiom.getProperty());
    }

    @Override
    public Boolean visit(OWLIrreflexiveObjectPropertyAxiom oWLIrreflexiveObjectPropertyAxiom) {
        return this.reasoner.isIrreflexive((OWLObjectPropertyExpression)oWLIrreflexiveObjectPropertyAxiom.getProperty());
    }

    @Override
    public Boolean visit(OWLAsymmetricObjectPropertyAxiom oWLAsymmetricObjectPropertyAxiom) {
        return this.reasoner.isAsymmetric((OWLObjectPropertyExpression)oWLAsymmetricObjectPropertyAxiom.getProperty());
    }

    @Override
    public Boolean visit(OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom) {
        Set set = oWLEquivalentObjectPropertiesAxiom.getProperties();
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            OWLObjectPropertyExpression oWLObjectPropertyExpression = (OWLObjectPropertyExpression)iterator.next();
            while (iterator.hasNext()) {
                OWLObjectPropertyExpression oWLObjectPropertyExpression2 = (OWLObjectPropertyExpression)iterator.next();
                if (this.reasoner.isSubObjectPropertyExpressionOf(oWLObjectPropertyExpression, oWLObjectPropertyExpression2) && this.reasoner.isSubObjectPropertyExpressionOf(oWLObjectPropertyExpression2, oWLObjectPropertyExpression)) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom) {
        return this.reasoner.isSubObjectPropertyExpressionOf((OWLObjectPropertyExpression)oWLSubObjectPropertyOfAxiom.getSubProperty(), (OWLObjectPropertyExpression)oWLSubObjectPropertyOfAxiom.getSuperProperty());
    }

    @Override
    public Boolean visit(OWLSubPropertyChainOfAxiom oWLSubPropertyChainOfAxiom) {
        return this.reasoner.isSubObjectPropertyExpressionOf(oWLSubPropertyChainOfAxiom.getPropertyChain(), oWLSubPropertyChainOfAxiom.getSuperProperty());
    }

    @Override
    public Boolean visit(OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom) {
        int n = oWLDisjointObjectPropertiesAxiom.getProperties().size();
        OWLObjectPropertyExpression[] oWLObjectPropertyExpressionArray = oWLDisjointObjectPropertiesAxiom.getProperties().toArray(new OWLObjectPropertyExpression[n]);
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (this.reasoner.isDisjointObjectProperty(oWLObjectPropertyExpressionArray[i], oWLObjectPropertyExpressionArray[j])) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(OWLFunctionalObjectPropertyAxiom oWLFunctionalObjectPropertyAxiom) {
        return this.reasoner.isFunctional((OWLObjectPropertyExpression)oWLFunctionalObjectPropertyAxiom.getProperty());
    }

    @Override
    public Boolean visit(OWLInverseFunctionalObjectPropertyAxiom oWLInverseFunctionalObjectPropertyAxiom) {
        return this.reasoner.isInverseFunctional((OWLObjectPropertyExpression)oWLInverseFunctionalObjectPropertyAxiom.getProperty());
    }

    @Override
    public Boolean visit(OWLDataPropertyDomainAxiom oWLDataPropertyDomainAxiom) {
        return this.reasoner.isSubClassOf(this.factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)oWLDataPropertyDomainAxiom.getProperty(), this.factory.getTopDatatype()), oWLDataPropertyDomainAxiom.getDomain());
    }

    @Override
    public Boolean visit(OWLDataPropertyRangeAxiom oWLDataPropertyRangeAxiom) {
        return this.reasoner.isSubClassOf(this.factory.getOWLThing(), this.factory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)oWLDataPropertyRangeAxiom.getProperty(), (OWLDataRange)oWLDataPropertyRangeAxiom.getRange()));
    }

    @Override
    public Boolean visit(OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom) {
        Set set = oWLEquivalentDataPropertiesAxiom.getProperties();
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            OWLDataProperty oWLDataProperty = ((OWLDataPropertyExpression)iterator.next()).asOWLDataProperty();
            while (iterator.hasNext()) {
                OWLDataProperty oWLDataProperty2;
                OWLDataProperty oWLDataProperty3 = oWLDataProperty.asOWLDataProperty();
                if (this.reasoner.isSubDataPropertyOf(oWLDataProperty3, oWLDataProperty2 = ((OWLDataPropertyExpression)iterator.next()).asOWLDataProperty()) && this.reasoner.isSubDataPropertyOf(oWLDataProperty2, oWLDataProperty3)) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(OWLSubDataPropertyOfAxiom oWLSubDataPropertyOfAxiom) {
        return this.reasoner.isSubDataPropertyOf(((OWLDataPropertyExpression)oWLSubDataPropertyOfAxiom.getSubProperty()).asOWLDataProperty(), ((OWLDataPropertyExpression)oWLSubDataPropertyOfAxiom.getSuperProperty()).asOWLDataProperty());
    }

    @Override
    public Boolean visit(OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom) {
        int n = oWLDisjointDataPropertiesAxiom.getProperties().size();
        OWLDataPropertyExpression[] oWLDataPropertyExpressionArray = oWLDisjointDataPropertiesAxiom.getProperties().toArray(new OWLDataPropertyExpression[n]);
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                OWLDataSomeValuesFrom oWLDataSomeValuesFrom = this.factory.getOWLDataSomeValuesFrom(oWLDataPropertyExpressionArray[i], this.factory.getOWLDatatype(IRI.create(InternalDatatype.RDFS_LITERAL.getIRI())));
                OWLDataSomeValuesFrom oWLDataSomeValuesFrom2 = this.factory.getOWLDataSomeValuesFrom(oWLDataPropertyExpressionArray[j], this.factory.getOWLDatatype(IRI.create(InternalDatatype.RDFS_LITERAL.getIRI())));
                OWLDataMaxCardinality oWLDataMaxCardinality = this.factory.getOWLDataMaxCardinality(1, this.factory.getOWLDataProperty(IRI.create(AtomicRole.TOP_DATA_ROLE.getIRI())));
                OWLObjectIntersectionOf oWLObjectIntersectionOf = this.factory.getOWLObjectIntersectionOf(oWLDataSomeValuesFrom, oWLDataSomeValuesFrom2, oWLDataMaxCardinality);
                if (!this.reasoner.isSatisfiable(oWLObjectIntersectionOf)) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(OWLFunctionalDataPropertyAxiom oWLFunctionalDataPropertyAxiom) {
        return this.reasoner.isFunctional(((OWLDataPropertyExpression)oWLFunctionalDataPropertyAxiom.getProperty()).asOWLDataProperty());
    }

    @Override
    public Boolean visit(OWLSubClassOfAxiom oWLSubClassOfAxiom) {
        return this.reasoner.isSubClassOf(oWLSubClassOfAxiom.getSubClass(), oWLSubClassOfAxiom.getSuperClass());
    }

    @Override
    public Boolean visit(OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom) {
        boolean bl = true;
        Iterator<OWLClassExpression> iterator = oWLEquivalentClassesAxiom.getClassExpressions().iterator();
        if (iterator.hasNext()) {
            OWLClassExpression oWLClassExpression = iterator.next();
            while (iterator.hasNext() && bl) {
                OWLClassExpression oWLClassExpression2 = iterator.next();
                bl = this.reasoner.isSubClassOf(oWLClassExpression, oWLClassExpression2) && this.reasoner.isSubClassOf(oWLClassExpression2, oWLClassExpression);
            }
        }
        return bl;
    }

    @Override
    public Boolean visit(OWLDisjointClassesAxiom oWLDisjointClassesAxiom) {
        int n = oWLDisjointClassesAxiom.getClassExpressions().size();
        OWLClassExpression[] oWLClassExpressionArray = oWLDisjointClassesAxiom.getClassExpressions().toArray(new OWLClassExpression[n]);
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                OWLObjectComplementOf oWLObjectComplementOf = this.factory.getOWLObjectComplementOf(oWLClassExpressionArray[j]);
                if (this.reasoner.isSubClassOf(oWLClassExpressionArray[i], oWLObjectComplementOf)) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(OWLDisjointUnionAxiom oWLDisjointUnionAxiom) {
        OWLClass oWLClass = oWLDisjointUnionAxiom.getOWLClass();
        HashSet<OWLClassExpression> hashSet = new HashSet<OWLClassExpression>(oWLDisjointUnionAxiom.getClassExpressions());
        hashSet.add(this.factory.getOWLObjectComplementOf(oWLClass));
        OWLObjectUnionOf oWLObjectUnionOf = this.factory.getOWLObjectUnionOf(hashSet);
        OWLObjectUnionOf oWLObjectUnionOf2 = this.factory.getOWLObjectUnionOf(this.factory.getOWLObjectComplementOf(this.factory.getOWLObjectUnionOf(oWLDisjointUnionAxiom.getClassExpressions())), oWLClass);
        HashSet<OWLObjectUnionOf> hashSet2 = new HashSet<OWLObjectUnionOf>();
        hashSet2.add(oWLObjectUnionOf);
        hashSet2.add(oWLObjectUnionOf2);
        int n = oWLDisjointUnionAxiom.getClassExpressions().size();
        OWLClassExpression[] oWLClassExpressionArray = oWLDisjointUnionAxiom.getClassExpressions().toArray(new OWLClassExpression[n]);
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                hashSet2.add(this.factory.getOWLObjectUnionOf(this.factory.getOWLObjectComplementOf(oWLClassExpressionArray[i]), this.factory.getOWLObjectComplementOf(oWLClassExpressionArray[j])));
            }
        }
        OWLObjectIntersectionOf oWLObjectIntersectionOf = this.factory.getOWLObjectIntersectionOf(hashSet2);
        return !this.reasoner.isSatisfiable(this.factory.getOWLObjectComplementOf(oWLObjectIntersectionOf));
    }

    @Override
    public Boolean visit(OWLDatatypeDefinitionAxiom oWLDatatypeDefinitionAxiom) {
        this.reasoner.throwInconsistentOntologyExceptionIfNecessary();
        if (!this.reasoner.isConsistent()) {
            return true;
        }
        if (this.reasoner.m_dlOntology.hasDatatypes()) {
            OWLDataFactory oWLDataFactory = this.reasoner.getDataFactory();
            OWLAnonymousIndividual oWLAnonymousIndividual = oWLDataFactory.getOWLAnonymousIndividual("fresh-individual");
            OWLDataProperty oWLDataProperty = oWLDataFactory.getOWLDataProperty(IRI.create("fresh-data-property"));
            OWLDataRange oWLDataRange = oWLDatatypeDefinitionAxiom.getDataRange();
            OWLDatatype oWLDatatype = oWLDatatypeDefinitionAxiom.getDatatype();
            OWLDataIntersectionOf oWLDataIntersectionOf = oWLDataFactory.getOWLDataIntersectionOf(oWLDataFactory.getOWLDataComplementOf(oWLDataRange), oWLDatatype);
            OWLDataIntersectionOf oWLDataIntersectionOf2 = oWLDataFactory.getOWLDataIntersectionOf(oWLDataFactory.getOWLDataComplementOf(oWLDatatype), oWLDataRange);
            OWLDataUnionOf oWLDataUnionOf = oWLDataFactory.getOWLDataUnionOf(oWLDataIntersectionOf, oWLDataIntersectionOf2);
            OWLDataSomeValuesFrom oWLDataSomeValuesFrom = oWLDataFactory.getOWLDataSomeValuesFrom(oWLDataProperty, oWLDataUnionOf);
            OWLClassAssertionAxiom oWLClassAssertionAxiom = oWLDataFactory.getOWLClassAssertionAxiom(oWLDataSomeValuesFrom, oWLAnonymousIndividual);
            Tableau tableau = this.reasoner.getTableau(oWLClassAssertionAxiom);
            return !tableau.isSatisfiable(true, true, null, null, null, null, null, ReasoningTaskDescription.isAxiomEntailed(oWLDatatypeDefinitionAxiom));
        }
        return false;
    }

    @Override
    public Boolean visit(SWRLRule sWRLRule) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean visit(OWLHasKeyAxiom oWLHasKeyAxiom) {
        OWLLogicalEntity oWLLogicalEntity;
        this.reasoner.throwFreshEntityExceptionIfNecessary(oWLHasKeyAxiom);
        this.reasoner.throwInconsistentOntologyExceptionIfNecessary();
        if (!this.reasoner.isConsistent()) {
            return true;
        }
        OWLOntologyManager oWLOntologyManager = OWLManager.createOWLOntologyManager();
        OWLDataFactory oWLDataFactory = oWLOntologyManager.getOWLDataFactory();
        OWLNamedIndividual oWLNamedIndividual = oWLDataFactory.getOWLNamedIndividual(IRI.create("internal:named-fresh-individual-A"));
        OWLNamedIndividual oWLNamedIndividual2 = oWLDataFactory.getOWLNamedIndividual(IRI.create("internal:named-fresh-individual-B"));
        HashSet<OWLIndividualAxiom> hashSet = new HashSet<OWLIndividualAxiom>();
        hashSet.add(oWLDataFactory.getOWLClassAssertionAxiom(oWLHasKeyAxiom.getClassExpression(), oWLNamedIndividual));
        hashSet.add(oWLDataFactory.getOWLClassAssertionAxiom(oWLHasKeyAxiom.getClassExpression(), oWLNamedIndividual2));
        int n = 0;
        for (OWLObjectPropertyExpression sWRLPredicate : oWLHasKeyAxiom.getObjectPropertyExpressions()) {
            oWLLogicalEntity = oWLDataFactory.getOWLNamedIndividual(IRI.create("internal:named-fresh-individual-" + n));
            hashSet.add(oWLDataFactory.getOWLObjectPropertyAssertionAxiom(sWRLPredicate, oWLNamedIndividual, (OWLIndividual)((Object)oWLLogicalEntity)));
            hashSet.add(oWLDataFactory.getOWLObjectPropertyAssertionAxiom(sWRLPredicate, oWLNamedIndividual2, (OWLIndividual)((Object)oWLLogicalEntity)));
            ++n;
        }
        for (OWLDataPropertyExpression oWLDataPropertyExpression : oWLHasKeyAxiom.getDataPropertyExpressions()) {
            oWLLogicalEntity = oWLDataFactory.getOWLDatatype(IRI.create("internal:anonymous-constants"));
            OWLLiteral oWLLiteral = oWLDataFactory.getOWLLiteral("internal:constant-" + n, (OWLDatatype)oWLLogicalEntity);
            hashSet.add(oWLDataFactory.getOWLDataPropertyAssertionAxiom(oWLDataPropertyExpression, (OWLIndividual)oWLNamedIndividual, oWLLiteral));
            hashSet.add(oWLDataFactory.getOWLDataPropertyAssertionAxiom(oWLDataPropertyExpression, (OWLIndividual)oWLNamedIndividual2, oWLLiteral));
            ++n;
        }
        hashSet.add(oWLDataFactory.getOWLDifferentIndividualsAxiom(oWLNamedIndividual, oWLNamedIndividual2));
        Tableau tableau = this.reasoner.getTableau(hashSet.toArray(new OWLAxiom[hashSet.size()]));
        return !tableau.isSatisfiable(true, true, null, null, null, null, null, ReasoningTaskDescription.isAxiomEntailed(oWLHasKeyAxiom));
    }

    protected class Edge {
        public final OWLAnonymousIndividual first;
        public final OWLAnonymousIndividual second;

        public Edge(OWLAnonymousIndividual oWLAnonymousIndividual, OWLAnonymousIndividual oWLAnonymousIndividual2) {
            this.first = oWLAnonymousIndividual;
            this.second = oWLAnonymousIndividual2;
        }

        public int hashCode() {
            return 13 + 3 * (this.first != null ? this.first.hashCode() : 0) + 7 * (this.second != null ? this.second.hashCode() : 0);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Edge edge = (Edge)object;
            return this.first.equals(edge.first) && this.second.equals(edge.second);
        }

        public String toString() {
            return "(" + this.first + ", " + this.second + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AnonymousIndividualForestBuilder
    implements OWLAxiomVisitor {
        protected final Set<OWLNamedIndividual> namedNodes = new HashSet<OWLNamedIndividual>();
        protected final Set<OWLAnonymousIndividual> nodes = new HashSet<OWLAnonymousIndividual>();
        protected final Map<OWLAnonymousIndividual, Set<OWLAnonymousIndividual>> edges = new HashMap<OWLAnonymousIndividual, Set<OWLAnonymousIndividual>>();
        protected final Map<OWLAnonymousIndividual, Map<OWLNamedIndividual, Set<OWLObjectPropertyExpression>>> specialOPEdges = new HashMap<OWLAnonymousIndividual, Map<OWLNamedIndividual, Set<OWLObjectPropertyExpression>>>();
        protected final Map<OWLAnonymousIndividual, Set<OWLClassExpression>> nodelLabels = new HashMap<OWLAnonymousIndividual, Set<OWLClassExpression>>();
        protected final Map<Edge, OWLObjectProperty> edgeOPLabels = new HashMap<Edge, OWLObjectProperty>();
        protected final Set<OWLAxiom> anonIndAxioms = new HashSet<OWLAxiom>();
        protected final Set<OWLAxiom> anonNoNamedIndAxioms = new HashSet<OWLAxiom>();

        protected AnonymousIndividualForestBuilder() {
        }

        public void constructConceptsForAnonymousIndividuals(OWLDataFactory oWLDataFactory, Set<OWLAxiom> set) {
            for (OWLAxiom object2 : set) {
                object2.accept(this);
            }
            Set<Set<OWLAnonymousIndividual>> set2 = this.getComponents();
            Map<Set<OWLAnonymousIndividual>, OWLAnonymousIndividual> map = this.findSuitableRoots(set2);
            for (Set<OWLAnonymousIndividual> set3 : map.keySet()) {
                Map<OWLNamedIndividual, Set<OWLObjectPropertyExpression>> map2;
                OWLAnonymousIndividual oWLAnonymousIndividual = map.get(set3);
                if (!this.specialOPEdges.containsKey(oWLAnonymousIndividual)) {
                    map2 = this.getClassExpressionFor(oWLDataFactory, oWLAnonymousIndividual, null);
                    this.anonNoNamedIndAxioms.add(oWLDataFactory.getOWLSubClassOfAxiom(oWLDataFactory.getOWLThing(), oWLDataFactory.getOWLObjectComplementOf((OWLClassExpression)((Object)map2))));
                    continue;
                }
                map2 = this.specialOPEdges.get(oWLAnonymousIndividual);
                if (map2.size() != 1) {
                    throw new RuntimeException("Internal error: HermiT decided that the anonymous individuals form a valid forest, but actually they do not. ");
                }
                OWLNamedIndividual oWLNamedIndividual = (OWLNamedIndividual)map2.keySet().iterator().next();
                Set set4 = (Set)map2.get(oWLNamedIndividual);
                if (set4.size() != 1) {
                    throw new RuntimeException("Internal error: HermiT decided that the anonymous individuals form a valid forest, but actually they do not. ");
                }
                OWLObjectPropertyExpression oWLObjectPropertyExpression = ((OWLObjectPropertyExpression)set4.iterator().next()).getInverseProperty().getSimplified();
                OWLClassExpression oWLClassExpression = this.getClassExpressionFor(oWLDataFactory, oWLAnonymousIndividual, null);
                this.anonIndAxioms.add(oWLDataFactory.getOWLClassAssertionAxiom(oWLDataFactory.getOWLObjectSomeValuesFrom(oWLObjectPropertyExpression, oWLClassExpression), oWLNamedIndividual));
            }
        }

        public Set<OWLAxiom> getAnonIndAxioms() {
            return this.anonIndAxioms;
        }

        public Set<OWLAxiom> getAnonNoNamedIndAxioms() {
            return this.anonNoNamedIndAxioms;
        }

        protected OWLClassExpression getClassExpressionFor(OWLDataFactory oWLDataFactory, OWLAnonymousIndividual oWLAnonymousIndividual, OWLAnonymousIndividual oWLAnonymousIndividual2) {
            Set<OWLAnonymousIndividual> set = this.edges.get(oWLAnonymousIndividual);
            if (set == null || set.size() == 1 && set.iterator().next() == oWLAnonymousIndividual2) {
                if (!this.nodelLabels.containsKey(oWLAnonymousIndividual)) {
                    return oWLDataFactory.getOWLThing();
                }
                if (this.nodelLabels.get(oWLAnonymousIndividual).size() == 1) {
                    return this.nodelLabels.get(oWLAnonymousIndividual).iterator().next();
                }
                return oWLDataFactory.getOWLObjectIntersectionOf(this.nodelLabels.get(oWLAnonymousIndividual));
            }
            HashSet<OWLObjectSomeValuesFrom> hashSet = new HashSet<OWLObjectSomeValuesFrom>();
            for (OWLAnonymousIndividual oWLAnonymousIndividual3 : set) {
                OWLObjectProperty oWLObjectProperty;
                Edge edge = new Edge(oWLAnonymousIndividual, oWLAnonymousIndividual3);
                if (this.edgeOPLabels.containsKey(edge)) {
                    oWLObjectProperty = this.edgeOPLabels.get(edge);
                } else {
                    edge = new Edge(oWLAnonymousIndividual3, oWLAnonymousIndividual);
                    if (!this.edgeOPLabels.containsKey(edge)) {
                        throw new RuntimeException("Internal error: some edge in the forest of anonymous individuals has no edge label although it should. ");
                    }
                    oWLObjectProperty = this.edgeOPLabels.get(edge);
                }
                hashSet.add(oWLDataFactory.getOWLObjectSomeValuesFrom(oWLObjectProperty, this.getClassExpressionFor(oWLDataFactory, oWLAnonymousIndividual3, oWLAnonymousIndividual)));
            }
            return hashSet.size() == 1 ? (OWLClassExpression)hashSet.iterator().next() : oWLDataFactory.getOWLObjectIntersectionOf(hashSet);
        }

        protected Map<Set<OWLAnonymousIndividual>, OWLAnonymousIndividual> findSuitableRoots(Set<Set<OWLAnonymousIndividual>> set) {
            HashMap<Set<OWLAnonymousIndividual>, OWLAnonymousIndividual> hashMap = new HashMap<Set<OWLAnonymousIndividual>, OWLAnonymousIndividual>();
            for (Set<OWLAnonymousIndividual> set2 : set) {
                OWLAnonymousIndividual oWLAnonymousIndividual = null;
                OWLAnonymousIndividual oWLAnonymousIndividual2 = null;
                for (OWLAnonymousIndividual oWLAnonymousIndividual3 : set2) {
                    if (this.specialOPEdges.containsKey(oWLAnonymousIndividual3)) {
                        if (this.specialOPEdges.get(oWLAnonymousIndividual3).size() >= 2) continue;
                        oWLAnonymousIndividual2 = oWLAnonymousIndividual3;
                        continue;
                    }
                    oWLAnonymousIndividual = oWLAnonymousIndividual3;
                }
                if (oWLAnonymousIndividual == null && oWLAnonymousIndividual2 == null) {
                    throw new IllegalArgumentException("Invalid input ontology: One of the trees in the forst of anomnymous individuals has no root that satisfies the criteria on roots (cf. OWL 2 Structural Specification and Functional-Style Syntax, Sec. 11.2).");
                }
                if (oWLAnonymousIndividual2 != null) {
                    hashMap.put(set2, oWLAnonymousIndividual2);
                    continue;
                }
                hashMap.put(set2, oWLAnonymousIndividual);
            }
            return hashMap;
        }

        protected Set<Set<OWLAnonymousIndividual>> getComponents() {
            HashSet<Set<OWLAnonymousIndividual>> hashSet = new HashSet<Set<OWLAnonymousIndividual>>();
            if (this.nodes.isEmpty()) {
                return hashSet;
            }
            Set<OWLAnonymousIndividual> set = this.nodes;
            ArrayList<Edge> arrayList = new ArrayList<Edge>();
            while (!set.isEmpty()) {
                HashSet<OWLAnonymousIndividual> hashSet2 = new HashSet<OWLAnonymousIndividual>();
                Edge edge = new Edge(set.iterator().next(), null);
                arrayList.add(edge);
                while (!arrayList.isEmpty()) {
                    edge = (Edge)arrayList.remove(0);
                    hashSet2.add(edge.first);
                    if (!this.edges.containsKey(edge.first)) continue;
                    for (OWLAnonymousIndividual oWLAnonymousIndividual : this.edges.get(edge.first)) {
                        if (edge.second != null && oWLAnonymousIndividual.getID().equals(edge.second.getID())) continue;
                        for (Edge edge2 : arrayList) {
                            if (edge2.first != oWLAnonymousIndividual) continue;
                            throw new IllegalArgumentException("Invalid input ontology: The anonymous individuals cannot be arranged into a forest as required (cf. OWL 2 Structural Specification and Functional-Style Syntax, Sec. 11.2) because there is a cycle. ");
                        }
                        arrayList.add(new Edge(oWLAnonymousIndividual, edge.first));
                    }
                }
                hashSet.add(hashSet2);
                set.removeAll(hashSet2);
            }
            return hashSet;
        }

        @Override
        public void visit(OWLClassAssertionAxiom oWLClassAssertionAxiom) {
            if (oWLClassAssertionAxiom.getClassExpression().isOWLThing()) {
                return;
            }
            OWLIndividual oWLIndividual = oWLClassAssertionAxiom.getIndividual();
            if (!oWLIndividual.isAnonymous()) {
                this.namedNodes.add(oWLIndividual.asOWLNamedIndividual());
            } else {
                this.nodes.add(oWLIndividual.asOWLAnonymousIndividual());
                if (this.nodelLabels.containsKey(oWLIndividual)) {
                    this.nodelLabels.get(oWLIndividual).add(oWLClassAssertionAxiom.getClassExpression());
                } else {
                    HashSet<OWLClassExpression> hashSet = new HashSet<OWLClassExpression>();
                    hashSet.add(oWLClassAssertionAxiom.getClassExpression());
                    this.nodelLabels.put(oWLIndividual.asOWLAnonymousIndividual(), hashSet);
                }
            }
        }

        @Override
        public void visit(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
            OWLIndividual oWLIndividual = oWLObjectPropertyAssertionAxiom.getSubject();
            OWLIndividual oWLIndividual2 = (OWLIndividual)oWLObjectPropertyAssertionAxiom.getObject();
            OWLObjectPropertyExpression oWLObjectPropertyExpression = ((OWLObjectPropertyExpression)oWLObjectPropertyAssertionAxiom.getProperty()).getSimplified();
            if (!oWLIndividual.isAnonymous() && !oWLIndividual2.isAnonymous()) {
                return;
            }
            if (!oWLIndividual.isAnonymous() && oWLIndividual2.isAnonymous() || oWLIndividual.isAnonymous() && !oWLIndividual2.isAnonymous()) {
                OWLIndividual oWLIndividual3;
                if (!oWLIndividual.isAnonymous() && oWLIndividual2.isAnonymous()) {
                    oWLIndividual3 = oWLIndividual;
                    oWLIndividual = oWLIndividual2;
                    oWLIndividual2 = oWLIndividual3;
                    oWLObjectPropertyExpression = oWLObjectPropertyExpression.getInverseProperty().getSimplified();
                }
                oWLIndividual3 = oWLIndividual2.asOWLNamedIndividual();
                OWLAnonymousIndividual oWLAnonymousIndividual = oWLIndividual.asOWLAnonymousIndividual();
                this.namedNodes.add((OWLNamedIndividual)oWLIndividual3);
                this.nodes.add(oWLAnonymousIndividual);
                if (this.specialOPEdges.containsKey(oWLAnonymousIndividual)) {
                    Map<OWLNamedIndividual, Set<OWLObjectPropertyExpression>> map = this.specialOPEdges.get(oWLAnonymousIndividual);
                    if (map.containsKey(oWLIndividual3)) {
                        map.get(oWLIndividual3).add(oWLObjectPropertyExpression);
                    } else {
                        map = new HashMap<OWLNamedIndividual, Set<OWLObjectPropertyExpression>>();
                        HashSet<OWLObjectPropertyExpression> hashSet = new HashSet<OWLObjectPropertyExpression>();
                        hashSet.add(oWLObjectPropertyExpression);
                        map.put((OWLNamedIndividual)oWLIndividual3, (Set<OWLObjectPropertyExpression>)hashSet);
                        this.specialOPEdges.put(oWLAnonymousIndividual, map);
                    }
                } else {
                    HashMap hashMap = new HashMap();
                    HashSet<OWLObjectPropertyExpression> hashSet = new HashSet<OWLObjectPropertyExpression>();
                    hashSet.add(oWLObjectPropertyExpression);
                    hashMap.put((OWLNamedIndividual)oWLIndividual3, hashSet);
                    this.specialOPEdges.put(oWLAnonymousIndividual, hashMap);
                }
            } else {
                HashSet<OWLIndividual> hashSet;
                OWLIndividual oWLIndividual4;
                OWLObjectProperty oWLObjectProperty;
                if (oWLObjectPropertyExpression.isAnonymous()) {
                    oWLObjectProperty = oWLObjectPropertyExpression.getNamedProperty();
                    oWLIndividual4 = oWLIndividual;
                    oWLIndividual = oWLIndividual2;
                    oWLIndividual2 = oWLIndividual4;
                } else {
                    oWLObjectProperty = oWLObjectPropertyExpression.asOWLObjectProperty();
                }
                oWLIndividual4 = oWLIndividual.asOWLAnonymousIndividual();
                OWLAnonymousIndividual oWLAnonymousIndividual = oWLIndividual2.asOWLAnonymousIndividual();
                this.nodes.add((OWLAnonymousIndividual)oWLIndividual4);
                this.nodes.add(oWLAnonymousIndividual);
                if (this.edges.containsKey(oWLIndividual4) && this.edges.get(oWLIndividual4).contains(oWLAnonymousIndividual) || this.edges.containsKey(oWLAnonymousIndividual) && this.edges.get(oWLAnonymousIndividual).contains(oWLIndividual4)) {
                    throw new IllegalArgumentException("Invalid input ontology: There are two object property assertions for the same anonymous individuals, which is not allowed (see OWL 2 Syntax Sec 11.2). ");
                }
                if (this.edges.containsKey(oWLIndividual4)) {
                    this.edges.get(oWLIndividual4).add(oWLAnonymousIndividual);
                } else {
                    hashSet = new HashSet<OWLIndividual>();
                    hashSet.add(oWLAnonymousIndividual);
                    this.edges.put((OWLAnonymousIndividual)oWLIndividual4, hashSet);
                }
                if (this.edges.containsKey(oWLAnonymousIndividual)) {
                    this.edges.get(oWLAnonymousIndividual).add((OWLAnonymousIndividual)oWLIndividual4);
                } else {
                    hashSet = new HashSet();
                    hashSet.add(oWLIndividual4);
                    this.edges.put(oWLAnonymousIndividual, hashSet);
                }
                this.edgeOPLabels.put(new Edge((OWLAnonymousIndividual)oWLIndividual4, oWLAnonymousIndividual), oWLObjectProperty);
            }
        }

        @Override
        public void visit(OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom) {
            if (!oWLDataPropertyAssertionAxiom.getSubject().isAnonymous()) {
                return;
            }
            OWLAnonymousIndividual oWLAnonymousIndividual = oWLDataPropertyAssertionAxiom.getSubject().asOWLAnonymousIndividual();
            this.nodes.add(oWLAnonymousIndividual);
            OWLDataHasValue oWLDataHasValue = EntailmentChecker.this.factory.getOWLDataHasValue((OWLDataPropertyExpression)oWLDataPropertyAssertionAxiom.getProperty(), (OWLLiteral)oWLDataPropertyAssertionAxiom.getObject());
            if (this.nodelLabels.containsKey(oWLAnonymousIndividual)) {
                this.nodelLabels.get(oWLAnonymousIndividual).add(oWLDataHasValue);
            } else {
                HashSet<OWLDataHasValue> hashSet = new HashSet<OWLDataHasValue>();
                hashSet.add(oWLDataHasValue);
                this.nodelLabels.put(oWLAnonymousIndividual, hashSet);
            }
        }

        @Override
        public void visit(OWLDeclarationAxiom oWLDeclarationAxiom) {
        }

        @Override
        public void visit(OWLSubClassOfAxiom oWLSubClassOfAxiom) {
        }

        @Override
        public void visit(OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom) {
        }

        @Override
        public void visit(OWLAsymmetricObjectPropertyAxiom oWLAsymmetricObjectPropertyAxiom) {
        }

        @Override
        public void visit(OWLReflexiveObjectPropertyAxiom oWLReflexiveObjectPropertyAxiom) {
        }

        @Override
        public void visit(OWLDisjointClassesAxiom oWLDisjointClassesAxiom) {
        }

        @Override
        public void visit(OWLDataPropertyDomainAxiom oWLDataPropertyDomainAxiom) {
        }

        @Override
        public void visit(OWLObjectPropertyDomainAxiom oWLObjectPropertyDomainAxiom) {
        }

        @Override
        public void visit(OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom) {
        }

        @Override
        public void visit(OWLNegativeDataPropertyAssertionAxiom oWLNegativeDataPropertyAssertionAxiom) {
        }

        @Override
        public void visit(OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom) {
        }

        @Override
        public void visit(OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom) {
        }

        @Override
        public void visit(OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom) {
        }

        @Override
        public void visit(OWLObjectPropertyRangeAxiom oWLObjectPropertyRangeAxiom) {
        }

        @Override
        public void visit(OWLFunctionalObjectPropertyAxiom oWLFunctionalObjectPropertyAxiom) {
        }

        @Override
        public void visit(OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom) {
        }

        @Override
        public void visit(OWLDisjointUnionAxiom oWLDisjointUnionAxiom) {
        }

        @Override
        public void visit(OWLSymmetricObjectPropertyAxiom oWLSymmetricObjectPropertyAxiom) {
        }

        @Override
        public void visit(OWLDataPropertyRangeAxiom oWLDataPropertyRangeAxiom) {
        }

        @Override
        public void visit(OWLFunctionalDataPropertyAxiom oWLFunctionalDataPropertyAxiom) {
        }

        @Override
        public void visit(OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom) {
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom) {
        }

        @Override
        public void visit(OWLTransitiveObjectPropertyAxiom oWLTransitiveObjectPropertyAxiom) {
        }

        @Override
        public void visit(OWLIrreflexiveObjectPropertyAxiom oWLIrreflexiveObjectPropertyAxiom) {
        }

        @Override
        public void visit(OWLSubDataPropertyOfAxiom oWLSubDataPropertyOfAxiom) {
        }

        @Override
        public void visit(OWLInverseFunctionalObjectPropertyAxiom oWLInverseFunctionalObjectPropertyAxiom) {
        }

        @Override
        public void visit(OWLSameIndividualAxiom oWLSameIndividualAxiom) {
        }

        @Override
        public void visit(OWLSubPropertyChainOfAxiom oWLSubPropertyChainOfAxiom) {
        }

        @Override
        public void visit(OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom) {
        }

        @Override
        public void visit(OWLHasKeyAxiom oWLHasKeyAxiom) {
        }

        @Override
        public void visit(OWLDatatypeDefinitionAxiom oWLDatatypeDefinitionAxiom) {
        }

        @Override
        public void visit(SWRLRule sWRLRule) {
        }

        @Override
        public void visit(OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom) {
        }

        @Override
        public void visit(OWLSubAnnotationPropertyOfAxiom oWLSubAnnotationPropertyOfAxiom) {
        }

        @Override
        public void visit(OWLAnnotationPropertyDomainAxiom oWLAnnotationPropertyDomainAxiom) {
        }

        @Override
        public void visit(OWLAnnotationPropertyRangeAxiom oWLAnnotationPropertyRangeAxiom) {
        }
    }
}

