## ----knitr, echo=FALSE, results="hide"-----------------------------------
library("knitr")
opts_chunk$set(tidy=FALSE,
            fig.width=5,fig.height=5,
            message=FALSE)

## ----style-knitr, eval=TRUE, echo=FALSE, results="asis"--------------------
BiocStyle::latex()

## ----package-select,message=FALSE------------------------------------------
library(isomiRs)
data(mirData)
head(isoSelect(mirData, mirna="hsa-let-7a-5p", 1000))

## ----package-load,message=FALSE--------------------------------------------
library(isomiRs)
data(mirData)

## ----package-plot-iso,message=FALSE,eval=FALSE-----------------------------
#  ids <- IsomirDataSeqFromFiles(fn_list, design=de)

## ----package-plot-iso-t5,message=FALSE-------------------------------------
ids <- isoCounts(mirData)
isoPlot(ids, type="iso5", column = "group")

## ----package-count,message=FALSE-------------------------------------------
head(counts(ids))

## ----package-norm,message=FALSE--------------------------------------------
library(pheatmap)
ids = isoNorm(ids, formula = ~ group)
pheatmap(counts(ids, norm=TRUE)[1:100,], 
         annotation_col = data.frame(colData(ids)[,1,drop=FALSE]),
         show_rownames = FALSE, scale="row")

## ----package-de,message=FALSE----------------------------------------------
dds <- isoDE(ids, formula=~group)
library(DESeq2)
plotMA(dds)
head(results(dds, format="DataFrame"))

## ----package-de-iso5,message=FALSE-----------------------------------------
dds = isoDE(ids, formula=~group, ref=TRUE, iso5=TRUE)
head(results(dds, tidy=TRUE))

## ----package-de-with-deseq2------------------------------------------------
dds = DESeqDataSetFromMatrix(counts(ids),
                             colData(ids), design = ~ group)

## ----package-pls,eval=TRUE-------------------------------------------------
ids = isoCounts(ids, iso5=TRUE, minc=10, mins=6)
ids = isoNorm(ids, formula = ~ group)
pls.ids = isoPLSDA(ids, "group", nperm = 2)
df = isoPLSDAplot(pls.ids)

## ----package-plsplot,message=FALSE,eval=FALSE------------------------------
#  pls.ids = isoPLSDA(ids,"group", refinment = FALSE, vip = 0.8)

## ----sessionInfo,results='asis',echo=FALSE---------------------------------
toLatex(sessionInfo())

