## About `ideal`

`ideal` is a Bioconductor package containing a Shiny application for interactively analyzing RNA-seq expression data, by interactive exploration of the results of a Differential Expression analysis.

Thanks to its interactive/reactive design, it is designed to become a practical companion to any RNA-seq dataset analysis, making downstream and exploratory data analysis accessible also to the bench biologist, while providing additional quick insight also for the experienced data analyst.

`ideal` was developed by Federico Marini in the Bioinformatics Division led by Harald Binder at the IMBEI (Institut für Medizinische Biometrie, Epidemiologie und Informatik) in the University Medical Center of the Johannes Gutenberg University Mainz.


## Developers

<a href="mailto:marinif@uni-mainz.de?subject=[pcaExplorer question]" class="btn btn-primary">Federico Marini</a>

## Code

All code for `ideal` is available on 
<a href="https://github.com/federicomarini/ideal" target="_blank">GitHub</a>.


## Citation info

If you use `ideal` for your analysis, please cite it as here below:

```r
citation("ideal")
```

```
## 
## To cite package 'ideal' in publications use:
## 
##   Federico Marini (2017). ideal: Interactive Differential
##   Expression AnaLysis. R package version 0.6.2.
##   https://github.com/federicomarini/ideal
## 
## A BibTeX entry for LaTeX users is
## 
##   @Manual{,
##     title = {ideal: Interactive Differential Expression AnaLysis},
##     author = {Federico Marini},
##     year = {2017},
##     note = {R package version 0.6.2},
##     url = {https://github.com/federicomarini/ideal},
##   }
```

<hr/>

## Session Info
