## ----style, echo=FALSE, results="asis", message=FALSE--------------------
knitr::opts_chunk$set(tidy = FALSE,
                      warning = FALSE,
                      message = FALSE)

## ----library, echo=FALSE, results='hide', message=FALSE------------------
require(minfi)

## ------------------------------------------------------------------------
    require(funtooNorm)
    require(minfiData)
    # We randomly assign cell types for the purpose of this example.
    pData(RGsetEx)$cell_type <- rep(c("type1","type2"),3)
    mySampleSet=fromRGChannelSet(RGsetEx)

## ------------------------------------------------------------------------
    origBeta <- getRawBeta(mySampleSet)
    origBeta[1:3,1:3]

## ------------------------------------------------------------------------
    plotValidationGraph(mySampleSet, type.fits="PCR")

## ----normalize data------------------------------------------------------
    mySampleSet=funtooNorm(mySampleSet,type.fits="PCR",ncmp=3)
    mySampleSet
    normBeta <- getNormBeta(mySampleSet)
    normBeta[1:3,1:3]

## ------------------------------------------------------------------------
    #technical replicates are fictional, just for demonstration purposes.
    agreement(origBeta, c(1:5,5)) # M for data before the normalization
    agreement(normBeta, c(1:5,5)) # M for data after normalization

## ------------------------------------------------------------------------
library(minfi)

    age=pData(RGsetEx)$age
    dmp=dmpFinder(getNormM(mySampleSet), age, type="continuous")
    dmp[1:2,]

## ------------------------------------------------------------------------

phenoData <- pData(RGsetEx)[,c("age","sex","status")]
genomerange <- getGRanges(mySampleSet)
grs <- GenomicRatioSet(gr=genomerange,
                       Beta=normBeta,
                       preprocessMethod="funtooNorm",
                       metadata=list(pData=phenoData))
grs

## ----echo=FALSE----------------------------------------------------------
sessionInfo()

