## ----style, echo=FALSE, results="asis", message=FALSE----------------------
BiocStyle::markdown()
knitr::opts_chunk$set(tidy = FALSE,
                      warning = FALSE,
                      message = FALSE)

## ----echo=FALSE, results='hide', message=FALSE-----------------------------
library(dSimer)

## ---- eval=FALSE-----------------------------------------------------------
#  library(dSimer)
#  help("dSimer")

## --------------------------------------------------------------------------
data(d2s_hsdn) #get disease-symptom associations for constructing feature vectors
ds <- sample(unique(d2s_hsdn[,2]), 5) #get disease names sample
simmat <- CosineDFV(ds, ds, d2s_hsdn)
simmat

## --------------------------------------------------------------------------
data(d2g_separation) #get disease-gene associations
ds<-sample(names(d2g_separation),5)
ds
sim<-BOG(ds,ds,d2g_separation)
Normalize(sim) #normalize BOG sim scores

## --------------------------------------------------------------------------
options(stringsAsFactors = FALSE) #this may be neccessary
 
d2g_fundo_sample<-read.table(text = "DOID:5218    IL6
DOID:8649  EGFR
DOID:8649	PTGS2
DOID:8649	VHL
DOID:8649	ERBB2
DOID:8649	PDCD1
DOID:8649	KLRC1
DOID:5214	MPZ
DOID:5214	EGR2
DOID:5210	AMH")

d2g_fundo_list<-x2y_df2list(d2g_fundo_sample)
d2g_fundo_list

## --------------------------------------------------------------------------
m<-matrix(1:9,3,3)
m
Normalize(m)

## --------------------------------------------------------------------------
## get the data 
data(go2g_sample)
data(d2go_sample)

ds<-names(d2go_sample)
sim<-PSB(ds,ds,d2go_sample,go2g_sample)
sim
Normalize(sim)

## --------------------------------------------------------------------------
## in this method, we must use disease-gene associations 
## which genes are represented by entrez ids because of
## HumanNet
data(d2g_fundo_entrezid) ##get disease-gene associations
data(HumanNet_sample)
## we specified 5 DOIDs to match Human_sample
ds<-c("DOID:8176","DOID:2394","DOID:3744","DOID:8466","DOID:5679")
llsnlist<-LLSn2List(HumanNet_sample)
FunSim(ds,ds,d2g_fundo_entrezid,llsnlist)

## --------------------------------------------------------------------------
## get disease-gene associations and HPRD PPI data
data(d2g_fundo_symbol)
data(PPI_HPRD)

graph_hprd<-graph.data.frame(PPI_HPRD,directed=FALSE) #get a igraph object based on HPRD PPI data

ds<-sample(names(d2g_fundo_symbol),5)
ICod(ds,ds,d2g_fundo_symbol,graph_hprd)

## --------------------------------------------------------------------------
data(d2g_separation) ## get disease-gene associations

ds<-sample(names(d2g_separation),5)
Sun_annotation(ds,ds,d2g_separation)

## --------------------------------------------------------------------------
## get a sample of disease-GO associations
data(d2go_sample)
ds<-names(d2go_sample)
Sun_function(ds,ds,d2go_sample)

## --------------------------------------------------------------------------
data(d2g_fundo_symbol)
data(graphlet_sig_hprd) #get graphlet signatures of genes in HPRD PPI network
data(weight)
ds<-sample(names(d2g_fundo_symbol),5)
Sun_topology(ds,ds,d2g_fundo_symbol,graphlet_sig_hprd,weight)

## --------------------------------------------------------------------------
## get the disease-gene association data and interactome data
data(d2g_separation)
data(interactome)

## import ppi data to R by igraph
graph_interactome<-graph.data.frame(interactome,directed=FALSE)

## calculate separation of 5 sample diseases
ds<-sample(names(d2g_separation),5)
sep<-Separation(ds,ds,d2g_separation,graph_interactome)

## convert separation into simialrity
sim<-Separation2Similarity(sep)
sim

## --------------------------------------------------------------------------
data(d2g_fundo_symbol)
d2g_sample<-d2g_fundo_symbol[1:10]
plot_bipartite(d2g_sample)

## --------------------------------------------------------------------------
data("PPI_HPRD")
g<-graph.data.frame(PPI_HPRD,directed = FALSE) #get an igraph graph

data(d2g_fundo_symbol)
a<-d2g_fundo_symbol[["DOID:8242"]] # get gene set a
b<-d2g_fundo_symbol[["DOID:4914"]] # get gene set b

plot_topo(a,b,g)

## --------------------------------------------------------------------------
data(d2g_separation)
data(interactome)

graph_interactome<-graph.data.frame(interactome,directed=FALSE)
ds<-c("myocardial ischemia","myocardial infarction","coronary artery disease",
 "cerebrovascular disorders","arthritis, rheumatoid","diabetes mellitus, type 1",
 "autoimmune diseases of the nervous system","demyelinating autoimmune diseases, cns",
 "respiratory hypersensitivity","asthma","retinitis pigmentosa",
 "retinal degeneration","macular degeneration")
 
sep<-Separation(ds,ds,d2g_separation,graph_interactome)
sim<-Separation2Similarity(sep)
plot_heatmap(sim,font.size = 3)
plot_net(sim,cutoff=0.2)

