/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.reader;

import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class mxGraphViewReader
extends DefaultHandler {
    protected mxICanvas canvas;
    protected double scale = 1.0;
    protected boolean htmlLabels = false;

    public void setHtmlLabels(boolean bl) {
        this.htmlLabels = bl;
    }

    public boolean isHtmlLabels() {
        return this.htmlLabels;
    }

    public abstract mxICanvas createCanvas(Map<String, Object> var1);

    public mxICanvas getCanvas() {
        return this.canvas;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string3.toUpperCase();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string5 = attributes.getLocalName(i);
            if (string5 == null) {
                string5 = attributes.getQName(i);
            }
            hashtable.put(string5, attributes.getValue(i));
        }
        this.parseElement(string4, hashtable);
    }

    public void parseElement(String string, Map<String, Object> map) {
        if (this.canvas == null && string.equalsIgnoreCase("GRAPH")) {
            this.scale = mxUtils.getDouble(map, "scale", 1.0);
            this.canvas = this.createCanvas(map);
            if (this.canvas != null) {
                this.canvas.setScale(this.scale);
            }
        } else if (this.canvas != null) {
            boolean bl = false;
            if (string.equalsIgnoreCase("VERTEX") || string.equalsIgnoreCase("GROUP")) {
                this.drawVertex(map);
                bl = true;
            } else if (string.equalsIgnoreCase("EDGE")) {
                this.drawEdge(map);
                bl = true;
            }
            if (bl) {
                this.drawLabel(string.equalsIgnoreCase("EDGE"), map);
            }
        }
    }

    public void drawVertex(Map<String, Object> map) {
        int n = mxUtils.getInt(map, "width");
        int n2 = mxUtils.getInt(map, "height");
        if (n > 0 && n2 > 0) {
            int n3 = (int)Math.round(mxUtils.getDouble(map, "x"));
            int n4 = (int)Math.round(mxUtils.getDouble(map, "y"));
            this.canvas.drawVertex(n3, n4, n, n2, map);
        }
    }

    public void drawEdge(Map<String, Object> map) {
        List<mxPoint> list = mxGraphViewReader.parsePoints(mxUtils.getString(map, "points"));
        if (list.size() > 0) {
            this.canvas.drawEdge(list, map);
        }
    }

    public void drawLabel(boolean bl, Map<String, Object> map) {
        String string = mxUtils.getString(map, "label");
        if (string != null && string.length() > 0) {
            mxPoint mxPoint2 = new mxPoint(mxUtils.getDouble(map, "dx"), mxUtils.getDouble(map, "dy"));
            mxRectangle mxRectangle2 = !bl ? new mxRectangle(mxUtils.getDouble(map, "x"), mxUtils.getDouble(map, "y"), mxUtils.getDouble(map, "width"), mxUtils.getDouble(map, "height")) : null;
            mxRectangle mxRectangle3 = mxUtils.getLabelPaintBounds(string, map, mxUtils.isTrue(map, "html", false), mxPoint2, mxRectangle2, this.scale);
            this.canvas.drawLabel(string, (int)Math.round(mxRectangle3.getX()), (int)Math.round(mxRectangle3.getY()), (int)Math.round(mxRectangle3.getWidth()), (int)Math.round(mxRectangle3.getHeight()), map, this.isHtmlLabels());
        }
    }

    public static List<mxPoint> parsePoints(String string) {
        ArrayList<mxPoint> arrayList = new ArrayList<mxPoint>();
        if (string != null) {
            int n = string.length();
            String string2 = "";
            String string3 = null;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == ',' || c == ' ') {
                    if (string3 == null) {
                        string3 = string2;
                    } else {
                        arrayList.add(new mxPoint(Double.parseDouble(string3), Double.parseDouble(string2)));
                        string3 = null;
                    }
                    string2 = "";
                    continue;
                }
                string2 = string2 + c;
            }
            arrayList.add(new mxPoint(Double.parseDouble(string3), Double.parseDouble(string2)));
        }
        return arrayList;
    }
}

