## ----echo=FALSE----------------------------------------------------------
knitr::opts_chunk$set(collapse = FALSE,comment = "#>")

## ----eval=TRUE, message=FALSE, warning=FALSE, results='hide'-------------
library(PathwaySplice)

## ----eval=FALSE, message=FALSE, warning=FALSE, results='hide'------------
#  library(devtools)
#  install_github("SCCC-BBC/PathwaySplice",ref = 'development')

## ----eval=TRUE, warning=FALSE, message=FALSE, results='markup'-----------
data(featureBasedData)
head (featureBasedData)

## ----eval=TRUE, message=FALSE, warning=FALSE, results='markup'-----------
gene.based.table <- makeGeneTable(featureBasedData)
head(gene.based.table)

## ----eval=TRUE, warning=FALSE, message=FALSE, results='markup', fig.height=5, fig.width=5----
lrTestBias(gene.based.table,boxplot.width=0.3)

## ----eval=TRUE,warning=FALSE,message=FALSE,results='markup'--------------
result.adjusted <- runPathwaySplice(gene.based.table,genome='hg19',
                        id='ensGene',
                        test.cats=c('GO:BP'),
                        go.size.limit=c(5,30),method='Wallenius')
head(result.adjusted)

## ----eval=TRUE, message=FALSE, warning=FALSE,results='hide',fig.show='hide'----
dir.name <- system.file('extdata', package='PathwaySplice')
hallmark.local.pathways <- file.path(dir.name,'h.all.v6.0.symbols.gmt.txt')
hlp <- gmtGene2Cat(hallmark.local.pathways, genomeID='hg19')
result.hallmark <- runPathwaySplice(gene.based.table,genome='hg19',id='ensGene',
                gene2cat=hlp, go.size.limit=c(5,200), method='Wallenius', binsize=20)

## ----eval=TRUE, message=FALSE, warning=FALSE-----------------------------
head(result.hallmark)

## ----eval=TRUE, warning=FALSE,message=FALSE,results ='markup', fig.align='center', fig.height=6, fig.width=6----
output.file.dir <- file.path("~/PathwaySplice_output")
enmap <- enrichmentMap(result.adjusted,n=5,
                       output.file.dir=output.file.dir,
                       similarity.threshold=0.3, scaling.factor = 2)

