## ---- echo=FALSE, warning=FALSE--------------------------------------------
suppressPackageStartupMessages({
    library(MultiAssayExperiment)
    library(S4Vectors)
    })

## --------------------------------------------------------------------------
data(miniACC)
miniACC

## --------------------------------------------------------------------------
colData(miniACC)[1:4, 1:4]
table(miniACC$race)

## --------------------------------------------------------------------------
experiments(miniACC)

## --------------------------------------------------------------------------
sampleMap(miniACC)

## --------------------------------------------------------------------------
metadata(miniACC)

## ---- results='hide'-------------------------------------------------------
miniACC[c("MAPK14", "IGFBP2"), , ]

## ---- results='hide'-------------------------------------------------------
miniACC[, miniACC$pathologic_stage == "stage iv", ]

## ---- results='hide'-------------------------------------------------------
miniACC[, , "RNASeq2GeneNorm"]

## --------------------------------------------------------------------------
miniACC[[1L]]  #or equivalently, miniACC[["RNASeq2GeneNorm"]]

## --------------------------------------------------------------------------
summary(complete.cases(miniACC))

## --------------------------------------------------------------------------
accmatched = intersectColumns(miniACC)

## --------------------------------------------------------------------------
colnames(accmatched)

## --------------------------------------------------------------------------
accmatched2 <- intersectRows(miniACC[, , c("RNASeq2GeneNorm",
                                           "gistict",
                                           "Mutations")])
rownames(accmatched2)

## --------------------------------------------------------------------------
class(assay(miniACC))

## --------------------------------------------------------------------------
assays(miniACC)

## --------------------------------------------------------------------------
longFormat(miniACC[c("TP53", "CTNNB1"), , ], 
           colDataCols = c("vital_status", "days_to_death"))

## --------------------------------------------------------------------------
wideFormat(miniACC[c("TP53", "CTNNB1"), , ], 
           colDataCols = c("vital_status", "days_to_death"))

## --------------------------------------------------------------------------
MultiAssayExperiment(experiments=experiments(miniACC),
                     colData=colData(miniACC),
                     sampleMap=sampleMap(miniACC),
                     metadata=metadata(miniACC))

## --------------------------------------------------------------------------
miniACC2 <- c(miniACC, log2rnaseq = log2(assays(miniACC)$RNASeq2GeneNorm), mapFrom=1L)
assays(miniACC2)

## --------------------------------------------------------------------------
upsetSamples(miniACC)

## --------------------------------------------------------------------------
suppressPackageStartupMessages({
  library(survival)
  library(survminer)
})
miniACC$y <- Surv(miniACC$days_to_death, miniACC$vital_status)

## --------------------------------------------------------------------------
miniACC <- miniACC[, complete.cases(miniACC$y), ]

## --------------------------------------------------------------------------
fit <- survfit(y ~ pathology_N_stage, data = colData(miniACC))
ggsurvplot(fit, data = colData(miniACC), risk.table = TRUE)

## --------------------------------------------------------------------------
wideacc <- wideFormat(miniACC["EZH2", , ], 
    colDataCols = c("vital_status", "days_to_death", "pathology_N_stage"))
wideacc$y <- Surv(wideacc$days_to_death, wideacc$vital_status)
head(wideacc)

## --------------------------------------------------------------------------
coxph(Surv(days_to_death, vital_status) ~ gistict_EZH2 +
          log2(RNASeq2GeneNorm_EZH2) + pathology_N_stage,  data=wideacc)

## --------------------------------------------------------------------------
sessionInfo()

