## ----knitr, echo=FALSE, results="hide"-----------------------------------
library("knitr")
opts_chunk$set(tidy=FALSE,tidy.opts=list(width.cutoff=30),dev="png",fig.show="hide",
               fig.width=4,fig.height=7,
               message=FALSE)

## ----style, eval=TRUE, echo=FALSE, results="asis"--------------------------
BiocStyle::latex()

## ----options, results="hide", echo=FALSE--------------------------------------
options(digits=3, width=80, prompt=" ", continue=" ")

## ----install_logolas_bio, eval=FALSE------------------------------------------
#  source("http://bioconductor.org/biocLite.R")
#  biocLite("Logolas")

## ----install_logolas_github, eval=FALSE---------------------------------------
#  devtools::install_github('kkdey/Logolas')

## ----load_logolas, cache=FALSE, eval=TRUE,warning=FALSE-----------------------
library(Logolas)

## ----seqlogo_use, eval=TRUE, warning=FALSE, fig.show="asis", dpi=144, fig.width=5, fig.height=5, out.width="5in", out.height="5in"----
mFile <- system.file("Exfiles/pwm1", package="seqLogo")
m <- read.table(mFile)
p <- seqLogo::makePWM(m)
seqLogo::seqLogo(p)

## ----logolas_use_0, eval=TRUE, warning=FALSE, fig.show="asis", dpi=144, fig.width=6, fig.height=5, out.width="6in", out.height="5in"----
color_profile <- list("type" = "per_row",
                      "col" = RColorBrewer::brewer.pal(dim(p@pwm)[1],name ="Spectral"))
logomaker(p@pwm,
          color_profile = color_profile,
          frame_width = 1,
          ic.scale = TRUE,
          yscale_change=FALSE,
          xlab="position",
          col_line_split = "grey80")


## ----logolas_use, eval=TRUE, warning=FALSE, fig.show="asis", dpi=144, fig.width=6, fig.height=5, out.width="6in", out.height="5in"----

rownames(m) <- c("A", "C", "G", "T")
colnames(m) <- 1:8
logomaker(m,
          color_profile = color_profile,
          frame_width = 1,
          ic.scale = TRUE,
          yscale_change=FALSE,
          xlab="position",
          col_line_split = "grey80")


## ----ic_computer, eval=TRUE---------------------------------------------------
ic_computer(m, alpha=3)

## ----logolas_use_2, eval=TRUE, warning=FALSE, fig.show="asis", dpi=144, fig.width=6, fig.height=5, out.width="6in", out.height="5in"----
rownames(m) <- c("A", "C", "G", "T")
colnames(m) <- 1:8
logomaker(m,
          color_profile = color_profile,
          frame_width = 1,
          ic.scale = TRUE,
          alpha = 2,
          yscale_change=TRUE,
          xlab="position",
          col_line_split = "grey80")


## ----logolas_use_3, eval=TRUE, warning=FALSE, fig.show="asis", dpi=144, fig.width=6, fig.height=5, out.width="6in", out.height="5in"----
rownames(m) <- c("A", "C", "G", "T")
colnames(m) <- 1:8
logomaker(m,
          color_profile = color_profile,
          frame_width = 1,
          ic.scale = FALSE,
          alpha = 2,
          xlab="position",
          col_line_split = "grey80",
          ylab = "Probability")


## ----logolas_use_4, eval=TRUE, warning=FALSE, fig.show="asis", dpi=144, fig.width=6, fig.height=5, out.width="6in", out.height="5in"----

counts_mat <- rbind(c(0, 0, 100, 1, 2), c(4, 3, 30, 35, 2),
                    c(100, 0, 10, 2, 7),rep(0,5),
                    c(4, 2, 3, 7, 70), c(1, 8, 0, 60, 3),
                    rep(0, 5), c(4, 2, 100, 1, 1),
                    c(12, 8, 16, 7, 20), c(55, 0, 1, 0, 12),
                    rep(0,5), c(rep(0,3), 20, 0),
                    rep(0,5), c(0, 0, 30, 0, 22),
                    c(1, 0, 12, 3, 10), rep(0,5),
                    c(0, 1, 0, 34, 1), c(0, 1, 12, 35, 1),
                    c(0, 30, 1, 10, 2), c(0, 1, 4, 100, 2))

## ----logolas_use_5, eval=TRUE, warning=FALSE, fig.show="asis", dpi=144, fig.width=6, fig.height=5, out.width="6in", out.height="5in"----

rownames(counts_mat) <- c("A", "R", "N", "D","C", "E", "Q", "G",
                          "H", "I", "L", "K", "M", "F", "P", "S",
                          "T", "W", "Y", "V")

colnames(counts_mat) <- c("Pos 1", "Pos 2", "Pos 3", "Pos 4", "Pos 5")

cols1 <- c(rev(RColorBrewer::brewer.pal(12, "Paired"))[c(3,4,7,8,11,12,5,6,9,10)],
           RColorBrewer::brewer.pal(12, "Set3")[c(1,2,5,8,9)],
           RColorBrewer::brewer.pal(9, "Set1")[c(9,7)],
           RColorBrewer::brewer.pal(8, "Dark2")[c(3,4,8)])

color_profile <- list("type" = "per_row",
                      "col" = cols1)

logomaker(counts_mat,
          color_profile = color_profile,
          frame_width = 1,
          ic.scale  = FALSE,
          yscale_change = FALSE)


## ----logolas_use_6, eval=TRUE, warning=FALSE, fig.show="asis", dpi=144, fig.width=6, fig.height=5, out.width="6in", out.height="5in"----
mFile <- system.file("Exfiles/pwm1", package="seqLogo")
m <- read.table(mFile)
p <- seqLogo::makePWM(m)
pwm_mat <- slot(p,name = "pwm")
mat1 <- cbind(pwm_mat[,c(3,4)], rep(0,4), pwm_mat[,c(5,6)]);
colnames(mat1) <- c("-2", "-1", "0", "1", "2")
mat2 <- cbind(rep(0,6), rep(0,6),
              c(0.5, 0.2, 0.2, 0.05, 0.05, 0),
              rep(0,6), rep(0,6))
rownames(mat2) <- c("C>T", "C>A", "C>G",
                    "T>A", "T>C", "T>G")

table <- rbind(mat1, mat2)

## ----logolas_use_7_0, eval=TRUE, warning=FALSE, fig.show="asis", dpi=144, fig.width=6, fig.height=5, out.width="6in", out.height="5in"----

color_profile <- list("type" = "per_row",
                      "col" = RColorBrewer::brewer.pal(dim(table)[1],name ="Spectral"))

logomaker(table,
          color_profile = color_profile,
          frame_width = 1,
          ic.scale = TRUE,
          yscale_change=TRUE,
          xlab = "Position",
          ylab = "Information content")


## ----logolas_use_7, eval=TRUE, warning=FALSE, fig.show="asis", dpi=144, fig.width=6, fig.height=5, out.width="6in", out.height="5in"----

cols = RColorBrewer::brewer.pal.info[RColorBrewer::brewer.pal.info$category == 'qual',]
col_vector = unlist(mapply(RColorBrewer::brewer.pal, cols$maxcolors, rownames(cols)))

total_chars = c("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O",
            "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "zero", "one", "two",
            "three", "four", "five", "six", "seven", "eight", "nine", "dot", "comma",
            "dash", "colon", "semicolon", "leftarrow", "rightarrow")

set.seed(20)
color_profile <- list("type" = "per_symbol",
                      "col" = sample(col_vector, length(total_chars), replace=FALSE))

logomaker(table,
          color_profile = color_profile,
          total_chars = total_chars,
          frame_width = 1,
          ic.scale = TRUE,
          yscale_change=TRUE,
          xlab = "Position",
          ylab = "Information content")


## ----logolas_use_10, eval=TRUE, warning=FALSE, fig.show="asis", dpi=144, fig.width=8, fig.height=5, out.width="8in", out.height="5in"----

set.seed(20)
data("himalayan_fauna_3_clusters")

color_profile <- list("type" = "per_column",
                      "col" = sample(RColorBrewer::brewer.pal(10,name = "Spectral"),
                       dim(himalayan_fauna_3_clusters)[2], replace=TRUE))
logomaker(himalayan_fauna_3_clusters,
          color_profile = color_profile,
          frame_width = 1,
          ic.scale = TRUE,
          alpha=200,
          pop_name = "Bird family abundance across clusters",
          xlab = "Clusters",
          ylab = "Information content")


## ----logolas_use_8, eval=TRUE, warning=FALSE, fig.show="asis", dpi=144, fig.width=4, fig.height=4, out.width="4in", out.height="4in"----

mat <- rbind(c(326, 296, 81, 245, 71),
             c(258, 228, 55, 273, 90),
             c(145, 121, 29, 253, 85),
             c(60, 52, 23, 180, 53),
             c(150, 191, 63, 178, 63))

rownames(mat) <- c("H3K4ME1", "H3K4ME2", "H3K4ME3", "H3AC", "H4AC")
colnames(mat) <- c("Intergenic","Intron","Exon \n 1000 KB window",
                   "Gene start \n 1000 KB window","Gene end \n 1000 KB window")


## ----logolas_use_9, eval=TRUE, warning=FALSE, fig.show="asis", dpi=144, fig.width=6.5, fig.height=4, out.width="6.5in", out.height="4in"----

color_profile <- list("type" = "per_row",
                      "col" = sample(RColorBrewer::brewer.pal(10,name = "Spectral"),
                          dim(mat)[1]))


logomaker(mat,
          color_profile = color_profile,
          frame_width = 1,
          ic.scale = TRUE,
          pop_name = "Histone marks in various genomic regions",
          xlab = "",
          ylab = "Information content",
          yscale_change = TRUE,
          col_line_split = "black")


## ----logolas_use_11, eval=TRUE, warning=FALSE, fig.show="asis", dpi=144, fig.width=8, fig.height=5, out.width="8in", out.height="5in"----

rec1 <- aRxiv::arxiv_search('au:"Matthew Stephens"', limit=50)
rec2 <- aRxiv::arxiv_search('au:"John Lafferty"', limit=50)
rec3 <- aRxiv::arxiv_search('au:"Wei Biao Wu"', limit=50)
rec4 <- aRxiv::arxiv_search('au:"Peter Mccullagh"', limit=50)

primary_categories_1 <- toupper(rec1$primary_category)
primary_categories_2 <- toupper(rec2$primary_category)
primary_categories_3 <- toupper(rec3$primary_category)
primary_categories_4 <- toupper(rec4$primary_category)

factor_levels <- unique(c(unique(primary_categories_1),
                   unique(primary_categories_2),
                   unique(primary_categories_3),
                   unique(primary_categories_4)))

primary_categories_1 <- factor(primary_categories_1, levels=factor_levels)
primary_categories_2 <- factor(primary_categories_2, levels=factor_levels)
primary_categories_3 <- factor(primary_categories_3, levels=factor_levels)
primary_categories_4 <- factor(primary_categories_4, levels=factor_levels)


tab_data <- cbind(table(primary_categories_1),
                  table(primary_categories_2),
                  table(primary_categories_3),
                  table(primary_categories_4))

colnames(tab_data) <- c("Matthew Stephens",
                        "John Lafferty",
                        "Wei Biao Wu",
                        "Peter McCullagh")

tab_data <- as.matrix(tab_data)

## ----logolas_use_12, eval=TRUE, warning=FALSE, fig.show="asis", dpi=144, fig.width=7, fig.height=5, out.width="7in", out.height="5in"----

color_profile <- list("type" = "per_row",
                      "col" = RColorBrewer::brewer.pal(dim(tab_data)[1],
          name = "Spectral"))

logomaker(tab_data,
          color_profile = color_profile,
          frame_width = 1,
          ic.scale = TRUE,
          pop_name = "arXiv field categories of UChicago STAT professors",
          xlab = "Professors",
          ylab = "Information content")


## ----logolas_use_13, eval=TRUE, warning=FALSE, fig.show="asis", dpi=144, fig.width=8, fig.height=5, out.width="8in", out.height="5in"----

LAMBDAletter <- function(colfill="green"){

  x <- c(0.15, 0.5, 0.85, 0.75, 0.5, 0.25)
  y <- c(0, 1, 0, 0, 0.8, 0)

  fill <- colfill
  id <- rep(1, length(x))

  ll <- list("x"= x,
             "y"= y,
             "id" = id,
             "fill" = fill)
  return(ll)
}


## ----logolas_use_14, eval=TRUE, warning=FALSE, fig.show="asis", dpi=144, fig.width=4, fig.height=4, out.width="4in", out.height="4in"----

lambda <- LAMBDAletter()
grid::grid.newpage()
grid::pushViewport(grid::viewport(x=0.5,y=0.5,width=1, height=1,
                                  clip=TRUE))
grid::grid.polygon(lambda$x, lambda$y,
                     default.unit="native",
                     id=lambda$id,
                     gp=grid::gpar(fill=lambda$fill,
                                   lwd=10))


## ----logolas_use_16, eval=TRUE, warning=FALSE, fig.show="asis", dpi=144, fig.width=8, fig.height=5, out.width="8in", out.height="5in"----

counts_mat <- rbind(c(0, 10, 100, 60, 20),
                    c(40, 30, 30, 35, 20),
                    c(100, 0, 15, 25, 75),
                    c(10, 30, 20, 50, 70)
)

colnames(counts_mat) <- c("Pos 1", "Pos 2", "Pos 3", "Pos 4", "Pos 5")
rownames(counts_mat) <- c("R/LMBD/Q", "A", "X", "Y")

## ----logolas_use_17, eval=TRUE, warning=FALSE, fig.show="asis", dpi=144, fig.width=8, fig.height=5, out.width="8in", out.height="5in"----

color_profile <- list("type" = "per_row",
                      "col" = RColorBrewer::brewer.pal(dim(counts_mat)[1], name = "Spectral"))

logomaker(counts_mat,
          color_profile = color_profile,
          frame_width = 1,
          addlogos="LMBD",
          addlogos_text="LAMBDA")


## ----session_info, eval=TRUE--------------------------------------------------
sessionInfo()

