/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class And
extends AbstractFunction {
    public And() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.OPT_BOOLS, "truth_values", "Zero or more truth values or lists of truth values.")});
    }

    public String getName() {
        return "AND";
    }

    public String getFunctionSummary() {
        return "Returns the logical conjunction of any number of boolean values.";
    }

    public Class getReturnType() {
        return Boolean.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        boolean[] booleans;
        try {
            booleans = FunctionUtil.getBooleans(args);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert an argument or a list element to a boolean in a call to OR()!");
        }
        for (boolean b : booleans) {
            if (b) continue;
            return false;
        }
        return true;
    }
}

