/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssbind;

import org.biojava.bio.program.ssbind.HSPStAXHandler;
import org.biojava.bio.program.ssbind.SeqSimilarityStAXAdapter;
import org.biojava.bio.program.ssbind.SeqSimilarityStAXHandler;
import org.biojava.bio.program.ssbind.StAXHandlerFactory;
import org.biojava.bio.program.xff.ElementRecognizer;
import org.biojava.bio.search.SearchContentHandler;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StAXContentHandlerBase;
import org.biojava.utils.stax.StringElementHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HitStAXHandler
extends SeqSimilarityStAXHandler {
    public static final StAXHandlerFactory HIT_HANDLER_FACTORY = new StAXHandlerFactory(){

        public StAXContentHandler getHandler(SeqSimilarityStAXAdapter ssContext) {
            return new HitStAXHandler(ssContext);
        }
    };

    HitStAXHandler(SeqSimilarityStAXAdapter ssContext) {
        super(ssContext);
        this.addHandler(new ElementRecognizer.ByNSName("http://www.biojava.org", "HitId"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(SeqSimilarityStAXAdapter ssContext) {
                return new HitIDStAXHandler();
            }
        });
        this.addHandler(new ElementRecognizer.ByNSName("http://www.biojava.org", "QueryId"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(SeqSimilarityStAXAdapter ssContext) {
                return new QueryIDStAXHandler();
            }
        });
        this.addHandler(new ElementRecognizer.ByNSName("http://www.biojava.org", "HitDescription"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(SeqSimilarityStAXAdapter ssContext) {
                return new HitDescriptionStAXHandler();
            }
        });
        this.addHandler(new ElementRecognizer.ByNSName("http://www.biojava.org", "HSPCollection"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(SeqSimilarityStAXAdapter ssContext) {
                return new HSPCollectionStAXHandler();
            }
        });
    }

    protected void handleStartElement(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
        SearchContentHandler sch = this.ssContext.getSearchContentHandler();
        sch.startHit();
        if (attrs.getValue("sequenceLength") != null) {
            sch.addHitProperty("subjectSequenceLength", attrs.getValue("sequenceLength"));
        }
    }

    protected void handleEndElement(String nsURI, String localName, String qName) throws SAXException {
        this.ssContext.getSearchContentHandler().endHit();
    }

    private class HSPCollectionStAXHandler
    extends StAXContentHandlerBase {
        private HSPCollectionStAXHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attr, DelegationManager dm) throws SAXException {
            if (localName.equals("HSP")) {
                dm.delegate(HSPStAXHandler.HSP_HANDLER_FACTORY.getHandler(HitStAXHandler.this.ssContext));
            }
        }
    }

    private class HitDescriptionStAXHandler
    extends StringElementHandlerBase {
        private HitDescriptionStAXHandler() {
        }

        protected void setStringValue(String s) {
            HitStAXHandler.this.ssContext.getSearchContentHandler().addHitProperty("subjectDescription", s);
        }
    }

    private class QueryIDStAXHandler
    extends StAXContentHandlerBase {
        private QueryIDStAXHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attr, DelegationManager dm) throws SAXException {
            HitStAXHandler.this.ssContext.getSearchContentHandler().setQueryID(attr.getValue("id"));
        }
    }

    private class HitIDStAXHandler
    extends StAXContentHandlerBase {
        private HitIDStAXHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attr, DelegationManager dm) throws SAXException {
            HitStAXHandler.this.ssContext.getSearchContentHandler().addHitProperty("subjectId", attr.getValue("id"));
        }
    }
}

