/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.gff;

import org.biojava.bio.program.gff.GFFRecord;
import org.biojava.bio.seq.StrandedFeature;

public interface GFFRecordFilter {
    public static final GFFRecordFilter ACCEPT_ALL = new AcceptAll();

    public boolean accept(GFFRecord var1);

    public static class NotFilter
    implements GFFRecordFilter {
        private GFFRecordFilter filter;

        public NotFilter() {
        }

        public NotFilter(GFFRecordFilter filter) {
            this.setFilter(filter);
        }

        public void setFilter(GFFRecordFilter filter) {
            this.filter = filter;
        }

        public GFFRecordFilter getFilter() {
            return this.filter;
        }

        public boolean accept(GFFRecord record) {
            return !this.filter.accept(record);
        }
    }

    public static class FrameFilter
    implements GFFRecordFilter {
        private int frame;

        public FrameFilter() {
        }

        public FrameFilter(int frame) {
            this.setFrame(frame);
        }

        public int getFrame() {
            return this.frame;
        }

        public void setFrame(int frame) {
            this.frame = frame;
        }

        public boolean accept(GFFRecord record) {
            return record.getFrame() == this.frame;
        }
    }

    public static class FeatureFilter
    implements GFFRecordFilter {
        private String feature;

        public FeatureFilter() {
        }

        public FeatureFilter(String feature) {
            this.setFeature(feature);
        }

        public void setFeature(String feature) {
            this.feature = feature;
        }

        public String getFeature() {
            return this.feature;
        }

        public boolean accept(GFFRecord record) {
            return record.getFeature().equals(this.feature);
        }
    }

    public static class SourceFilter
    implements GFFRecordFilter {
        private String source;

        public SourceFilter() {
        }

        public SourceFilter(String source) {
            this.setSource(source);
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public boolean accept(GFFRecord record) {
            return record.getSource().equals(this.source);
        }
    }

    public static class StrandFilter
    implements GFFRecordFilter {
        private StrandedFeature.Strand strand;

        public StrandFilter() {
        }

        public StrandFilter(StrandedFeature.Strand strand) {
            this.setStrand(strand);
        }

        public void setStrand(StrandedFeature.Strand strand) {
            this.strand = strand;
        }

        public StrandedFeature.Strand getStrand() {
            return this.strand;
        }

        public boolean accept(GFFRecord record) {
            return record.getStrand().equals(this.strand);
        }
    }

    public static class SequenceFilter
    implements GFFRecordFilter {
        private String seqName;

        public SequenceFilter() {
        }

        public SequenceFilter(String seqName) {
            this.setSeqName(seqName);
        }

        public String getSeqName() {
            return this.seqName;
        }

        public void setSeqName(String seqName) {
            this.seqName = seqName;
        }

        public boolean accept(GFFRecord record) {
            return record.getSeqName().equals(this.seqName);
        }
    }

    public static class AcceptAll
    implements GFFRecordFilter {
        public boolean accept(GFFRecord record) {
            return true;
        }
    }
}

