/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import ding.view.ObjectPositionImpl;
import giny.view.Justification;
import giny.view.ObjectPosition;
import giny.view.Position;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ObjectPlacerControl
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 3875032897986523443L;
    private ObjectPosition lp;
    private JComboBox justifyCombo;
    private JTextField xoffsetBox;
    private JTextField yoffsetBox;
    private JComboBox nodeAnchors;
    private JComboBox labelAnchors;
    private boolean ignoreEvents;

    public ObjectPlacerControl(ObjectPosition pos) {
        this.lp = pos == null ? new ObjectPositionImpl() : pos;
        this.ignoreEvents = false;
        this.setLayout(new BoxLayout(this, 1));
        JPanel anchorNames = new JPanel();
        anchorNames.setLayout(new GridLayout(2, 2));
        String[] points = Position.getNames();
        JLabel nodeAnchorLabel = new JLabel("Node Anchor Points ");
        this.nodeAnchors = new JComboBox<String>(points);
        this.nodeAnchors.addActionListener(this);
        anchorNames.add(nodeAnchorLabel);
        anchorNames.add(this.nodeAnchors);
        JLabel labelAnchorLabel = new JLabel("Object Anchor Points");
        this.labelAnchors = new JComboBox<String>(points);
        this.labelAnchors.addActionListener(this);
        anchorNames.add(labelAnchorLabel);
        anchorNames.add(this.labelAnchors);
        this.add(anchorNames);
        JPanel justifyPanel = new JPanel();
        justifyPanel.setLayout(new GridLayout(1, 2));
        JLabel justifyLabel = new JLabel("Label Justification");
        String[] justifyTypes = Justification.getNames();
        this.justifyCombo = new JComboBox<String>(justifyTypes);
        this.justifyCombo.addActionListener(this);
        justifyPanel.add(justifyLabel);
        justifyPanel.add(this.justifyCombo);
        this.add(justifyPanel);
        JPanel offsetPanel = new JPanel();
        offsetPanel.setLayout(new GridLayout(2, 2));
        JLabel xoffsetLabel = new JLabel("X Offset Value (can be negative)");
        this.xoffsetBox = new JTextField("0", 8);
        this.xoffsetBox.addActionListener(this);
        offsetPanel.add(xoffsetLabel);
        offsetPanel.add(this.xoffsetBox);
        JLabel yoffsetLabel = new JLabel("Y Offset Value (can be negative)");
        this.yoffsetBox = new JTextField("0", 8);
        this.yoffsetBox.addActionListener(this);
        offsetPanel.add(yoffsetLabel);
        offsetPanel.add(this.yoffsetBox);
        this.add(offsetPanel);
        this.applyPosition();
    }

    private void applyPosition() {
        this.ignoreEvents = true;
        Position nodeAnchor = this.lp.getTargetAnchor();
        Position labelAnchor = this.lp.getAnchor();
        if (nodeAnchor.equals((Object)Position.NONE)) {
            this.nodeAnchors.setSelectedIndex(-1);
        } else {
            this.nodeAnchors.setSelectedItem(nodeAnchor.getName());
        }
        if (labelAnchor.equals((Object)Position.NONE)) {
            this.labelAnchors.setSelectedIndex(-1);
        } else {
            this.labelAnchors.setSelectedItem(labelAnchor.getName());
        }
        this.justifyCombo.setSelectedItem(this.lp.getJustify().getName());
        this.xoffsetBox.setText(new Integer((int)this.lp.getOffsetX()).toString());
        this.yoffsetBox.setText(new Integer((int)this.lp.getOffsetY()).toString());
        this.ignoreEvents = false;
        this.repaint();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.ignoreEvents) {
            return;
        }
        Object source = e.getSource();
        boolean changed = false;
        if (source == this.nodeAnchors) {
            this.lp.setTargetAnchor(Position.parse(this.nodeAnchors.getSelectedItem().toString()));
            changed = true;
        }
        if (source == this.labelAnchors) {
            this.lp.setAnchor(Position.parse(this.labelAnchors.getSelectedItem().toString()));
            changed = true;
        }
        if (source == this.justifyCombo) {
            this.lp.setJustify(Justification.parse(this.justifyCombo.getSelectedItem().toString()));
            changed = true;
        }
        if (this.getOffset(this.xoffsetBox) != this.lp.getOffsetX() || this.getOffset(this.yoffsetBox) != this.lp.getOffsetY()) {
            this.lp.setOffsetX(this.getOffset(this.xoffsetBox));
            this.lp.setOffsetY(this.getOffset(this.yoffsetBox));
            changed = true;
        }
        if (!changed) {
            return;
        }
        this.firePropertyChange("OBJECT_POSITION_CHANGED", null, this.lp);
    }

    private double getOffset(JTextField jtf) {
        try {
            double d = Double.parseDouble(jtf.getText());
            return d;
        }
        catch (Exception ex) {
            jtf.setText("0");
            return 0.0;
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        String type = e.getPropertyName();
        if (type.equals("OBJECT_POSITION_CHANGED") && e.getNewValue() instanceof ObjectPosition) {
            this.lp = (ObjectPosition)e.getNewValue();
            this.applyPosition();
        }
    }
}

