/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.render.immed.nodeshape;

import cytoscape.render.immed.nodeshape.NodeShape;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;

abstract class AbstractNodeShape
implements NodeShape {
    private final AffineTransform at = new AffineTransform();
    private final CubicCurve2D cubic = new CubicCurve2D.Float(0.0f, 0.0f, 0.3f, 0.3f, 0.7f, 0.7f, 1.0f, 1.0f);
    private final QuadCurve2D quad = new QuadCurve2D.Float(0.0f, 0.0f, 0.5f, 0.5f, 1.0f, 1.0f);
    private final byte type;

    AbstractNodeShape(byte type) {
        this.type = type;
    }

    public byte getType() {
        return this.type;
    }

    public boolean computeEdgeIntersection(float xMin, float yMin, float xMax, float yMax, float ptX, float ptY, float[] returnVal) {
        float centerX = (xMax + xMin) / 2.0f;
        float centerY = (yMax + yMin) / 2.0f;
        Shape shape = this.getShape(xMin, yMin, xMax, yMax);
        PathIterator pi = shape.getPathIterator(this.at);
        float[] coords = new float[6];
        float[] pt1 = new float[2];
        float[] pt2 = new float[2];
        float[] orig = new float[2];
        float[] intersection = new float[2];
        while (!pi.isDone()) {
            int segment = pi.currentSegment(coords);
            switch (segment) {
                case 0: {
                    orig[0] = coords[0];
                    orig[1] = coords[1];
                    pt1[0] = coords[0];
                    pt1[1] = coords[1];
                    break;
                }
                case 1: {
                    pt2[0] = coords[0];
                    pt2[1] = coords[1];
                    if (AbstractNodeShape.segmentIntersection(intersection, centerX, centerY, ptX, ptY, pt1[0], pt1[1], pt2[0], pt2[1])) {
                        returnVal[0] = intersection[0];
                        returnVal[1] = intersection[1];
                        return true;
                    }
                    pt1[0] = pt2[0];
                    pt1[1] = pt2[1];
                    break;
                }
                case 2: {
                    pt2[0] = coords[2];
                    pt2[1] = coords[3];
                    this.quad.setCurve(pt1[0], pt1[1], coords[0], coords[1], coords[2], coords[3]);
                    if (this.curveIntersection(intersection, centerX, centerY, ptX, ptY, this.quad)) {
                        returnVal[0] = intersection[0];
                        returnVal[1] = intersection[1];
                        return true;
                    }
                    pt1[0] = pt2[0];
                    pt1[1] = pt2[1];
                    break;
                }
                case 3: {
                    pt2[0] = coords[4];
                    pt2[1] = coords[5];
                    this.cubic.setCurve(pt1[0], pt1[1], coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    if (this.curveIntersection(intersection, centerX, centerY, ptX, ptY, this.cubic)) {
                        returnVal[0] = intersection[0];
                        returnVal[1] = intersection[1];
                        return true;
                    }
                    pt1[0] = pt2[0];
                    pt1[1] = pt2[1];
                    break;
                }
                case 4: {
                    pt2[0] = orig[0];
                    pt2[1] = orig[1];
                    if (!AbstractNodeShape.segmentIntersection(intersection, centerX, centerY, ptX, ptY, pt1[0], pt1[1], pt2[0], pt2[1])) break;
                    returnVal[0] = intersection[0];
                    returnVal[1] = intersection[1];
                    return true;
                }
            }
            pi.next();
        }
        return false;
    }

    public static boolean segmentIntersection(float[] returnVal, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        float temp;
        boolean s1reverse = false;
        if (y2 > y1) {
            s1reverse = !s1reverse;
            temp = x1;
            x1 = x2;
            x2 = temp;
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        if (y4 > y3) {
            temp = x3;
            x3 = x4;
            x4 = temp;
            temp = y3;
            y3 = y4;
            y4 = temp;
        }
        float yMax = Math.min(y1, y3);
        float yMin = Math.max(y2, y4);
        if (yMin > yMax) {
            return false;
        }
        if (y1 > yMax) {
            x1 += (x2 - x1) * (yMax - y1) / (y2 - y1);
            y1 = yMax;
        }
        if (y3 > yMax) {
            x3 += (x4 - x3) * (yMax - y3) / (y4 - y3);
            y3 = yMax;
        }
        if (y2 < yMin) {
            x2 = x1 + (x2 - x1) * (yMin - y1) / (y2 - y1);
            y2 = yMin;
        }
        if (y4 < yMin) {
            x4 = x3 + (x4 - x3) * (yMin - y3) / (y4 - y3);
            y4 = yMin;
        }
        if (yMin == yMax) {
            float xMax;
            float xMin;
            float temp2;
            if (x2 < x1) {
                s1reverse = !s1reverse;
                temp2 = x1;
                x1 = x2;
                x2 = temp2;
                temp2 = y1;
                y1 = y2;
                y2 = temp2;
            }
            if (x4 < x3) {
                temp2 = x3;
                x3 = x4;
                x4 = temp2;
                temp2 = y3;
                y3 = y4;
                y4 = temp2;
            }
            if ((xMin = Math.max(x1, x3)) > (xMax = Math.min(x2, x4))) {
                return false;
            }
            returnVal[0] = s1reverse ? Math.max(xMin, xMax) : Math.min(xMin, xMax);
            returnVal[1] = yMin;
            return true;
        }
        if (x1 < x3 && x2 < x4 || x3 < x1 && x4 < x2) {
            return false;
        }
        if (x1 == x3 && x2 == x4) {
            if (s1reverse) {
                returnVal[0] = x2;
                returnVal[1] = y2;
            } else {
                returnVal[0] = x1;
                returnVal[1] = y1;
            }
        }
        float W = (x2 - x4) / (x2 - x4 + (x3 - x1));
        returnVal[0] = x2 + W * (x1 - x2);
        returnVal[1] = yMin + W * (yMax - yMin);
        return true;
    }

    private boolean curveIntersection(float[] returnVal, float x1, float y1, float x2, float y2, Shape curve) {
        float centerX = (x1 + x2) / 2.0f;
        float centerY = (y1 + y2) / 2.0f;
        PathIterator pi = curve.getPathIterator(this.at, 0.05f);
        float[] coords = new float[6];
        float[] pt1 = new float[2];
        float[] pt2 = new float[2];
        float[] orig = new float[2];
        float[] intersection = new float[2];
        while (!pi.isDone()) {
            int segment = pi.currentSegment(coords);
            switch (segment) {
                case 0: {
                    orig[0] = coords[0];
                    orig[1] = coords[1];
                    pt1[0] = coords[0];
                    pt1[1] = coords[1];
                    break;
                }
                case 1: {
                    pt2[0] = coords[0];
                    pt2[1] = coords[1];
                    if (AbstractNodeShape.segmentIntersection(intersection, centerX, centerY, x1, y1, pt1[0], pt1[1], pt2[0], pt2[1])) {
                        returnVal[0] = intersection[0];
                        returnVal[1] = intersection[1];
                        return true;
                    }
                    pt1[0] = pt2[0];
                    pt1[1] = pt2[1];
                    break;
                }
                case 4: {
                    pt2[0] = orig[0];
                    pt2[1] = orig[1];
                    if (!AbstractNodeShape.segmentIntersection(intersection, centerX, centerY, x1, y1, pt1[0], pt1[1], pt2[0], pt2[1])) break;
                    returnVal[0] = intersection[0];
                    returnVal[1] = intersection[1];
                    return true;
                }
                case 2: {
                    pt2[0] = coords[2];
                    pt2[1] = coords[3];
                    if (AbstractNodeShape.segmentIntersection(intersection, centerX, centerY, x1, y1, pt1[0], pt1[1], pt2[0], pt2[1])) {
                        returnVal[0] = intersection[0];
                        returnVal[1] = intersection[1];
                        return true;
                    }
                    pt1[0] = pt2[0];
                    pt1[1] = pt2[1];
                    break;
                }
                case 3: {
                    pt2[0] = coords[4];
                    pt2[1] = coords[5];
                    if (AbstractNodeShape.segmentIntersection(intersection, centerX, centerY, x1, y1, pt1[0], pt1[1], pt2[0], pt2[1])) {
                        returnVal[0] = intersection[0];
                        returnVal[1] = intersection[1];
                        return true;
                    }
                    pt1[0] = pt2[0];
                    pt1[1] = pt2[1];
                }
            }
            pi.next();
        }
        return false;
    }
}

