/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.ontology;

import cytoscape.Cytoscape;
import cytoscape.data.ontology.readers.OBOTags;
import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.ontology.Ontology;
import org.biojava.utils.AbstractChangeable;

public class OntologyTerm
extends AbstractChangeable
implements org.biojava.ontology.OntologyTerm {
    protected static final String SYNONYM = "synonym";
    private String name;
    private String ontologyName;

    public OntologyTerm(String name, String ontologyName, String description) {
        this.name = name;
        this.ontologyName = ontologyName;
        if (description != null) {
            Cytoscape.getNodeAttributes().setAttribute(name, OBOTags.getPrefix() + "." + OBOTags.DEF.toString(), description);
        }
    }

    public String getName() {
        return this.name;
    }

    public Ontology getOntology() {
        return Cytoscape.getOntologyServer().getOntologies().get(this.ontologyName);
    }

    public void addSynonym(Object synonym) {
        this.addSynonym(synonym, SynonymType.NORMAL);
    }

    public void addSynonym(Object synonym, SynonymType type) {
        HashMap<Object, SynonymType> synoMap = Cytoscape.getNodeAttributes().getMapAttribute(this.name, OBOTags.getPrefix() + "." + SYNONYM);
        if (synoMap == null) {
            synoMap = new HashMap<Object, SynonymType>();
        }
        synoMap.put(synonym, type);
        Cytoscape.getNodeAttributes().setMapAttribute(this.name, OBOTags.getPrefix() + "." + SYNONYM, synoMap);
    }

    public String getDescription() {
        return Cytoscape.getNodeAttributes().getStringAttribute(this.name, OBOTags.getPrefix() + "." + OBOTags.DEF.toString());
    }

    public Object[] getSynonyms() {
        return Cytoscape.getNodeAttributes().getMapAttribute(this.name, OBOTags.getPrefix() + "." + SYNONYM).keySet().toArray();
    }

    public void removeSynonym(Object synonym) {
        Map synoMap = Cytoscape.getNodeAttributes().getMapAttribute(this.name, SYNONYM);
        if (synoMap != null) {
            synoMap.remove(synonym);
            Cytoscape.getNodeAttributes().setMapAttribute(this.name, OBOTags.getPrefix() + "." + SYNONYM, synoMap);
        }
    }

    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SynonymType {
        NORMAL("synonym"),
        RELATED("related_synonym"),
        EXACT("exact_synonym"),
        BROAD("broad_synonym"),
        NARROW("narrow_synonym");

        private String typeText;

        private SynonymType(String type) {
            this.typeText = type;
        }

        public String toString() {
            return this.typeText;
        }
    }
}

