/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.regex;

import org.biojava.bio.seq.io.SymbolListCharSequence;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.regex.Pattern;

public class Matcher {
    private Pattern pattern;
    private java.util.regex.Matcher matcher;
    private SymbolList sl;

    Matcher(Pattern pattern, SymbolList sl) {
        this.pattern = pattern;
        this.sl = sl;
        this.matcher = pattern.getPattern().matcher(new SymbolListCharSequence(sl));
    }

    public int end() {
        return this.matcher.end() + 1;
    }

    public int end(int group) throws IndexOutOfBoundsException {
        int pos = this.matcher.end(group);
        if (pos == -1) {
            return pos;
        }
        return pos + 1;
    }

    public boolean find() {
        return this.matcher.find();
    }

    public boolean find(int start) throws IndexOutOfBoundsException {
        return this.matcher.find(start - 1);
    }

    public SymbolList group() {
        return this.sl.subList(this.start(), this.end() - 1);
    }

    public SymbolList group(int group) throws IndexOutOfBoundsException {
        int start = this.matcher.start(group);
        int end = this.matcher.end(group);
        if (start == -1 && end == -1) {
            return null;
        }
        return this.sl.subList(this.start(group), this.end(group) - 1);
    }

    public int groupCount() {
        return this.matcher.groupCount();
    }

    public boolean lookingAt() {
        return this.matcher.lookingAt();
    }

    public boolean matches() {
        return this.matcher.matches();
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public Matcher reset() {
        this.matcher = this.matcher.reset();
        return this;
    }

    public Matcher reset(SymbolList sl) {
        this.sl = sl;
        this.matcher = this.matcher.reset(new SymbolListCharSequence(sl));
        return this;
    }

    public int start() {
        return this.matcher.start() + 1;
    }

    public int start(int group) {
        int pos = this.matcher.start(group);
        if (pos == -1) {
            return pos;
        }
        return pos + 1;
    }
}

