/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.BinnedDataAxisAttributesNodeTraverser;
import jas.hist.Bins2DNodeTraverser;
import jas.hist.HasStatistics;
import jas.hist.Rebinnable2DHistogramData;
import jas.hist.Statistics;
import jas.util.xml.XMLNodeTraverser;

class XML2DHistDataSource
implements Rebinnable2DHistogramData,
HasStatistics {
    private BinnedDataAxisAttributesNodeTraverser xba;
    private BinnedDataAxisAttributesNodeTraverser yba;
    private Bins2DNodeTraverser b2d;
    private Statistics stats;

    XML2DHistDataSource(Bins2DNodeTraverser b2d, BinnedDataAxisAttributesNodeTraverser xba, BinnedDataAxisAttributesNodeTraverser yba, Statistics stats) throws XMLNodeTraverser.BadXMLException {
        this.xba = xba;
        this.yba = yba;
        this.b2d = b2d;
        this.stats = stats;
    }

    public double[][][] rebin(int xbins, double xmin, double xmax, int ybins, double ymin, double ymax, boolean wantErrors, boolean hurry, boolean xxx) {
        return this.b2d.getData();
    }

    public double getXMin() {
        return this.xba.getMin();
    }

    public double getXMax() {
        return this.xba.getMax();
    }

    public double getYMin() {
        return this.yba.getMin();
    }

    public double getYMax() {
        return this.yba.getMax();
    }

    public int getXBins() {
        return this.b2d.getData()[0].length;
    }

    public int getYBins() {
        return this.b2d.getData()[0][0].length;
    }

    public boolean isRebinnable() {
        return false;
    }

    public int getXAxisType() {
        return this.xba.getType();
    }

    public int getYAxisType() {
        return this.yba.getType();
    }

    public String[] getXAxisLabels() {
        return null;
    }

    public String[] getYAxisLabels() {
        return null;
    }

    public String getTitle() {
        return this.b2d.getTitle();
    }

    public Statistics getStatistics() {
        return this.stats;
    }
}

