/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.NUCATS.NUBIC.cytoscape.NetworkTransformer;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.writers.XGMMLWriter;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.BasicCalculator;
import cytoscape.visual.mappings.PassThroughMapping;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class nubicNetworkTransformer {
    public static final String INTERACTIONGENETOGENE = "GeneReaction";
    public static final String INTERACTIONONTOLOGYTOGENE = "GeneOntologyreaction";
    public static final String GAVISUALSTYLE = "GAnswerVS";
    public static final String GANETWORKTITLE = "GANetwork";

    public static CyNetwork createNetwork(String netPath, String edgeAttrPath, String nodeAttrPath, String netIndex) {
        String line = "";
        ArrayList<String> netEntryList = new ArrayList<String>();
        HashMap nodeAttrValueMap = new HashMap();
        ArrayList nodeAttriList = new ArrayList();
        HashMap edgeAttrValueMap = new HashMap();
        ArrayList edgeAttriList = new ArrayList();
        try {
            BufferedReader in = new BufferedReader(new FileReader(netPath));
            if (!in.ready()) {
                throw new IOException();
            }
            int i = 0;
            while ((line = in.readLine()) != null) {
                if (i == 0) {
                    ++i;
                    continue;
                }
                line = line.trim();
                netEntryList.add(line);
            }
            in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        nubicNetworkTransformer.readAttributeFile(nodeAttrPath, nodeAttriList, nodeAttrValueMap);
        nubicNetworkTransformer.readAttributeFile(edgeAttrPath, edgeAttriList, edgeAttrValueMap);
        HashSet<CyNode> nodeSet = new HashSet<CyNode>();
        HashSet<CyEdge> edgeSet = new HashSet<CyEdge>();
        for (String netEntry : netEntryList) {
            String[] nodeIDs;
            for (String nodeID : nodeIDs = netEntry.split("\t")) {
                CyNode node = Cytoscape.getCyNode(nodeID.trim(), true);
                if (node == null) continue;
                nodeSet.add(node);
            }
            String edgeID = nodeIDs[0].trim() + "_" + nodeIDs[1].trim();
            CyEdge edge = Cytoscape.getCyEdge(nodeIDs[0].trim(), edgeID, nodeIDs[1].trim(), "");
            edgeSet.add(edge);
        }
        CyNetwork net = Cytoscape.createNetwork(nodeSet, edgeSet, GANETWORKTITLE + netIndex);
        CyAttributes cyNodeAttr = Cytoscape.getNodeAttributes();
        nubicNetworkTransformer.addAttributeToNetwork(cyNodeAttr, nodeAttrValueMap, nodeAttriList);
        CyAttributes cyEdgeAttr = Cytoscape.getEdgeAttributes();
        nubicNetworkTransformer.addAttributeToNetwork(cyEdgeAttr, edgeAttrValueMap, edgeAttriList);
        return net;
    }

    private static void readAttributeFile(String filePath, List nodeAttriList, Map nodeAttrValueMap) {
        String line = "";
        try {
            int i = 0;
            BufferedReader in = new BufferedReader(new FileReader(filePath));
            if (!in.ready()) {
                throw new IOException();
            }
            while ((line = in.readLine()) != null) {
                String[] entry1;
                if (i == 0) {
                    entry1 = line.split("\t", 2);
                    String[] attrs = entry1[1].split("\t");
                    nodeAttriList.addAll(Arrays.asList(attrs));
                    ++i;
                    continue;
                }
                line = line.trim();
                entry1 = line.split("\t", 2);
                String[] attrsValues = entry1[1].split("\t");
                nodeAttrValueMap.put(entry1[0].trim(), Arrays.asList(attrsValues));
            }
            in.close();
        }
        catch (IOException e) {
            System.out.println("Something wrong with input attribute file!");
        }
    }

    private static void addAttributeToNetwork(CyAttributes cyAttr, Map attrValueMap, List attrList) {
        Set IDSet = attrValueMap.keySet();
        for (String ID2 : IDSet) {
            List attrValue = (List)attrValueMap.get(ID2);
            for (int i = 0; i < attrValue.size(); ++i) {
                cyAttr.setAttribute(ID2, (String)attrList.get(i), (String)attrValue.get(i));
            }
        }
    }

    public static CyNetworkView buildVisualStyle(CyNetwork net, String colorString) {
        VisualStyle vs = nubicNetworkTransformer.createVisualStyle(colorString);
        CyNetworkView netView = Cytoscape.getNetworkView(net.getIdentifier());
        VisualMappingManager manager = Cytoscape.getVisualMappingManager();
        CalculatorCatalog catalog = manager.getCalculatorCatalog();
        if (catalog.getVisualStyle(vs.getName()) == null) {
            catalog.addVisualStyle(vs);
        }
        netView.setVisualStyle(vs.getName());
        manager.setNetworkView(netView);
        manager.setVisualStyle(vs);
        netView.redrawGraph(true, true);
        return netView;
    }

    public static Color convertHexToRGB(String hexColorString) {
        int red = Integer.parseInt(hexColorString.substring(1, 3), 16);
        int green = Integer.parseInt(hexColorString.substring(3, 5), 16);
        int blue = Integer.parseInt(hexColorString.substring(5), 16);
        Color cc = new Color(red, green, blue);
        return cc;
    }

    public static VisualStyle createVisualStyle(String colorString) {
        VisualStyle vs = new VisualStyle(GAVISUALSTYLE);
        GlobalAppearanceCalculator gac = new GlobalAppearanceCalculator();
        if (colorString.indexOf("#") != 0) {
            colorString = "#" + colorString;
        }
        Color backgroundColor = Color.decode(colorString);
        gac.setDefaultBackgroundColor(backgroundColor);
        CyAttributes cyNodeAttr = Cytoscape.getNodeAttributes();
        String[] nodeAttr = cyNodeAttr.getAttributeNames();
        NodeAppearanceCalculator nac = vs.getNodeAppearanceCalculator();
        nac.getDefaultAppearance().set(VisualPropertyType.NODE_SHAPE, (Object)NodeShape.ELLIPSE);
        for (String attr : nodeAttr) {
            try {
                VisualPropertyType vst = VisualPropertyType.valueOf(attr);
                PassThroughMapping passThroughMapping = new PassThroughMapping(vst.getDataType(), attr);
                BasicCalculator cal = new BasicCalculator(attr.toLowerCase(), passThroughMapping, vst);
                nac.setCalculator(cal);
            }
            catch (Exception e) {
                System.out.println("No such node vst:" + attr);
            }
        }
        CyAttributes cyEdgeAttr = Cytoscape.getEdgeAttributes();
        String[] edgeAttr = cyEdgeAttr.getAttributeNames();
        EdgeAppearanceCalculator eac = vs.getEdgeAppearanceCalculator();
        for (String attr : edgeAttr) {
            try {
                VisualPropertyType vst = VisualPropertyType.valueOf(attr);
                PassThroughMapping passThroughMapping = new PassThroughMapping(vst.getDataType(), attr);
                BasicCalculator cal = new BasicCalculator(attr.toLowerCase(), passThroughMapping, vst);
                eac.setCalculator(cal);
            }
            catch (Exception e) {
                System.out.println("No such edge vst:" + attr);
            }
        }
        VisualStyle vss = new VisualStyle("GAnswerVSnew", nac, eac, gac);
        vss.setNodeAppearanceCalculator(nac);
        vss.setEdgeAppearanceCalculator(eac);
        vss.setGlobalAppearanceCalculator(gac);
        return vss;
    }

    public static void transferXGMMLToJS(String filePath, String indexOfNetwork, String globalColor) {
        String writingString = "";
        try {
            String xmlContent = nubicNetworkTransformer.readFileAsString(filePath.replace(".txt", ".xgmml"));
            writingString = "var xml" + indexOfNetwork + " = '\\" + "\n";
            writingString = writingString + xmlContent + "';";
        }
        catch (IOException ex) {
            Logger.getLogger(nubicNetworkTransformer.class.getName()).log(Level.SEVERE, null, ex);
        }
        writingString = writingString.replaceAll(">", ">\\\\");
        String oldColor = "name=\"backgroundColor\" value=\"#ffffff";
        String newColor = "name=\"backgroundColor\" value=\"" + globalColor;
        writingString = writingString.replaceAll(oldColor, newColor);
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(new File(filePath.replace(".txt", ".js"))));
            out.write(writingString);
            out.close();
        }
        catch (IOException ex) {
            Logger.getLogger(nubicNetworkTransformer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileAsString(String filePath) throws IOException {
        byte[] buffer = new byte[(int)new File(filePath).length()];
        BufferedInputStream f = null;
        try {
            f = new BufferedInputStream(new FileInputStream(filePath));
            f.read(buffer);
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new String(buffer);
    }

    public static void writeXGMML(CyNetwork net, CyNetworkView view, String filePath) {
        try {
            XGMMLWriter xgmmlWriter = new XGMMLWriter(net, view);
            File file = new File(filePath.replace(".txt", ".xgmml"));
            xgmmlWriter.write(new FileWriter(file));
        }
        catch (IOException ex) {
            Logger.getLogger(nubicNetworkTransformer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(nubicNetworkTransformer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        CyNetwork net = nubicNetworkTransformer.createNetwork(args[0], args[1], args[2], args[3]);
        CyNetworkView view = nubicNetworkTransformer.buildVisualStyle(net, args[4]);
        nubicNetworkTransformer.writeXGMML(net, view, args[0]);
        nubicNetworkTransformer.transferXGMMLToJS(args[0], args[3], args[4]);
    }
}

