/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.intr;

import cytoscape.util.intr.IntEnumerator;

public final class ArrayIntEnumerator
implements IntEnumerator {
    private final int[] m_elements;
    private int m_index;
    private final int m_end;

    public ArrayIntEnumerator(int[] elements, int beginIndex, int length) {
        if (beginIndex < 0) {
            throw new IllegalArgumentException("beginIndex is less than zero");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is less than zero");
        }
        if ((long)beginIndex + (long)length > (long)elements.length) {
            throw new IllegalArgumentException("combination of beginIndex and length exceed length of array");
        }
        this.m_elements = elements;
        this.m_index = beginIndex;
        this.m_end = beginIndex + length;
    }

    public final int numRemaining() {
        return this.m_end - this.m_index;
    }

    public final int nextInt() {
        return this.m_elements[this.m_index++];
    }
}

