## ----libraryLoad, warning=FALSE------------------------------------------
library(ENCODExplorer)

## ----load_encodeDF, collapse=TRUE----------------------------------------
    data(encode_df, package = "ENCODExplorer")

## ----query_results, collapse=TRUE, eval =T-------------------------------
query_results <- queryEncode(df=encode_df, organism = "Homo sapiens",
                      biosample_name = "MCF-7", file_format = "fastq", fixed = TRUE)

## ----query_results_2, collapse=TRUE--------------------------------------
query_results <- queryEncode(df=encode_df, organism = "Homo sapiens",
                       biosample_name = "mcf7", file_format = "fastq", fixed = TRUE)

## ----query_results_3, collapse=TRUE--------------------------------------
query_results <- queryEncode(df=encode_df, organism = "Homo sapiens",
                    biosample_name = "mcf7", file_format = "fastq", fixed = FALSE)

## ----fuzzy_results, collapse=TRUE----------------------------------------
fuzzy_results <- fuzzySearch(searchTerm = c("brca"), database = encode_df)

## ----fuzzy_results_2, collapse=TRUE--------------------------------------
fuzzy_results <- fuzzySearch(searchTerm = c("brca", "ZNF24"), database = encode_df, filterVector = c("target"), multipleTerm = TRUE)

## ----search_results, collapse=TRUE---------------------------------------
  search_results <- searchEncode(searchTerm = "a549 chip-seq homo sapiens",
                                 limit = "all")

## ----query_results_4, collapse=TRUE--------------------------------------
query_results <- queryEncode(df=encode_df, assay = "switchgear", target ="elavl1", fixed = FALSE)

## ----search_results_2, collapse=TRUE-------------------------------------
search_results <- searchEncode(searchTerm = "switchgear elavl1", limit = "all")

## ----query_results_5, collapse=TRUE, eval=FALSE--------------------------
#  query_results <- queryEncode(df=encode_df, assay = "switchgear", target ="elavl1", file_format = "bed" , fixed = FALSE)
#  downloadEncode(query_results, df = encode_df)

## ----collapse=TRUE, eval=FALSE-------------------------------------------
#  downloadEncode(search_results, df=encode_df, format = "bed")

## ----search_results_3, collapse=TRUE-------------------------------------
search_results <- searchEncode(searchTerm = "switchgear elavl1", limit = "all")

## ----convert_results_1, collapse=TRUE------------------------------------
convert_results <- searchToquery(searchResults = search_results)

