## Community contributed resources.

## -----------------------------------------------------------------------
## Timothee Flutre's GRanges from GFF 
## -----------------------------------------------------------------------
## Vitis vinifera CRIBI IGGP12Xv0 V2
metadata <- AnnotationHubMetadata(
    Description="Gene Annotation for Vitis vinifera",
    Genome="IGGP12Xv0",
    Species="Vitis vinifera",
    SourceUrl="http://genomes.cribi.unipd.it/DATA/V2/V2.1/V2.1.gff3",
    SourceLastModifiedDate=as.POSIXct("2014-04-17"),
    SourceVersion="2.1",
    RDataPath="community/tflutre/",
    TaxonomyId=29760L, 
    Title="Vvinifera_CRIBI_IGGP12Xv0_V2.1.gff3.Rdata",
    BiocVersion=package_version("3.3"),
    Coordinate_1_based=TRUE,
    DataProvider="CRIBI",
    Maintainer="Timothée Flutre <timothee.flutre@supagro.inra.fr",
    RDataClass="GRanges",
    DispatchClass="GRanges",
    SourceType="GFF",
    RDataDateAdded=as.POSIXct(Sys.time()),
    Recipe=NA_character_,
    PreparerClass="None",
    Tags=c("GFF", "CRIBI", "Gene", "Transcript", "Annotation"),
    Notes="chrUn renamed to chrUkn"
)

## Vitis vinifera Genoscope IGGP12Xv0
metadata <- AnnotationHubMetadata(
    Description="Gene Annotation for Vitis vinifera",
    Genome="IGGP12Xv0",
    Species="Vitis vinifera",
    SourceUrl="http://www.genoscope.cns.fr/externe/Download/Projets/Projet_ML/data/12X/annotation/Vitis_vinifera_annotation.gff.gz",
    SourceLastModifiedDate=as.POSIXct("2010-03-19"),
    SourceVersion="1.0",
    RDataPath="community/tflutre/",
    TaxonomyId=29760L, 
    Title="Vvinifera_Genoscope_IGGP12Xv0_V1.0.gff3.Rdata",
    BiocVersion=package_version("3.3"),
    Coordinate_1_based=TRUE,
    DataProvider="Genoscope",
    Maintainer="Timothée Flutre <timothee.flutre@supagro.inra.fr",
    RDataClass="GRanges",
    DispatchClass="GRanges",
    SourceType="GFF",
    RDataDateAdded=as.POSIXct(Sys.time()),
    Recipe=NA_character_,
    PreparerClass="None",
    Tags=c("GFF", "Genoscope", "Gene", "Transcript", "Annotation"),
    Notes="Original file format was upgraded from GFF2 to GFF3; includes rows corresponding to gene/mRNA/CDS only; chrUn renamed to chrUkn"
)

## Vitis vinifera Genoscope IGGP8X
metadata <- AnnotationHubMetadata(
    Description="Gene Annotation for Vitis vinifera",
    Genome="IGGP8X",
    Species="Vitis vinifera",
    SourceUrl="http://www.genoscope.cns.fr/externe/Download/Projets/Projet_ML/data/8X/annotation/Vitis_vinifera_annotation_v1.gff",
    SourceLastModifiedDate=as.POSIXct("2007-10-09"),
    SourceVersion="1.0",
    RDataPath="community/tflutre/",
    TaxonomyId=29760L, 
    Title="Vvinifera_Genoscope_IGGP8X_V1.0.gff3.Rdata",
    BiocVersion=package_version("3.3"),
    Coordinate_1_based=TRUE,
    DataProvider="Genoscope",
    Maintainer="Timothée Flutre <timothee.flutre@supagro.inra.fr",
    RDataClass="GRanges",
    DispatchClass="GRanges",
    SourceType="GFF",
    RDataDateAdded=as.POSIXct(Sys.time()),
    Recipe=NA_character_,
    PreparerClass="None",
    Tags=c("GFF", "Genoscope", "Gene", "Transcript", "Annotation"),
    Notes="Original file format was upgraded from GFF2 to GFF3; includes rows corresponding to gene/mRNA/CDS only; chrUn renamed to chrUkn"
)

## -----------------------------------------------------------------------
## upload to S3
file <- 
bucket <- getOption("ANNOTATION_HUB_BUCKET_NAME", "annotationhub")
remotePath <- paste0(metadata(metadata)$RDataPath, metadata(metadata)$Title)
res <- upload_to_S3(file, remotePath, bucket)

## insert metadata
metadata$RDataPath = paste0(metadata$RDataPath, metadata$Title)
url <- getOption("AH_SERVER_POST_URL")
pushMetadata(list(metadata), url)
