## ----doit,echo=FALSE,results="hide"--------------------------------------
library(gwascat)
library(GenomicRanges)
library(rtracklayer)
library(Homo.sapiens)
library(BiocGenerics)
if (!exists("cur")) load("cur.rda")

## ----lkOne,eval=FALSE----------------------------------------------------
#  library(gwascat)
#  cur = makeCurrentGwascat()  # result varies by day

## ----lkcur---------------------------------------------------------------
cur

## ----getch---------------------------------------------------------------
library(rtracklayer)
ch = import.chain("hg38ToHg19.over.chain")
ch
str(ch[[1]])

## ----dolift--------------------------------------------------------------
seqlevelsStyle(cur) = "UCSC"  # necessary
cur19 = liftOver(cur, ch)
class(cur19)

## ----ul------------------------------------------------------------------
cur19 = unlist(cur19)
genome(cur19) = "hg19"
cur19 = new("gwaswloc", cur19)
cur19

## ----lkloss--------------------------------------------------------------
length(cur)-length(cur19)
setdiff(cur$SNPs, cur19$SNPs)

