### R code from vignette source 'tigre_quick.Rnw'

###################################################
### code chunk number 1: style
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: tigre_quick.Rnw:44-45
###################################################
options(width = 60)


###################################################
### code chunk number 3: tigre_quick.Rnw:64-66 (eval = FALSE)
###################################################
## source("http://www.bioconductor.org/biocLite.R")
## biocLite("tigre")


###################################################
### code chunk number 4: tigre_quick.Rnw:75-76
###################################################
library(tigre)


###################################################
### code chunk number 5: tigre_quick.Rnw:92-105 (eval = FALSE)
###################################################
## # Names of CEL files
## expfiles <- c(paste("embryo_tc_4_", 1:12, ".CEL", sep=""),
##               paste("embryo_tc_6_", 1:12, ".CEL", sep=""),
##               paste("embryo_tc_8_", 1:12, ".CEL", sep=""))
## # Load the CEL files
## expdata <- ReadAffy(filenames=expfiles,
##                     celfile.path="embryo_tc_array_data")
## # Setup experimental data (observation times)
## pData(expdata) <- data.frame("time.h" = rep(1:12, 3),
##                              row.names=rownames(pData(expdata)))
## # Run mmgMOS processing (requires several minutes to complete)
## drosophila_mmgmos_exprs <- mmgmos(expdata)
## drosophila_mmgmos_fragment <- drosophila_mmgmos_exprs


###################################################
### code chunk number 6: tigre_quick.Rnw:110-113 (eval = FALSE)
###################################################
## drosophila_gpsim_fragment <-
##   processData(drosophila_mmgmos_fragment,
##               experiments=rep(1:3, each=12))


###################################################
### code chunk number 7: tigre_quick.Rnw:121-122
###################################################
data(drosophila_gpsim_fragment)


###################################################
### code chunk number 8: tigre_quick.Rnw:129-141
###################################################
# The probe identifier for TF 'twi'
twi <- "143396_at"
# The probe identifier for the target gene
target <- "152715_at"

# Learn the model using only one of the 3 repeats in the data
model <- GPLearn(drosophila_gpsim_fragment[,1:12],
                 TF=twi, targets=target,
                 useGpdisim=TRUE, quiet=TRUE)

# Display the model parameters
show(model)


###################################################
### code chunk number 9: tigre_quick.Rnw:147-148 (eval = FALSE)
###################################################
## GPPlot(model)


###################################################
### code chunk number 10: tigre_quick.Rnw:154-155
###################################################
GPPlot(model)


###################################################
### code chunk number 11: sessionInfo
###################################################
sessionInfo()


