/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.protein;

import com.compomics.util.enumeration.MolecularElement;
import com.compomics.util.interfaces.Sequence;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class MolecularFormula {
    Logger logger = Logger.getLogger(MolecularFormula.class);
    private HashMap<MolecularElement, Integer> iFormula = new HashMap();

    public MolecularFormula() {
    }

    public MolecularFormula(Sequence lSequence) {
        HashMap<String, MolecularFormula> iElements = new HashMap<String, MolecularFormula>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("elements.txt")));
            String[] lHeaderElements = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                if (line.startsWith("Header")) {
                    String lTemp = line.substring(line.indexOf("=") + 1);
                    lHeaderElements = lTemp.split(",");
                    continue;
                }
                String lAa = line.substring(0, line.indexOf("="));
                String[] lContribution = line.substring(line.indexOf("=") + 1).split(",");
                MolecularFormula lAaFormula = new MolecularFormula();
                for (int i = 0; i < lHeaderElements.length; ++i) {
                    for (MolecularElement lMolecularElement : MolecularElement.values()) {
                        if (!lMolecularElement.toString().equalsIgnoreCase(lHeaderElements[i])) continue;
                        lAaFormula.addElement(lMolecularElement, Integer.valueOf(lContribution[i]));
                    }
                }
                iElements.put(lAa, lAaFormula);
            }
            br.close();
        }
        catch (Exception e) {
            this.logger.error(e);
        }
        this.addElement(MolecularElement.H, 2);
        for (int i = 0; i < lSequence.getSequence().length(); ++i) {
            String lAa = String.valueOf(lSequence.getSequence().charAt(i));
            MolecularFormula lFormula = (MolecularFormula)iElements.get(lAa);
            this.addMolecularFormula(lFormula);
        }
        this.addElement(MolecularElement.H, 1);
        this.addElement(MolecularElement.O, 1);
    }

    public void addElement(MolecularElement lMolecularElement, Integer lCount) {
        Integer lOldCount = this.iFormula.get((Object)lMolecularElement);
        lOldCount = lOldCount == null ? lCount : Integer.valueOf(lOldCount + lCount);
        this.iFormula.put(lMolecularElement, lOldCount);
    }

    public void addMolecularFormula(MolecularFormula lMolecularFormula) {
        for (MolecularElement lMolecularElement : MolecularElement.values()) {
            this.addElement(lMolecularElement, lMolecularFormula.getElementCount(lMolecularElement));
        }
    }

    public int getElementCount(MolecularElement lMolecularElement) {
        Integer lCount = this.iFormula.get((Object)lMolecularElement);
        if (lCount == null) {
            return 0;
        }
        return lCount;
    }

    public String toString() {
        String lResult = "";
        for (MolecularElement lMolecularElement : MolecularElement.values()) {
            int lCount = this.getElementCount(lMolecularElement);
            if (lCount <= 0) continue;
            lResult = lResult + (Object)((Object)lMolecularElement) + this.getElementCount(lMolecularElement) + " ";
        }
        return lResult;
    }
}

