/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils.kmermatch;

import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import edu.msu.cme.rdp.readseq.utils.kmermatch.KmerMatchCore;
import edu.msu.cme.rdp.readseq.utils.orientation.GoodWordIterator;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NuclSeqMatch
extends KmerMatchCore {
    private static int setsize;
    private HashMap<String, WordSequence> seqWordMap = new HashMap();

    public NuclSeqMatch(String seqfile, int wordSize) throws IOException {
        Sequence seq;
        if (!GoodWordIterator.isWordsizeHasSet()) {
            GoodWordIterator.setWordSize(wordSize);
        }
        setsize = (int)Math.pow(4.0, GoodWordIterator.getWordsize());
        SequenceReader parser = new SequenceReader(new File(seqfile));
        while ((seq = parser.readNextSequence()) != null) {
            GoodWordIterator generator = new GoodWordIterator(seq.getSeqString());
            WordSequence wordSeq = new WordSequence(seq);
            while (generator.hasNext()) {
                wordSeq.bitset.set(generator.next());
            }
            this.seqWordMap.put(seq.getSeqName(), wordSeq);
        }
        parser.close();
    }

    public NuclSeqMatch(String seqfile) throws IOException {
        this(seqfile, 8);
    }

    public NuclSeqMatch(List<Sequence> refSeqs) throws IOException {
        this(refSeqs, 8);
    }

    public NuclSeqMatch(List<Sequence> refSeqs, int wordSize) throws IOException {
        if (!GoodWordIterator.isWordsizeHasSet()) {
            GoodWordIterator.setWordSize(wordSize);
        }
        for (Sequence seq : refSeqs) {
            GoodWordIterator generator = new GoodWordIterator(seq.getSeqString());
            WordSequence wordSeq = new WordSequence(seq);
            while (generator.hasNext()) {
                wordSeq.bitset.set(generator.next());
            }
            this.seqWordMap.put(seq.getSeqName(), wordSeq);
        }
    }

    protected static int getSetSize() {
        return setsize;
    }

    public TreeSet<KmerMatchCore.BestMatch> findAllMatches(Sequence query) throws IOException {
        WordSequence queryWordSeq = this.seqWordMap.get(query.getSeqName());
        if (queryWordSeq == null) {
            queryWordSeq = new WordSequence(query);
            GoodWordIterator generator = new GoodWordIterator(query.getSeqString());
            while (generator.hasNext()) {
                queryWordSeq.bitset.set(generator.next());
            }
        }
        TreeSet<KmerMatchCore.BestMatch> orderedResultSet = new TreeSet<KmerMatchCore.BestMatch>(new KmerMatchCore.ResultComparator());
        BitSet queryWordSet = queryWordSeq.bitset;
        float queryWordSize = queryWordSet.cardinality();
        for (String train : this.seqWordMap.keySet()) {
            BitSet tempQuerySet = (BitSet)queryWordSet.clone();
            BitSet trainWordSet = this.seqWordMap.get((Object)train).bitset;
            int trainWordSize = trainWordSet.cardinality();
            float minWordCount = queryWordSize <= (float)trainWordSize ? queryWordSize : (float)trainWordSize;
            tempQuerySet.and(trainWordSet);
            orderedResultSet.add(new KmerMatchCore.BestMatch(this.seqWordMap.get((Object)train).seq, (float)tempQuerySet.cardinality() / minWordCount, false));
        }
        return orderedResultSet;
    }

    @Override
    public ArrayList<KmerMatchCore.BestMatch> findTopKMatch(Sequence query, int k) throws IOException {
        TreeSet<KmerMatchCore.BestMatch> orderedResultSet = this.findAllMatches(query);
        ArrayList<KmerMatchCore.BestMatch> topkMatchList = new ArrayList<KmerMatchCore.BestMatch>();
        for (KmerMatchCore.BestMatch m : orderedResultSet) {
            if (topkMatchList.size() >= k) continue;
            topkMatchList.add(m);
        }
        return topkMatchList;
    }

    public static void main(String[] args) throws IOException {
        Sequence seq;
        String usage = "nucl_ref.fa nucl_query.fa outFile word_size knn\n  This program takes a nucleotide query sequence file, returns the top k best matching nucleotide reference sequences based on nucleotide kmer matching \n  word_size 8 is recommended for the best performance. Range from 6 to 10 is recommended.\n";
        if (args.length != 5) {
            System.err.println(usage);
            System.exit(1);
        }
        int wordSize = Integer.parseInt(args[3]);
        NuclSeqMatch theObj = new NuclSeqMatch(args[0], wordSize);
        PrintStream out = new PrintStream(args[2]);
        int k = Integer.parseInt(args[4]);
        SequenceReader parser = new SequenceReader(new File(args[1]));
        while ((seq = parser.readNextSequence()) != null) {
            ArrayList<KmerMatchCore.BestMatch> matches = ((KmerMatchCore)theObj).findTopKMatch(seq, k);
            for (KmerMatchCore.BestMatch match : matches) {
                out.println(seq.getSeqName() + "\t" + match.getBestMatch().getSeqName() + "\t" + match.getSab() + "\t" + match.getBestMatch().getDesc());
            }
        }
        parser.close();
        out.close();
    }

    static class WordSequence {
        Sequence seq;
        BitSet bitset = new BitSet(NuclSeqMatch.getSetSize());

        WordSequence(Sequence s) {
            this.seq = s;
        }
    }
}

