## ---- results='hide'-----------------------------------------------------
library(psichomics)
library(plyr)

## ---- include=FALSE------------------------------------------------------
suppaOutput <- system.file("extdata/eventsAnnotSample/suppa_output/suppaEvents",
                           package="psichomics")
suppaFile <- tempfile(fileext=".RDS")

## ------------------------------------------------------------------------
# Replace `genome` for the string with the identifier before the first
# underscore in the filenames of that directory (for instance, if one of your 
# filenames of interest is "hg19_A3.ioe", the string would be "hg19")
suppa <- parseSuppaAnnotation(suppaOutput, genome="hg19")
annot <- prepareAnnotationFromEvents(suppa)

# suppaFile <- "suppa_hg19_annotation.RDS"
saveRDS(annot, file=suppaFile)

## ---- include=FALSE------------------------------------------------------
matsOutput <- system.file("extdata/eventsAnnotSample/mats_output/ASEvents/",
                          package="psichomics")
matsFile <- tempfile("mats", fileext=".RDS")

## ------------------------------------------------------------------------
mats <- parseMatsAnnotation(
    matsOutput,         # Output directory from rMATS
    genome = "fromGTF", # Identifier of the filenames
    novelEvents=TRUE)   # Parse novel events?
annot <- prepareAnnotationFromEvents(mats)

# matsFile <- "mats_hg19_annotation.RDS"
saveRDS(annot, file=matsFile)

## ---- include=FALSE------------------------------------------------------
misoAnnotation <- system.file("extdata/eventsAnnotSample/miso_annotation",
                              package="psichomics")
misoFile <- tempfile("miso", fileext=".RDS")

## ------------------------------------------------------------------------
miso <- parseMisoAnnotation(misoAnnotation)
annot <- prepareAnnotationFromEvents(miso)

# misoFile <- "miso_AS_annotation_hg19.RDS"
saveRDS(annot, file=misoFile)

## ---- include=FALSE------------------------------------------------------
vastAnnotation <- system.file("extdata/eventsAnnotSample/VASTDB/Hsa/TEMPLATES/",
                              package="psichomics")
vastFile <- tempfile("vast", fileext=".RDS")

## ------------------------------------------------------------------------
vast <- parseVastToolsAnnotation(vastAnnotation)
annot <- prepareAnnotationFromEvents(vast)

# vastFile <- "vast_AS_annotation_hg19.RDS"
saveRDS(annot, file=vastFile)

## ---- include=FALSE------------------------------------------------------
annotFile <- tempfile(fileext=".RDS")

## ------------------------------------------------------------------------
# Let's combine the annotation from SUPPA, MISO, rMATS and VAST-TOOLS
suppa <- parseSuppaAnnotation(suppaOutput, genome="hg19")
miso <- parseMisoAnnotation(misoAnnotation)
mats <- parseMatsAnnotation(matsOutput, genome = "fromGTF", novelEvents=TRUE)
vast <- parseVastToolsAnnotation(vastAnnotation)

annot <- prepareAnnotationFromEvents(suppa, vast, mats, miso)

# annotFile <- "AS_annotation_hg19.RDS"
saveRDS(annot, file=annotFile)

## ------------------------------------------------------------------------
annot <- readRDS(annotFile) # "file" is the path to the annotation file
junctionQuant <- readFile("ex_junctionQuant.RDS") # example set

psi <- quantifySplicing(annot, junctionQuant, 
                        c("SE", "MXE", "A3SS", "A5SS", "AFE", "ALE"))
psi # may have 0 rows because of the small junction quantification set

