## ----setup, include=FALSE------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ----eval=FALSE----------------------------------------------------------
#  ## try http:// if https:// URLs are not supported
#  source("https://bioconductor.org/biocLite.R")
#  biocLite("phosphonormalizer")

## ----eval=FALSE----------------------------------------------------------
#      #Load the library
#      library(phosphonormalizer)
#      #Specifying the column numbers of abundances in the original data.frame,
#      #from both enriched and non-enriched runs
#      samplesCols <- data.frame(enriched=3:17, non.enriched=3:17)
#      #Specifying the column numbers of sequence and modification in the original data.frame,
#      #from both enriched and non-enriched runs
#      modseqCols <- data.frame(enriched = 1:2, non.enriched = 1:2)
#      #The samples and their technical replicates
#      techRep <- factor(x = c(1,1,1,2,2,2,3,3,3,4,4,4,5,5,5))
#      #Call the function
#      norm <- normalizePhospho(enriched = enriched.rd, non.enriched = non.enriched.rd,
#              samplesCols = samplesCols, modseqCols = modseqCols, techRep = techRep)

