/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.io.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.xml.PsimiXmlReaderException;
import psidev.psi.mi.xml.io.PsimiXmlLightweightReader;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.Feature;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml.model.Participant;
import psidev.psi.mi.xml.xmlindex.IndexElementUtils;
import psidev.psi.mi.xml.xmlindex.IndexedEntry;
import psidev.psi.mi.xml.xmlindex.InputStreamRangeAdapter;
import psidev.psi.mi.xml.xmlindex.PsimiXmlExtractor;
import psidev.psi.mi.xml.xmlindex.PsimiXmlFileIndex;
import psidev.psi.mi.xml.xmlindex.PsimiXmlPullParser;
import psidev.psi.mi.xml.xmlindex.impl.PsimiXmlPullParser254;
import psidev.psi.tools.xxindex.index.IndexElement;
import psidev.psi.tools.xxindex.index.StandardXpathIndex;
import psidev.psi.tools.xxindex.index.XmlXpathIndexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsimiXmlLightweightReader254
implements PsimiXmlLightweightReader {
    private static final Log log = LogFactory.getLog(PsimiXmlLightweightReader254.class);
    private File xmlDataFile;
    private StandardXpathIndex xpathIndex;
    private static final Set<String> psimixmlXpathIncludes = new HashSet<String>();
    private PsimiXmlPullParser parser;

    public PsimiXmlLightweightReader254(File xmlDataFile) throws PsimiXmlReaderException {
        this.init(xmlDataFile);
    }

    public PsimiXmlLightweightReader254(URL url) throws PsimiXmlReaderException {
        if (url == null) {
            throw new IllegalArgumentException("You must give a non null url");
        }
        try {
            File f = this.saveOnDisk(url.openStream());
            this.init(f);
        }
        catch (IOException e2) {
            throw new PsimiXmlReaderException("An error occured while reading the content of the URL: " + url, e2);
        }
    }

    public PsimiXmlLightweightReader254(InputStream is) throws PsimiXmlReaderException {
        if (is == null) {
            throw new IllegalArgumentException("You must give a non null data stream");
        }
        try {
            File f = this.saveOnDisk(is);
            this.init(f);
        }
        catch (IOException e2) {
            throw new PsimiXmlReaderException("An error occured while reading the content of the given input stream,", e2);
        }
    }

    private void init(File file) throws PsimiXmlReaderException {
        if (file == null) {
            throw new IllegalArgumentException("You must give a non null xmlDataFile");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("You must give an existing xmlDataFile: " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("You must give a readable xmlDataFile: " + file.getAbsolutePath());
        }
        this.xmlDataFile = file;
        try {
            if (log.isDebugEnabled()) {
                log.debug("Building XPath index from xmlDataFile: " + file.getAbsolutePath());
            }
            this.xpathIndex = XmlXpathIndexer.buildIndex(new FileInputStream(file), psimixmlXpathIncludes, true);
            if (log.isDebugEnabled()) {
                log.debug("Content of the Xpath index:");
                log.debug("--------------------------");
                Set<String> keys = this.xpathIndex.getKeys();
                for (String key : keys) {
                    log.debug(key + " -> " + this.xpathIndex.getElements(key).size());
                }
            }
        }
        catch (IOException e2) {
            throw new PsimiXmlReaderException("An error occured while indexing the xmlDataFile: " + file.getAbsolutePath(), e2);
        }
    }

    private PsimiXmlFileIndex buildPsimiIndex(StandardXpathIndex index, File file, IndexElement entryRange) throws PsimiXmlReaderException {
        if (log.isDebugEnabled()) {
            log.debug("Building index by id from xmlDataFile: " + file.getAbsolutePath());
        }
        PsimiXmlFileIndex psiIndex = new PsimiXmlFileIndex(file);
        try {
            FileInputStream fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e2) {
            throw new PsimiXmlReaderException("Error while creating a FileInputStream for: " + file.getAbsolutePath(), e2);
        }
        this.parser = new PsimiXmlPullParser254();
        List<IndexElement> experimentRanges = index.getElements("/entrySet/entry/experimentList/experimentDescription");
        experimentRanges = IndexElementUtils.filterRanges(entryRange, experimentRanges);
        if (log.isDebugEnabled()) {
            log.debug("Now converting " + experimentRanges.size() + " experiment(s)");
        }
        for (IndexElement range : experimentRanges) {
            InputStream snippetStream;
            InputStreamRangeAdapter isr = new InputStreamRangeAdapter(range);
            try {
                snippetStream = PsimiXmlExtractor.extractXmlSnippet(file, isr);
            }
            catch (IOException e3) {
                throw new PsimiXmlReaderException("Error while extracting experiment XML smippet", e3);
            }
            ExperimentDescription ed = this.parser.parseExperiment(snippetStream);
            psiIndex.addExperiment(ed.getId(), isr);
        }
        List<IndexElement> interactorRanges = index.getElements("/entrySet/entry/interactorList/interactor");
        interactorRanges = IndexElementUtils.filterRanges(entryRange, interactorRanges);
        if (log.isDebugEnabled()) {
            log.debug("Now converting " + interactorRanges.size() + " interactor(s)");
        }
        for (IndexElement range : interactorRanges) {
            InputStream snippetStream;
            InputStreamRangeAdapter isr = new InputStreamRangeAdapter(range);
            try {
                snippetStream = PsimiXmlExtractor.extractXmlSnippet(file, isr);
            }
            catch (IOException e4) {
                throw new PsimiXmlReaderException("Error while extracting interactor XML smippet", e4);
            }
            Interactor interactor = this.parser.parseInteractor(snippetStream);
            psiIndex.addInteractor(interactor.getId(), isr);
        }
        List<IndexElement> interactionRanges = index.getElements("/entrySet/entry/interactionList/interaction");
        interactionRanges = IndexElementUtils.filterRanges(entryRange, interactionRanges);
        if (log.isDebugEnabled()) {
            log.debug("Now converting " + interactionRanges.size() + " interaction(s)");
        }
        for (IndexElement range : interactionRanges) {
            InputStream snippetStream;
            InputStreamRangeAdapter isr = new InputStreamRangeAdapter(range);
            try {
                snippetStream = PsimiXmlExtractor.extractXmlSnippet(file, isr);
            }
            catch (IOException e5) {
                throw new PsimiXmlReaderException("Error while extracting interaction XML smippet", e5);
            }
            Interaction interaction2 = this.parser.parseInteraction(snippetStream);
            psiIndex.addInteraction(interaction2.getId(), isr);
        }
        List<IndexElement> participantRanges = index.getElements("/entrySet/entry/interactionList/interaction/participantList/participant");
        participantRanges = IndexElementUtils.filterRanges(entryRange, participantRanges);
        if (log.isDebugEnabled()) {
            log.debug("Now converting " + participantRanges.size() + " participant(s)");
        }
        for (IndexElement range : participantRanges) {
            InputStream snippetStream;
            InputStreamRangeAdapter isr = new InputStreamRangeAdapter(range);
            try {
                snippetStream = PsimiXmlExtractor.extractXmlSnippet(file, isr);
            }
            catch (IOException e6) {
                throw new PsimiXmlReaderException("Error while extracting participant XML smippet", e6);
            }
            Participant participant = this.parser.parseParticipant(snippetStream);
            psiIndex.addParticipant(participant.getId(), isr);
        }
        List<IndexElement> featureRanges = index.getElements("/entrySet/entry/interactionList/interaction/participantList/participant/featureList/feature");
        featureRanges = IndexElementUtils.filterRanges(entryRange, featureRanges);
        if (log.isDebugEnabled()) {
            log.debug("Now converting " + featureRanges.size() + " feature(s)");
        }
        for (IndexElement range : featureRanges) {
            InputStream snippetStream;
            InputStreamRangeAdapter isr = new InputStreamRangeAdapter(range);
            try {
                snippetStream = PsimiXmlExtractor.extractXmlSnippet(file, isr);
            }
            catch (IOException e7) {
                throw new PsimiXmlReaderException("Error while extracting feature XML smippet", e7);
            }
            Feature feature = this.parser.parseFeature(snippetStream);
            psiIndex.addFeature(feature.getId(), isr);
        }
        if (log.isDebugEnabled()) {
            log.debug("Experiment: " + psiIndex.getExperimentCount());
            log.debug("Interaction: " + psiIndex.getInteractionCount());
            log.debug("Interactor: " + psiIndex.getInteractorCount());
            log.debug("Participant: " + psiIndex.getParticipantCount());
            log.debug("Feature: " + psiIndex.getFeatureCount());
        }
        return psiIndex;
    }

    private File saveOnDisk(InputStream is) throws IOException {
        File tmpFile = File.createTempFile("psi25-xml.", ".xml");
        tmpFile.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(tmpFile));
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        char[] buf = new char[8192];
        int read = -2;
        while ((read = in.read(buf, 0, 8192)) != -1) {
            out.write(buf, 0, read);
        }
        in.close();
        out.flush();
        out.close();
        return tmpFile;
    }

    @Override
    public List<IndexedEntry> getIndexedEntries() throws PsimiXmlReaderException {
        ArrayList<IndexedEntry> entries = new ArrayList<IndexedEntry>();
        if (this.parser == null) {
            this.parser = new PsimiXmlPullParser254();
        }
        List<IndexElement> ranges = this.xpathIndex.getElements("/entrySet/entry");
        for (IndexElement range : ranges) {
            PsimiXmlFileIndex myIndex = this.buildPsimiIndex(this.xpathIndex, this.xmlDataFile, range);
            entries.add(new IndexedEntry(myIndex, this.xpathIndex, range, this.xmlDataFile, this.parser));
        }
        return entries;
    }

    static {
        psimixmlXpathIncludes.add("/entrySet");
        psimixmlXpathIncludes.add("/entrySet/entry");
        psimixmlXpathIncludes.add("/entrySet/entry/source");
        psimixmlXpathIncludes.add("/entrySet/entry/availabilityList");
        psimixmlXpathIncludes.add("/entrySet/entry/availabilityList/availability");
        psimixmlXpathIncludes.add("/entrySet/entry/experimentList/experimentDescription");
        psimixmlXpathIncludes.add("/entrySet/entry/interactorList/interactor");
        psimixmlXpathIncludes.add("/entrySet/entry/interactionList/interaction");
        psimixmlXpathIncludes.add("/entrySet/entry/interactionList/interaction/participantList/participant");
        psimixmlXpathIncludes.add("/entrySet/entry/interactionList/interaction/participantList/participant/featureList/feature");
        psimixmlXpathIncludes.add("/entrySet/entry/attributeList");
        psimixmlXpathIncludes.add("/entrySet/entry/attributeList/attribute");
    }
}

