/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.converter.impl254;

import java.util.ArrayList;
import psidev.psi.mi.xml.PsimiXmlForm;
import psidev.psi.mi.xml.converter.ConverterContext;
import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.impl254.AttributeConverter;
import psidev.psi.mi.xml.converter.impl254.AvailabilityConverter;
import psidev.psi.mi.xml.converter.impl254.ExperimentDescriptionConverter;
import psidev.psi.mi.xml.converter.impl254.InteractionConverter;
import psidev.psi.mi.xml.converter.impl254.InteractorConverter;
import psidev.psi.mi.xml.converter.impl254.SourceConverter;
import psidev.psi.mi.xml.dao.DAOFactory;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Participant;
import psidev.psi.mi.xml254.jaxb.AttributeList;
import psidev.psi.mi.xml254.jaxb.Availability;
import psidev.psi.mi.xml254.jaxb.AvailabilityList;
import psidev.psi.mi.xml254.jaxb.ExperimentDescriptionList;
import psidev.psi.mi.xml254.jaxb.InteractionList;
import psidev.psi.mi.xml254.jaxb.Interactor;
import psidev.psi.mi.xml254.jaxb.InteractorList;

public class EntryConverter {
    private SourceConverter sourceConverter = new SourceConverter();
    private ExperimentDescriptionConverter experimentDescriptionConverter = new ExperimentDescriptionConverter();
    private AttributeConverter attributeConverter = new AttributeConverter();
    private AvailabilityConverter availabilityConverter = new AvailabilityConverter();
    private InteractionConverter interactionConverter = new InteractionConverter();
    private InteractorConverter interactorConverter = new InteractorConverter();
    private DAOFactory factory;

    public void setDAOFactory(DAOFactory factory) {
        this.factory = factory;
        this.experimentDescriptionConverter.setDAOFactory(factory);
        this.interactionConverter.setDAOFactory(factory);
        this.interactorConverter.setDAOFactory(factory);
    }

    private void checkDependencies() throws ConverterException {
        if (this.factory == null) {
            throw new ConverterException("Please set a DAO factory in order to resolve experiment's id.");
        }
    }

    public Entry fromJaxb(psidev.psi.mi.xml254.jaxb.Entry jEntry) throws ConverterException {
        if (jEntry == null) {
            throw new IllegalArgumentException("You must give a non null JAXB entry.");
        }
        this.checkDependencies();
        Entry mEntry = new Entry();
        mEntry.setSource(this.sourceConverter.fromJaxb(jEntry.getSource()));
        if (jEntry.getAvailabilityList() != null) {
            for (Availability jAvailability : jEntry.getAvailabilityList().getAvailabilities()) {
                mEntry.getAvailabilities().add(this.availabilityConverter.fromJaxb(jAvailability));
            }
        }
        if (jEntry.getExperimentList() != null) {
            for (psidev.psi.mi.xml254.jaxb.ExperimentDescription jExperiment : jEntry.getExperimentList().getExperimentDescriptions()) {
                mEntry.getExperiments().add(this.experimentDescriptionConverter.fromJaxb(jExperiment));
            }
        }
        if (jEntry.getInteractorList() != null) {
            for (Interactor jInteractor : jEntry.getInteractorList().getInteractors()) {
                mEntry.getInteractors().add(this.interactorConverter.fromJaxb(jInteractor));
            }
        }
        if (jEntry.getInteractionList() != null) {
            for (psidev.psi.mi.xml254.jaxb.Interaction jInteraction : jEntry.getInteractionList().getInteractions()) {
                mEntry.getInteractions().add(this.interactionConverter.fromJaxb(jInteraction));
            }
        }
        if (jEntry.getAttributeList() != null) {
            for (psidev.psi.mi.xml254.jaxb.Attribute jAttribute : jEntry.getAttributeList().getAttributes()) {
                mEntry.getAttributes().add(this.attributeConverter.fromJaxb(jAttribute));
            }
        }
        if (mEntry.getExperiments().isEmpty()) {
            ArrayList<Integer> experimentIds = new ArrayList<Integer>();
            for (Interaction mInteraction : mEntry.getInteractions()) {
                for (ExperimentDescription jExperiment : mInteraction.getExperiments()) {
                    if (experimentIds.contains(jExperiment.getId())) continue;
                    mEntry.getExperiments().add(jExperiment);
                    experimentIds.add(jExperiment.getId());
                }
            }
        }
        if (mEntry.getInteractors().isEmpty()) {
            ArrayList<Integer> participantIds = new ArrayList<Integer>();
            for (Interaction mInteraction : mEntry.getInteractions()) {
                for (Participant mParticipant : mInteraction.getParticipants()) {
                    if (participantIds.contains(mParticipant.getId())) continue;
                    mEntry.getInteractors().add(mParticipant.getInteractor());
                    participantIds.add(mParticipant.getInteractor().getId());
                }
            }
        }
        this.factory.reset();
        return mEntry;
    }

    public psidev.psi.mi.xml254.jaxb.Entry toJaxb(Entry mEntry) throws ConverterException {
        ArrayList<Integer> experimentIds;
        if (mEntry == null) {
            throw new IllegalArgumentException("You must give a non null model entry.");
        }
        this.checkDependencies();
        psidev.psi.mi.xml254.jaxb.Entry jEntry = new psidev.psi.mi.xml254.jaxb.Entry();
        if (mEntry.hasSource()) {
            jEntry.setSource(this.sourceConverter.toJaxb(mEntry.getSource()));
        }
        if (mEntry.hasAvailabilities()) {
            if (jEntry.getAvailabilityList() == null) {
                jEntry.setAvailabilityList(new AvailabilityList());
            }
            for (psidev.psi.mi.xml.model.Availability mAvailability : mEntry.getAvailabilities()) {
                jEntry.getAvailabilityList().getAvailabilities().add(this.availabilityConverter.toJaxb(mAvailability));
            }
        }
        if (mEntry.hasExperiments() && PsimiXmlForm.FORM_COMPACT == ConverterContext.getInstance().getConverterConfig().getXmlForm()) {
            if (jEntry.getExperimentList() == null) {
                jEntry.setExperimentList(new ExperimentDescriptionList());
            }
            experimentIds = new ArrayList<Integer>();
            for (ExperimentDescription mExperiment : mEntry.getExperiments()) {
                if (experimentIds.contains(mExperiment.getId())) continue;
                jEntry.getExperimentList().getExperimentDescriptions().add(this.experimentDescriptionConverter.toJaxb(mExperiment));
                experimentIds.add(mExperiment.getId());
            }
        }
        if (mEntry.hasInteractors() && PsimiXmlForm.FORM_COMPACT == ConverterContext.getInstance().getConverterConfig().getXmlForm()) {
            if (jEntry.getInteractorList() == null) {
                jEntry.setInteractorList(new InteractorList());
            }
            ArrayList<Integer> interactorIds = new ArrayList<Integer>();
            for (psidev.psi.mi.xml.model.Interactor mInteractor : mEntry.getInteractors()) {
                if (interactorIds.contains(mInteractor.getId())) continue;
                jEntry.getInteractorList().getInteractors().add(this.interactorConverter.toJaxb(mInteractor));
                interactorIds.add(mInteractor.getId());
            }
        }
        for (Interaction mInteraction : mEntry.getInteractions()) {
            if (jEntry.getInteractionList() == null) {
                jEntry.setInteractionList(new InteractionList());
            }
            jEntry.getInteractionList().getInteractions().add(this.interactionConverter.toJaxb(mInteraction));
        }
        if (mEntry.hasAttributes()) {
            if (jEntry.getAttributeList() == null) {
                jEntry.setAttributeList(new AttributeList());
            }
            for (Attribute mAttribute : mEntry.getAttributes()) {
                jEntry.getAttributeList().getAttributes().add(this.attributeConverter.toJaxb(mAttribute));
            }
        }
        if (PsimiXmlForm.FORM_EXPANDED == ConverterContext.getInstance().getConverterConfig().getXmlForm()) {
            jEntry.setExperimentList(null);
            jEntry.setInteractorList(null);
        } else {
            if (jEntry.getExperimentList() == null) {
                jEntry.setExperimentList(new ExperimentDescriptionList());
                experimentIds = new ArrayList();
                for (Interaction jInteraction : mEntry.getInteractions()) {
                    for (ExperimentDescription jExperiment : jInteraction.getExperiments()) {
                        if (experimentIds.contains(jExperiment.getId())) continue;
                        jEntry.getExperimentList().getExperimentDescriptions().add(this.experimentDescriptionConverter.toJaxb(jExperiment));
                        experimentIds.add(jExperiment.getId());
                    }
                }
            }
            if (jEntry.getInteractorList() == null) {
                jEntry.setInteractorList(new InteractorList());
                ArrayList<Integer> participantIds = new ArrayList<Integer>();
                for (Interaction mInteraction : mEntry.getInteractions()) {
                    for (Participant mParticipant : mInteraction.getParticipants()) {
                        if (participantIds.contains(mParticipant.getId())) continue;
                        jEntry.getInteractorList().getInteractors().add(this.interactorConverter.toJaxb(mParticipant.getInteractor()));
                        participantIds.add(mParticipant.getId());
                    }
                }
            }
        }
        return jEntry;
    }
}

