/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.algorithm;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.query.algorithm.BFS;
import org.biopax.paxtools.query.algorithm.Direction;
import org.biopax.paxtools.query.model.GraphObject;
import org.biopax.paxtools.query.model.Node;

public class CommonStreamQuery {
    private Collection<Set<Node>> sourceSet;
    private Direction direction;
    private int limit;
    Map<GraphObject, Integer> reachedCount = new HashMap<GraphObject, Integer>();

    public CommonStreamQuery(Set<Node> sourceNodeSet, Direction direction, int limit) {
        if (direction != Direction.UPSTREAM && direction != Direction.DOWNSTREAM) {
            throw new IllegalArgumentException("Direction has to be either upstream or downstream");
        }
        this.sourceSet = new LinkedHashSet<Set<Node>>();
        for (Node node : sourceNodeSet) {
            HashSet<Node> sourceNode = new HashSet<Node>();
            sourceNode.add(node);
            this.sourceSet.add(sourceNode);
        }
        this.direction = direction;
        this.limit = limit;
    }

    public CommonStreamQuery(Collection<Set<Node>> sourceStateSet, Direction direction, int limit) {
        if (direction != Direction.UPSTREAM && direction != Direction.DOWNSTREAM) {
            throw new IllegalArgumentException("Direction has to be either upstream or downstream");
        }
        this.sourceSet = sourceStateSet;
        this.direction = direction;
        this.limit = limit;
    }

    public Set<GraphObject> run() {
        HashMap candidate = new HashMap();
        HashSet<GraphObject> result = new HashSet<GraphObject>();
        for (Set<Node> source : this.sourceSet) {
            BFS bfs = new BFS(source, null, this.direction, this.limit);
            HashMap<GraphObject, Integer> BFSResult = new HashMap<GraphObject, Integer>();
            BFSResult.putAll(bfs.run());
            for (GraphObject go : BFSResult.keySet()) {
                this.setLabel(go, this.getLabel(go) + 1);
            }
            candidate.putAll(BFSResult);
        }
        for (GraphObject go : candidate.keySet()) {
            if (this.getLabel(go) != this.sourceSet.size()) continue;
            result.add(go);
        }
        return result;
    }

    private int getLabel(GraphObject go) {
        if (!this.reachedCount.containsKey(go)) {
            return 0;
        }
        return this.reachedCount.get(go);
    }

    private void setLabel(GraphObject go, int label) {
        this.reachedCount.put(go, label);
    }
}

