/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl.oldCode;

import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.BRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.GoalResults;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.GoalState;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.RuleState;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GoalTable {
    protected Map table = new HashMap();
    protected BRuleEngine ruleEngine;
    static Log logger = LogFactory.getLog(GoalTable.class);

    public GoalTable(BRuleEngine ruleEngine) {
        this.ruleEngine = ruleEngine;
    }

    public GoalState findGoal(TriplePattern goal) {
        GoalResults results = (GoalResults)this.table.get(goal);
        if (results == null || !goal.variantOf(results.goal)) {
            results = new GoalResults(goal, this.ruleEngine);
            this.table.put(goal, results);
        }
        return new GoalState(this.ruleEngine.getInfGraph().findDataMatches(goal), results);
    }

    public void reset() {
        this.table = new HashMap();
    }

    public void removePartialGoals() {
        Iterator i = this.table.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            TriplePattern goal = (TriplePattern)entry.getKey();
            GoalResults result = (GoalResults)entry.getValue();
            if (result.isComplete()) continue;
            Iterator d = result.dependents.iterator();
            while (d.hasNext()) {
                RuleState rs = (RuleState)d.next();
                if (rs.goalState == null) continue;
                rs.goalState.close();
            }
            i.remove();
        }
    }

    public void setAllComplete() {
        Iterator i = this.table.values().iterator();
        while (i.hasNext()) {
            ((GoalResults)i.next()).setAllComplete();
        }
    }

    public void dump() {
        System.out.println("Final goal table");
        Iterator i = this.table.values().iterator();
        while (i.hasNext()) {
            GoalResults gr = (GoalResults)i.next();
            System.out.println(gr.toString());
            for (int j = 0; j < gr.numResults(); ++j) {
                System.out.println(" - " + gr.getResult(j));
            }
        }
    }
}

