/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.converter.impl253;

import java.util.ArrayList;
import psidev.psi.mi.xml.PsimiXmlForm;
import psidev.psi.mi.xml.converter.ConverterContext;
import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.impl253.AttributeConverter;
import psidev.psi.mi.xml.converter.impl253.AvailabilityConverter;
import psidev.psi.mi.xml.converter.impl253.ExperimentDescriptionConverter;
import psidev.psi.mi.xml.converter.impl253.InteractionConverter;
import psidev.psi.mi.xml.converter.impl253.InteractorConverter;
import psidev.psi.mi.xml.converter.impl253.SourceConverter;
import psidev.psi.mi.xml.dao.DAOFactory;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.Availability;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml.model.Participant;
import psidev.psi.mi.xml253.jaxb.AttributeListType;
import psidev.psi.mi.xml253.jaxb.AvailabilityType;
import psidev.psi.mi.xml253.jaxb.EntryType;
import psidev.psi.mi.xml253.jaxb.ExperimentType;
import psidev.psi.mi.xml253.jaxb.InteractorElementType;

public class EntryConverter {
    private SourceConverter sourceConverter = new SourceConverter();
    private ExperimentDescriptionConverter experimentDescriptionConverter = new ExperimentDescriptionConverter();
    private AttributeConverter attributeConverter = new AttributeConverter();
    private AvailabilityConverter availabilityConverter = new AvailabilityConverter();
    private InteractionConverter interactionConverter = new InteractionConverter();
    private InteractorConverter interactorConverter = new InteractorConverter();
    private DAOFactory factory;

    public void setDAOFactory(DAOFactory factory) {
        this.factory = factory;
        this.experimentDescriptionConverter.setDAOFactory(factory);
        this.interactionConverter.setDAOFactory(factory);
        this.interactorConverter.setDAOFactory(factory);
    }

    private void checkDependencies() throws ConverterException {
        if (this.factory == null) {
            throw new ConverterException("Please set a DAO factory in order to resolve experiment's id.");
        }
    }

    public Entry fromJaxb(EntryType jEntry) throws ConverterException {
        if (jEntry == null) {
            throw new IllegalArgumentException("You must give a non null JAXB entry.");
        }
        this.checkDependencies();
        Entry mEntry = new Entry();
        mEntry.setSource(this.sourceConverter.fromJaxb(jEntry.getSource()));
        if (jEntry.getAvailabilityList() != null) {
            for (AvailabilityType jAvailability : jEntry.getAvailabilityList().getAvailabilities()) {
                mEntry.getAvailabilities().add(this.availabilityConverter.fromJaxb(jAvailability));
            }
        }
        if (jEntry.getExperimentList() != null) {
            for (ExperimentType jExperiment : jEntry.getExperimentList().getExperimentDescriptions()) {
                mEntry.getExperiments().add(this.experimentDescriptionConverter.fromJaxb(jExperiment));
            }
        }
        if (jEntry.getInteractorList() != null) {
            for (InteractorElementType jInteractor : jEntry.getInteractorList().getInteractors()) {
                mEntry.getInteractors().add(this.interactorConverter.fromJaxb(jInteractor));
            }
        }
        if (jEntry.getInteractionList() != null) {
            for (EntryType.InteractionList.Interaction jInteraction : jEntry.getInteractionList().getInteractions()) {
                mEntry.getInteractions().add(this.interactionConverter.fromJaxb(jInteraction));
            }
        }
        if (jEntry.getAttributeList() != null) {
            for (AttributeListType.Attribute jAttribute : jEntry.getAttributeList().getAttributes()) {
                mEntry.getAttributes().add(this.attributeConverter.fromJaxb(jAttribute));
            }
        }
        if (mEntry.getExperiments().isEmpty()) {
            for (Interaction mInteraction : mEntry.getInteractions()) {
                mEntry.getExperiments().addAll(mInteraction.getExperiments());
            }
        }
        if (mEntry.getInteractors().isEmpty()) {
            for (Interaction mInteraction : mEntry.getInteractions()) {
                for (Participant mParticipant : mInteraction.getParticipants()) {
                    mEntry.getInteractors().add(mParticipant.getInteractor());
                }
            }
        }
        this.factory.reset();
        return mEntry;
    }

    public EntryType toJaxb(Entry mEntry) throws ConverterException {
        ArrayList<Integer> experimentIds;
        if (mEntry == null) {
            throw new IllegalArgumentException("You must give a non null model entry.");
        }
        this.checkDependencies();
        EntryType jEntry = new EntryType();
        if (mEntry.hasSource()) {
            jEntry.setSource(this.sourceConverter.toJaxb(mEntry.getSource()));
        }
        if (mEntry.hasAvailabilities()) {
            if (jEntry.getAvailabilityList() == null) {
                jEntry.setAvailabilityList(new EntryType.AvailabilityList());
            }
            for (Availability mAvailability : mEntry.getAvailabilities()) {
                jEntry.getAvailabilityList().getAvailabilities().add(this.availabilityConverter.toJaxb(mAvailability));
            }
        }
        if (mEntry.hasExperiments()) {
            if (jEntry.getExperimentList() == null) {
                jEntry.setExperimentList(new EntryType.ExperimentList());
            }
            experimentIds = new ArrayList<Integer>();
            for (ExperimentDescription mExperiment : mEntry.getExperiments()) {
                if (experimentIds.contains(mExperiment.getId())) continue;
                jEntry.getExperimentList().getExperimentDescriptions().add(this.experimentDescriptionConverter.toJaxb(mExperiment));
                experimentIds.add(mExperiment.getId());
            }
        }
        if (mEntry.hasInteractors()) {
            if (jEntry.getInteractorList() == null) {
                jEntry.setInteractorList(new EntryType.InteractorList());
            }
            ArrayList<Integer> interactorIds = new ArrayList<Integer>();
            for (Interactor mInteractor : mEntry.getInteractors()) {
                if (interactorIds.contains(mInteractor.getId())) continue;
                jEntry.getInteractorList().getInteractors().add(this.interactorConverter.toJaxb(mInteractor));
                interactorIds.add(mInteractor.getId());
            }
        }
        for (Interaction mInteraction : mEntry.getInteractions()) {
            if (jEntry.getInteractionList() == null) {
                jEntry.setInteractionList(new EntryType.InteractionList());
            }
            jEntry.getInteractionList().getInteractions().add(this.interactionConverter.toJaxb(mInteraction));
        }
        if (mEntry.hasAttributes()) {
            if (jEntry.getAttributeList() == null) {
                jEntry.setAttributeList(new AttributeListType());
            }
            for (Attribute mAttribute : mEntry.getAttributes()) {
                jEntry.getAttributeList().getAttributes().add(this.attributeConverter.toJaxb(mAttribute));
            }
        }
        if (PsimiXmlForm.FORM_EXPANDED == ConverterContext.getInstance().getConverterConfig().getXmlForm()) {
            jEntry.setExperimentList(null);
            jEntry.setInteractorList(null);
        } else {
            if (jEntry.getExperimentList() == null) {
                jEntry.setExperimentList(new EntryType.ExperimentList());
                experimentIds = new ArrayList();
                for (Interaction jInteraction : mEntry.getInteractions()) {
                    for (ExperimentDescription jExperiment : jInteraction.getExperiments()) {
                        if (experimentIds.contains(jExperiment.getId())) continue;
                        jEntry.getExperimentList().getExperimentDescriptions().add(this.experimentDescriptionConverter.toJaxb(jExperiment));
                        experimentIds.add(jExperiment.getId());
                    }
                }
            }
            if (jEntry.getInteractorList() == null) {
                jEntry.setInteractorList(new EntryType.InteractorList());
                ArrayList<Integer> participantIds = new ArrayList<Integer>();
                for (Interaction mInteraction : mEntry.getInteractions()) {
                    for (Participant mParticipant : mInteraction.getParticipants()) {
                        if (participantIds.contains(mParticipant.getId())) continue;
                        jEntry.getInteractorList().getInteractors().add(this.interactorConverter.toJaxb(mParticipant.getInteractor()));
                        participantIds.add(mParticipant.getId());
                    }
                }
            }
        }
        return jEntry;
    }
}

