/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.constraint;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.ModificationFeature;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.constraint.ConstraintAdapter;

public class ActivityModificationChangeConstraint
extends ConstraintAdapter {
    boolean activating;
    static PathAccessor pa = new PathAccessor("PhysicalEntity/feature:ModificationFeature");
    protected static final String[] general = new String[]{"phospho", "ubiqutin", "acetyl", "myristoyl", "palmitoyl", "glucosyl"};
    Map<EntityReference, Set<ModificationFeature>> activityFeat;
    Map<EntityReference, Set<ModificationFeature>> inactivityFeat;
    Map<EntityReference, Set<String>> activityStr;
    Map<EntityReference, Set<String>> inactivityStr;

    public ActivityModificationChangeConstraint(boolean activating, Map<EntityReference, Set<ModificationFeature>> activityFeat, Map<EntityReference, Set<ModificationFeature>> inactivityFeat) {
        super(2);
        this.activating = activating;
        this.activityFeat = activityFeat;
        this.inactivityFeat = inactivityFeat;
        this.activityStr = this.extractModifNames(activityFeat);
        this.inactivityStr = this.extractModifNames(inactivityFeat);
    }

    @Override
    public boolean satisfies(Match match, int ... ind) {
        BioPAXElement ele1 = match.get(ind[0]);
        BioPAXElement ele2 = match.get(ind[1]);
        EntityReference er = ((SimplePhysicalEntity)ele1).getEntityReference();
        Set set1 = pa.getValueFromBean(ele1);
        Set set2 = pa.getValueFromBean(ele2);
        HashSet gain = new HashSet(set2);
        gain.removeAll(set1);
        HashSet loss = new HashSet(set1);
        loss.removeAll(set2);
        int activatingCnt = 0;
        int inhibitingCnt = 0;
        for (Object o : gain) {
            if (this.activityFeat.get(er).contains(o)) {
                ++activatingCnt;
            }
            if (!this.inactivityFeat.get(er).contains(o)) continue;
            ++inhibitingCnt;
        }
        for (Object o : loss) {
            if (this.inactivityFeat.get(er).contains(o)) {
                ++activatingCnt;
            }
            if (!this.activityFeat.get(er).contains(o)) continue;
            ++inhibitingCnt;
        }
        Set<String> gainTypes = null;
        Set<String> lossTypes = null;
        if (activatingCnt + inhibitingCnt == 0) {
            gainTypes = this.extractModifNames(gain);
            lossTypes = this.extractModifNames(loss);
            for (String s : gainTypes) {
                if (this.activityStr.get(er).contains(s)) {
                    ++activatingCnt;
                }
                if (!this.inactivityStr.get(er).contains(s)) continue;
                ++inhibitingCnt;
            }
            for (String s : lossTypes) {
                if (this.inactivityStr.get(er).contains(s)) {
                    ++activatingCnt;
                }
                if (!this.activityStr.get(er).contains(s)) continue;
                ++inhibitingCnt;
            }
        }
        if (activatingCnt + inhibitingCnt == 0) {
            for (String genName : general) {
                boolean foundInLose;
                boolean foundInGain;
                boolean foundInInhibiting;
                boolean foundInActivating = this.setContainsGeneralTerm(this.activityStr.get(er), genName);
                if (foundInActivating == (foundInInhibiting = this.setContainsGeneralTerm(this.inactivityStr.get(er), genName)) || (foundInGain = this.setContainsGeneralTerm(gainTypes, genName)) == (foundInLose = this.setContainsGeneralTerm(lossTypes, genName))) continue;
                if (foundInActivating && foundInGain) {
                    ++activatingCnt;
                    continue;
                }
                if (foundInInhibiting && foundInLose) {
                    ++activatingCnt;
                    continue;
                }
                if (foundInActivating && foundInLose) {
                    ++inhibitingCnt;
                    continue;
                }
                ++inhibitingCnt;
            }
        }
        if (activatingCnt > 0 && inhibitingCnt > 0) {
            return false;
        }
        return this.activating ? activatingCnt > 0 : inhibitingCnt > 0;
    }

    protected Map<EntityReference, Set<String>> extractModifNames(Map mfMap) {
        HashMap<EntityReference, Set<String>> map = new HashMap<EntityReference, Set<String>>();
        for (Object o : mfMap.keySet()) {
            EntityReference er = (EntityReference)o;
            map.put(er, this.extractModifNames((Set)mfMap.get(er)));
        }
        return map;
    }

    protected Set<String> extractModifNames(Set mfSet) {
        HashSet<String> set = new HashSet<String>();
        for (Object o : mfSet) {
            ModificationFeature mf = (ModificationFeature)o;
            if (mf.getModificationType() == null || mf.getModificationType().getTerm().isEmpty()) continue;
            set.add(mf.getModificationType().getTerm().iterator().next());
        }
        return set;
    }

    protected boolean setContainsGeneralTerm(Set<String> set, String term) {
        for (String s : set) {
            if (!s.contains(term)) continue;
            return true;
        }
        return false;
    }
}

