/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.blocking;

import java.io.Serializable;
import java.util.List;
import org.semanticweb.HermiT.blocking.BlockingStrategy;
import org.semanticweb.HermiT.blocking.BlockingValidator;
import org.semanticweb.HermiT.blocking.DirectBlockingChecker;
import org.semanticweb.HermiT.blocking.ValidatedBlockersCache;
import org.semanticweb.HermiT.blocking.ValidatedSingleDirectBlockingChecker;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.Concept;
import org.semanticweb.HermiT.model.DLClause;
import org.semanticweb.HermiT.model.DLOntology;
import org.semanticweb.HermiT.model.DataRange;
import org.semanticweb.HermiT.model.Variable;
import org.semanticweb.HermiT.monitor.TableauMonitor;
import org.semanticweb.HermiT.tableau.DLClauseEvaluator;
import org.semanticweb.HermiT.tableau.ExtensionManager;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.NodeType;
import org.semanticweb.HermiT.tableau.Tableau;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnywhereValidatedBlocking
implements BlockingStrategy {
    protected final DirectBlockingChecker m_directBlockingChecker;
    protected final ValidatedBlockersCache m_currentBlockersCache;
    protected BlockingValidator m_permanentBlockingValidator;
    protected BlockingValidator m_additionalBlockingValidator;
    protected Tableau m_tableau;
    protected ExtensionManager m_extensionManager;
    protected Node m_firstChangedNode;
    protected Node m_lastValidatedUnchangedNode;
    protected boolean m_useSimpleCore;
    protected final boolean m_hasInverses;

    public AnywhereValidatedBlocking(DirectBlockingChecker directBlockingChecker, boolean bl, boolean bl2) {
        this.m_directBlockingChecker = directBlockingChecker;
        this.m_currentBlockersCache = new ValidatedBlockersCache(this.m_directBlockingChecker);
        this.m_hasInverses = bl;
        this.m_useSimpleCore = bl2;
    }

    @Override
    public void initialize(Tableau tableau) {
        this.m_tableau = tableau;
        this.m_directBlockingChecker.initialize(tableau);
        this.m_extensionManager = this.m_tableau.getExtensionManager();
        this.m_permanentBlockingValidator = new BlockingValidator(this.m_tableau, this.m_tableau.getPermanentDLOntology().getDLClauses());
        this.updateAdditionalBlockingValidator();
    }

    @Override
    public void additionalDLOntologySet(DLOntology dLOntology) {
        this.updateAdditionalBlockingValidator();
    }

    @Override
    public void additionalDLOntologyCleared() {
        this.updateAdditionalBlockingValidator();
    }

    protected void updateAdditionalBlockingValidator() {
        this.m_additionalBlockingValidator = this.m_tableau.getAdditionalHyperresolutionManager() == null ? null : new BlockingValidator(this.m_tableau, this.m_tableau.getAdditionalDLOntology().getDLClauses());
    }

    @Override
    public void clear() {
        this.m_currentBlockersCache.clear();
        this.m_firstChangedNode = null;
        this.m_directBlockingChecker.clear();
        this.m_lastValidatedUnchangedNode = null;
        this.m_permanentBlockingValidator.clear();
        if (this.m_additionalBlockingValidator != null) {
            this.m_additionalBlockingValidator.clear();
        }
    }

    @Override
    public void computeBlocking(boolean bl) {
        if (bl) {
            this.validateBlocks();
        } else {
            this.computePreBlocking();
        }
    }

    public void computePreBlocking() {
        if (this.m_firstChangedNode != null) {
            Node node;
            for (node = this.m_firstChangedNode; node != null; node = node.getNextTableauNode()) {
                this.m_currentBlockersCache.removeNode(node);
            }
            for (node = this.m_firstChangedNode; node != null; node = node.getNextTableauNode()) {
                if (node.isActive() && (this.m_directBlockingChecker.canBeBlocked(node) || this.m_directBlockingChecker.canBeBlocker(node))) {
                    if (this.m_directBlockingChecker.hasBlockingInfoChanged(node) || !node.isDirectlyBlocked() || node.getBlocker().getNodeID() >= this.m_firstChangedNode.getNodeID()) {
                        Node node2 = node.getParent();
                        if (node2 == null) {
                            node.setBlocked(null, false);
                        } else if (node2.isBlocked()) {
                            node.setBlocked(node2, false);
                        } else {
                            Node node3 = null;
                            if (this.m_lastValidatedUnchangedNode == null) {
                                node3 = this.m_currentBlockersCache.getBlocker(node);
                            } else {
                                Node node4 = node.getBlocker();
                                boolean bl = this.m_directBlockingChecker.hasChangedSinceValidation(node);
                                for (Node node5 : this.m_currentBlockersCache.getPossibleBlockers(node)) {
                                    if (!bl && !this.m_directBlockingChecker.hasChangedSinceValidation(node5) && node4 != node5) continue;
                                    node3 = node5;
                                    break;
                                }
                            }
                            node.setBlocked(node3, node3 != null);
                        }
                    }
                    if (!node.isBlocked() && this.m_directBlockingChecker.canBeBlocker(node)) {
                        this.m_currentBlockersCache.addNode(node);
                    }
                }
                this.m_directBlockingChecker.clearBlockingInfoChanged(node);
            }
            this.m_firstChangedNode = null;
        }
    }

    public void validateBlocks() {
        Object object;
        Node node;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        TableauMonitor tableauMonitor = this.m_tableau.getTableauMonitor();
        if (tableauMonitor != null) {
            tableauMonitor.blockingValidationStarted();
        }
        Node node2 = node = this.m_lastValidatedUnchangedNode == null ? this.m_tableau.getFirstTableauNode() : this.m_lastValidatedUnchangedNode;
        while (node != null) {
            this.m_currentBlockersCache.removeNode(node);
            node = node.getNextTableauNode();
        }
        node = node2;
        if (bl) {
            System.out.print("Model size: " + (this.m_tableau.getNumberOfNodesInTableau() - this.m_tableau.getNumberOfMergedOrPrunedNodes()) + " Current ID:");
        }
        Node node3 = null;
        while (node != null) {
            if (node.isActive()) {
                if (node.isBlocked() && node.hasUnprocessedExistentials()) {
                    ++n;
                    if (node.isDirectlyBlocked() && (this.m_directBlockingChecker.hasChangedSinceValidation(node) || this.m_directBlockingChecker.hasChangedSinceValidation(node.getParent()) || this.m_directBlockingChecker.hasChangedSinceValidation(node.getBlocker())) || !node.getParent().isBlocked()) {
                        object = null;
                        Node node4 = node.getBlocker();
                        if (node.isDirectlyBlocked() && node4 != null && this.isBlockValid(node)) {
                            object = node4;
                        }
                        if (object == null) {
                            for (Node node5 : this.m_currentBlockersCache.getPossibleBlockers(node)) {
                                if (node5 == node4) continue;
                                node.setBlocked(node5, true);
                                this.m_permanentBlockingValidator.blockerChanged(node);
                                if (this.m_additionalBlockingValidator != null) {
                                    this.m_additionalBlockingValidator.blockerChanged(node);
                                }
                                if (!this.isBlockValid(node)) continue;
                                object = node5;
                                break;
                            }
                        }
                        if (object == null && node.hasUnprocessedExistentials()) {
                            ++n2;
                            if (node3 == null) {
                                node3 = node;
                            }
                        }
                        node.setBlocked((Node)object, object != null);
                    }
                }
                this.m_lastValidatedUnchangedNode = node;
                if (!node.isBlocked() && this.m_directBlockingChecker.canBeBlocker(node)) {
                    this.m_currentBlockersCache.addNode(node);
                }
            }
            node = node.getNextTableauNode();
        }
        for (node = node2; node != null; node = node.getNextTableauNode()) {
            if (!node.isActive()) continue;
            this.m_directBlockingChecker.setHasChangedSinceValidation(node, false);
            object = (ValidatedSingleDirectBlockingChecker.ValidatedBlockingObject)node.getBlockingObject();
            object.setBlockViolatesParentConstraints(false);
            object.setHasAlreadyBeenChecked(false);
        }
        this.m_firstChangedNode = node3;
        if (tableauMonitor != null) {
            tableauMonitor.blockingValidationFinished(n2);
        }
        if (bl) {
            System.out.println("");
            System.out.println("Checked " + n + " blocked nodes of which " + n2 + " were invalid.");
        }
    }

    protected boolean isBlockValid(Node node) {
        if (this.m_permanentBlockingValidator.isBlockValid(node)) {
            if (this.m_additionalBlockingValidator != null) {
                return this.m_additionalBlockingValidator.isBlockValid(node);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isPermanentAssertion(Concept concept, Node node) {
        return true;
    }

    @Override
    public boolean isPermanentAssertion(DataRange dataRange, Node node) {
        return true;
    }

    protected void validationInfoChanged(Node node) {
        if (node != null) {
            if (this.m_lastValidatedUnchangedNode != null && node.getNodeID() < this.m_lastValidatedUnchangedNode.getNodeID()) {
                this.m_lastValidatedUnchangedNode = node;
            }
            this.m_directBlockingChecker.setHasChangedSinceValidation(node, true);
        }
    }

    @Override
    public void assertionAdded(Concept concept, Node node, boolean bl) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionAdded(concept, node, bl));
        this.validationInfoChanged(node);
        this.validationInfoChanged(node.getParent());
    }

    @Override
    public void assertionCoreSet(Concept concept, Node node) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionAdded(concept, node, true));
        this.validationInfoChanged(node);
        this.validationInfoChanged(node.getParent());
    }

    @Override
    public void assertionRemoved(Concept concept, Node node, boolean bl) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionRemoved(concept, node, bl));
        this.validationInfoChanged(node);
        this.validationInfoChanged(node.getParent());
    }

    @Override
    public void assertionAdded(DataRange dataRange, Node node, boolean bl) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionAdded(dataRange, node, bl));
        this.validationInfoChanged(node);
        this.validationInfoChanged(node.getParent());
    }

    @Override
    public void assertionCoreSet(DataRange dataRange, Node node) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionAdded(dataRange, node, true));
        this.validationInfoChanged(node);
        this.validationInfoChanged(node.getParent());
    }

    @Override
    public void assertionRemoved(DataRange dataRange, Node node, boolean bl) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionRemoved(dataRange, node, bl));
        this.validationInfoChanged(node);
        this.validationInfoChanged(node.getParent());
    }

    @Override
    public void assertionAdded(AtomicRole atomicRole, Node node, Node node2, boolean bl) {
        if (bl) {
            this.updateNodeChange(node);
        }
        if (bl) {
            this.updateNodeChange(node2);
        }
        this.validationInfoChanged(node);
        this.validationInfoChanged(node2);
    }

    @Override
    public void assertionCoreSet(AtomicRole atomicRole, Node node, Node node2) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionAdded(atomicRole, node, node2, true));
        this.validationInfoChanged(node);
        this.validationInfoChanged(node2);
    }

    @Override
    public void assertionRemoved(AtomicRole atomicRole, Node node, Node node2, boolean bl) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionRemoved(atomicRole, node, node2, true));
        this.validationInfoChanged(node);
        this.validationInfoChanged(node2);
    }

    @Override
    public void nodesMerged(Node node, Node node2) {
        Node node3 = node.getParent();
        if (node3 != null && (this.m_directBlockingChecker.canBeBlocker(node3) || this.m_directBlockingChecker.canBeBlocked(node3))) {
            this.validationInfoChanged(node3);
        }
    }

    @Override
    public void nodesUnmerged(Node node, Node node2) {
        Node node3 = node.getParent();
        if (node3 != null && (this.m_directBlockingChecker.canBeBlocker(node3) || this.m_directBlockingChecker.canBeBlocked(node3))) {
            this.validationInfoChanged(node3);
        }
    }

    @Override
    public void nodeStatusChanged(Node node) {
        this.updateNodeChange(node);
        this.validationInfoChanged(node);
        this.validationInfoChanged(node.getParent());
    }

    protected final void updateNodeChange(Node node) {
        if (node != null && (this.m_firstChangedNode == null || node.getNodeID() < this.m_firstChangedNode.getNodeID())) {
            this.m_firstChangedNode = node;
        }
    }

    @Override
    public void nodeInitialized(Node node) {
        this.m_directBlockingChecker.nodeInitialized(node);
    }

    @Override
    public void nodeDestroyed(Node node) {
        this.m_currentBlockersCache.removeNode(node);
        this.m_directBlockingChecker.nodeDestroyed(node);
        if (this.m_firstChangedNode != null && this.m_firstChangedNode.getNodeID() >= node.getNodeID()) {
            this.m_firstChangedNode = null;
        }
        if (this.m_lastValidatedUnchangedNode != null && node.getNodeID() < this.m_lastValidatedUnchangedNode.getNodeID()) {
            this.m_lastValidatedUnchangedNode = node;
        }
    }

    @Override
    public void modelFound() {
    }

    @Override
    public boolean isExact() {
        return false;
    }

    @Override
    public void dlClauseBodyCompiled(List<DLClauseEvaluator.Worker> list, DLClause dLClause, List<Variable> list2, Object[] objectArray, boolean[] blArray) {
        if (this.m_useSimpleCore) {
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = false;
            }
        } else {
            if (dLClause.getHeadLength() == 0) {
                return;
            }
            if (dLClause.getHeadLength() > 1) {
                for (int i = 0; i < blArray.length; ++i) {
                    blArray[i] = true;
                }
            } else {
                for (int i = 0; i < blArray.length; ++i) {
                    blArray[i] = false;
                }
                if (dLClause.getClauseType() == DLClause.ClauseType.CONCEPT_INCLUSION && list2.size() > 1) {
                    list.add(new ComputeCoreVariables(dLClause, list2, objectArray, blArray));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ComputeCoreVariables
    implements DLClauseEvaluator.Worker,
    Serializable {
        private static final long serialVersionUID = 899293772370136783L;
        protected final DLClause m_dlClause;
        protected final List<Variable> m_variables;
        protected final Object[] m_valuesBuffer;
        protected final boolean[] m_coreVariables;

        public ComputeCoreVariables(DLClause dLClause, List<Variable> list, Object[] objectArray, boolean[] blArray) {
            this.m_dlClause = dLClause;
            this.m_variables = list;
            this.m_valuesBuffer = objectArray;
            this.m_coreVariables = blArray;
        }

        public void clear() {
        }

        @Override
        public int execute(int n) {
            Node node;
            int n2;
            Node node2 = null;
            for (n2 = this.m_coreVariables.length - 1; n2 >= 0; --n2) {
                node = (Node)this.m_valuesBuffer[n2];
                if (node.getNodeType() != NodeType.TREE_NODE || node2 != null && node.getTreeDepth() >= node2.getTreeDepth()) continue;
                node2 = node;
            }
            if (node2 != null) {
                for (n2 = this.m_coreVariables.length - 1; n2 >= 0; --n2) {
                    node = (Node)this.m_valuesBuffer[n2];
                    if (node.isRootNode() || node2 == node || node2.getTreeDepth() >= node.getTreeDepth()) continue;
                    this.m_coreVariables[n2] = true;
                }
            }
            return n + 1;
        }

        public String toString() {
            return "Compute core variables";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ViolationStatistic
    implements Comparable<ViolationStatistic> {
        public final String m_violatedConstraint;
        public final Integer m_numberOfViolations;

        public ViolationStatistic(String string, Integer n) {
            this.m_violatedConstraint = string;
            this.m_numberOfViolations = n;
        }

        @Override
        public int compareTo(ViolationStatistic violationStatistic) {
            if (this == violationStatistic) {
                return 0;
            }
            if (violationStatistic == null) {
                throw new NullPointerException("Comparing to a null object is illegal. ");
            }
            if (this.m_numberOfViolations == violationStatistic.m_numberOfViolations) {
                return this.m_violatedConstraint.compareTo(violationStatistic.m_violatedConstraint);
            }
            return violationStatistic.m_numberOfViolations - this.m_numberOfViolations;
        }

        public String toString() {
            return this.m_numberOfViolations + ": " + this.m_violatedConstraint.replaceAll("http://www.co-ode.org/ontologies/galen#", "");
        }
    }
}

