/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public class ReaderDocumentSource
implements OWLOntologyDocumentSource {
    private static int counter = 0;
    public static final String DOCUMENT_IRI_SCHEME = "reader";
    private IRI documentIRI;
    private String buffer;

    public ReaderDocumentSource(Reader reader) {
        this(reader, ReaderDocumentSource.getNextDocumentIRI());
    }

    public static synchronized IRI getNextDocumentIRI() {
        return IRI.create("reader:ontology" + ++counter);
    }

    public ReaderDocumentSource(Reader reader, IRI documentIRI) {
        this.documentIRI = documentIRI;
        this.fillBuffer(reader);
    }

    private void fillBuffer(Reader reader) {
        try {
            int read;
            StringBuilder builder = new StringBuilder();
            char[] tempBuffer = new char[4096];
            while ((read = reader.read(tempBuffer)) != -1) {
                builder.append(tempBuffer, 0, read);
            }
            this.buffer = builder.toString();
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    public IRI getDocumentIRI() {
        return this.documentIRI;
    }

    public Reader getReader() {
        return new StringReader(this.buffer);
    }

    public boolean isReaderAvailable() {
        return true;
    }

    public boolean isInputStreamAvailable() {
        return false;
    }

    public InputStream getInputStream() {
        throw new OWLRuntimeException("InputStream not available.  Check with ReaderDocumentSource.isReaderAvailable() first!");
    }
}

