test_isolationWindow <- function() {
    library("msdata")
    f <- msdata::proteomics(full.names = TRUE, pattern = "TMT_")
    rw1 <- openMSfile(f, backend = "Ramp")
    rw2 <- openMSfile(f, backend = "pwiz")
    i1 <- isolationWindow(f)
    i2 <- isolationWindow(rw1)
    i3 <- isolationWindow(rw2)
    checkEquals(i1, i2)
    checkEquals(i1, i3)
    i1 <- isolationWindow(f, unique = FALSE)
    i2 <- isolationWindow(rw1, unique = FALSE)
    i3 <- isolationWindow(rw2, unique = FALSE)
    checkEquals(i1, i2)
    checkEquals(i1, i3)
    i1 <- isolationWindow(c(f, f), unique = FALSE)
    checkEquals(length(i1), 2L)
    checkEquals(i1[[1]], i1[[2]])
    hd <- header(rw1)
    checkEquals(sum(hd$msLevel == 2), nrow(i1[[1]]))
}
