### R code from vignette source 'matter.Rnw'

###################################################
### code chunk number 1: matter.Rnw:10-11
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: matter.Rnw:33-35 (eval = FALSE)
###################################################
## source("https://bioconductor.org/biocLite.R")
## biocLite("matter")


###################################################
### code chunk number 3: matter.Rnw:40-43
###################################################
options(width=72)
library(matter)
data(matter_ex)


###################################################
### code chunk number 4: matter.Rnw:50-53
###################################################
x <- matter_mat(data=1:50, nrow=10, ncol=5)
x
x[]


###################################################
### code chunk number 5: matter.Rnw:60-62
###################################################
x[1:4,]
x[,3:4]


###################################################
### code chunk number 6: matter.Rnw:67-70
###################################################
rownames(x) <- 1:10
colnames(x) <- letters[1:5]
x[]


###################################################
### code chunk number 7: matter.Rnw:75-80
###################################################
colSums(x)
colSums(x[])

colVars(x)
apply(x, 2, var)


###################################################
### code chunk number 8: matter.Rnw:87-95
###################################################
y <- matter_mat(data=51:100, nrow=10, ncol=5)

paths(x)
paths(y)

z <- cbind(x, y)
z
z[]


###################################################
### code chunk number 9: matter.Rnw:102-105
###################################################
t(x)

rbind(t(x), t(y))


###################################################
### code chunk number 10: matter.Rnw:112-113
###################################################
adata(x)


###################################################
### code chunk number 11: matter.Rnw:120-124
###################################################
xsub <- matter_mat(offset=c(40, 120, 200, 280, 360),
            extent=rep(5,5), paths=paths(x))
x[6:10,]
xsub[]


###################################################
### code chunk number 12: matter.Rnw:129-133
###################################################
x2 <- matter_vec(offset=80, extent=10, paths=paths(x))
y3 <- matter_vec(offset=160, extent=10, paths=paths(y))
cbind(x2, y3)[]
cbind(x[,2], y[,3])


###################################################
### code chunk number 13: setup-bigglm
###################################################
set.seed(81216)
n <- 15e6
p <- 9

b <- runif(p)
names(b) <- paste0("x", 1:p)

data <- matter_mat(nrow=n, ncol=p + 1)

colnames(data) <- c(names(b), "y")

data[,p + 1] <- rnorm(n)
for ( i in 1:p ) {
  xi <- rnorm(n)
  data[,i] <- xi
  data[,p + 1] <- data[,p + 1] + xi * b[i]
}

data

head(data)


###################################################
### code chunk number 14: summary-stats
###################################################
apply(data, 2, mean)

apply(data, 2, var)


###################################################
### code chunk number 15: fit-bigglm (eval = FALSE)
###################################################
## fm <- as.formula(paste0("y ~ ", paste(names(b), collapse=" + ")))
## bigglm.out <- bigglm(fm, data=data, chunksize=10000)


###################################################
### code chunk number 16: coef
###################################################
summary(bigglm.out)

cbind(coef(bigglm.out)[-1], b)


###################################################
### code chunk number 17: setup-prcomp
###################################################
set.seed(81216)
n <- 15e5
p <- 100

data <- matter_mat(nrow=n, ncol=p)

for ( i in 1:10 )
  data[,i] <- (1:n)/n + rnorm(n)
for ( i in 11:20 )
  data[,i] <- (n:1)/n + rnorm(n)
for ( i in 21:p )
  data[,i] <- rnorm(n)

data


###################################################
### code chunk number 18: plot-var
###################################################
var.out <- colVars(data)
plot(var.out, type='h', ylab="Variance")


###################################################
### code chunk number 19: fit-prcomp (eval = FALSE)
###################################################
## prcomp.out <- prcomp(data, n=2, center=FALSE, scale.=FALSE)


###################################################
### code chunk number 20: plot-pc1
###################################################
plot(prcomp.out$rotation[,1], type='h', ylab="PC 1")


###################################################
### code chunk number 21: plot-pc2
###################################################
plot(prcomp.out$rotation[,2], type='h', ylab="PC 2")


###################################################
### code chunk number 22: matter.Rnw:437-438
###################################################
var.out <- colVars(data)
plot(var.out, type='h', ylab="Variance")


###################################################
### code chunk number 23: matter.Rnw:445-446
###################################################
plot(prcomp.out$rotation[,1], type='h', ylab="PC 1")


###################################################
### code chunk number 24: matter.Rnw:453-454
###################################################
plot(prcomp.out$rotation[,2], type='h', ylab="PC 2")


###################################################
### code chunk number 25: matter.Rnw:540-541
###################################################
toLatex(sessionInfo())


