## ----style, echo = FALSE, results = 'asis'-------------------------------
BiocStyle::markdown()
suppressPackageStartupMessages({
library(gwascat)
})

## ----getg----------------------------------------------------------------
library(gwascat)
data(efo.obo.g)
efo.obo.g
sn = head(nodes(efo.obo.g))
sn

## ----procdef-------------------------------------------------------------
nd = nodeData(efo.obo.g)
alldef = sapply(nd, function(x) unlist(x[["def"]]))
allnames = sapply(nd, function(x) unlist(x[["name"]]))
alld2 = sapply(alldef, function(x) if(is.null(x)) return(" ") else x[1])
mydf = data.frame(id = names(allnames), concept=as.character(allnames), def=unlist(alld2))

## ----limtab--------------------------------------------------------------
limdf = mydf[ grep("autoimm", mydf$def, ignore.case=TRUE), ]
library(DT)
suppressWarnings({
datatable(limdf, rownames=FALSE, options=list(pageLength=5))
})

## ----lkg-----------------------------------------------------------------
nodeData(efo.obo.g, "EFO:0000540")
ue = ugraph(efo.obo.g)
neighISD = adj(ue, "EFO:0000540")[[1]]
sapply(nodeData(subGraph(neighISD, efo.obo.g)), "[[", "name")

## ----lkggg---------------------------------------------------------------
library(RBGL)
p = sp.between( efo.obo.g, "EFO:0000685", "EFO:0000001")
sapply(nodeData(subGraph(p[[1]]$path_detail, efo.obo.g)), "[[", "name")

## ----lkef----------------------------------------------------------------
data(ebicat38)
names(mcols(ebicat38))
adinds = grep("autoimmu", ebicat38$MAPPED_TRAIT)
adgr = ebicat38[adinds]
adgr
mcols(adgr)[, c("MAPPED_TRAIT", "MAPPED_TRAIT_URI")]

